/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.cas;

import java.net.URI;
import org.apache.syncope.sra.security.cas.CASAuthenticationToken;
import org.apache.syncope.sra.security.cas.CASUtils;
import org.apache.syncope.sra.security.web.server.DoNothingIfCommittedServerRedirectStrategy;
import org.apache.syncope.sra.session.SessionUtils;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.cas.client.validation.json.Cas30JsonServiceTicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import reactor.core.publisher.Mono;

public class CASAuthenticationWebFilter
extends AuthenticationWebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CASAuthenticationWebFilter.class);
    private final Protocol protocol;
    private final TicketValidator ticketValidator;

    public CASAuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager, Protocol protocol, String casServerUrlPrefix) {
        super(authenticationManager);
        this.protocol = protocol;
        this.ticketValidator = new Cas30JsonServiceTicketValidator(casServerUrlPrefix);
        this.setRequiresAuthenticationMatcher((ServerWebExchangeMatcher)new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{CASUtils.ticketAvailable(protocol), new NegatedServerWebExchangeMatcher(SessionUtils.authInSession())}));
        this.setServerAuthenticationConverter(this.validateAssertion());
        this.setAuthenticationSuccessHandler(this.redirectToInitialRequestURI());
    }

    private ServerAuthenticationConverter validateAssertion() {
        return exchange -> CASUtils.retrieveTicketFromRequest(exchange, this.protocol).flatMap(ticket -> {
            try {
                String serviceUrl = CASUtils.constructServiceUrl(exchange, this.protocol);
                LOG.debug("Constructed service url: {}", (Object)serviceUrl);
                Assertion assertion = this.ticketValidator.validate(ticket, CASUtils.constructServiceUrl(exchange, this.protocol));
                return Mono.just((Object)((Object)new CASAuthenticationToken(assertion)));
            }
            catch (TicketValidationException e) {
                LOG.error("Could not validate {}", ticket, (Object)e);
                throw new BadCredentialsException("Could not validate " + ticket);
            }
        });
    }

    private ServerAuthenticationSuccessHandler redirectToInitialRequestURI() {
        return new ServerAuthenticationSuccessHandler(){
            private final ServerRedirectStrategy redirectStrategy = new DoNothingIfCommittedServerRedirectStrategy();

            public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
                return webFilterExchange.getExchange().getSession().flatMap(session -> this.redirectStrategy.sendRedirect(webFilterExchange.getExchange(), (URI)session.getRequiredAttribute("INITIAL_REQUEST_URI")));
            }
        };
    }
}

