/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.sra.SRAProperties;
import org.apache.syncope.sra.security.CsrfRouteMatcher;
import org.apache.syncope.sra.security.LogoutRouteMatcher;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.apache.syncope.sra.security.cas.CASSecurityConfigUtils;
import org.apache.syncope.sra.security.oauth2.OAuth2SecurityConfigUtils;
import org.apache.syncope.sra.security.pac4j.NoOpLogoutHandler;
import org.apache.syncope.sra.security.saml2.SAML2SecurityConfigUtils;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.security.reactive.EndpointRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@EnableWebFluxSecurity
@Configuration(proxyBeanMethods=false)
public class SecurityConfig {
    @Bean
    @Order(value=-2147483648)
    public WebFilter writeableHeaders() {
        return (exchange, chain) -> {
            final HttpHeaders writeableHeaders = HttpHeaders.writableHttpHeaders((HttpHeaders)exchange.getRequest().getHeaders());
            ServerHttpRequestDecorator writeableRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    return writeableHeaders;
                }
            };
            return chain.filter(exchange.mutate().request((ServerHttpRequest)writeableRequest).build());
        };
    }

    @Bean
    @Order(value=0)
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="SAML2")
    public SecurityWebFilterChain saml2SecurityFilterChain(ServerHttpSecurity http) {
        ServerWebExchangeMatcher metadataMatcher = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.GET, (String[])new String[]{"/saml2/metadata"});
        return http.securityMatcher(metadataMatcher).authorizeExchange().anyExchange().permitAll().and().csrf().requireCsrfProtectionMatcher((ServerWebExchangeMatcher)new NegatedServerWebExchangeMatcher(metadataMatcher)).and().build();
    }

    @ConditionalOnMissingBean
    @Bean
    @Order(value=1)
    public SecurityWebFilterChain actuatorSecurityFilterChain(ServerHttpSecurity http) {
        EndpointRequest.EndpointServerWebExchangeMatcher actuatorMatcher = EndpointRequest.toAnyEndpoint();
        return http.securityMatcher((ServerWebExchangeMatcher)actuatorMatcher).authorizeExchange().anyExchange().authenticated().and().httpBasic().and().csrf().requireCsrfProtectionMatcher((ServerWebExchangeMatcher)new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)actuatorMatcher)).and().build();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReactiveUserDetailsService actuatorUserDetailsService(SRAProperties props) {
        UserDetails user = User.builder().username(props.getAnonymousUser()).password("{noop}" + props.getAnonymousKey()).roles(new String[]{"ANONYMOUS"}).build();
        return new MapReactiveUserDetailsService(new UserDetails[]{user});
    }

    @Bean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OIDC")
    public ClientRegistration oidcClientRegistration(SRAProperties props) {
        return ClientRegistrations.fromOidcIssuerLocation((String)props.getOidc().getConfiguration()).registrationId(SRAProperties.AMType.OIDC.name()).clientId(props.getOidc().getClientId()).clientSecret(props.getOidc().getClientSecret()).scope((String[])props.getOidc().getScopes().toArray(String[]::new)).build();
    }

    @Bean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OIDC")
    public ReactiveClientRegistrationRepository oidcClientRegistrationRepository(@Qualifier(value="oidcClientRegistration") ClientRegistration oidcClientRegistration) {
        return new InMemoryReactiveClientRegistrationRepository(new ClientRegistration[]{oidcClientRegistration});
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OIDC")
    public OAuth2TokenValidator<Jwt> oidcJWTValidator(SRAProperties props) {
        return JwtValidators.createDefaultWithIssuer((String)props.getOidc().getConfiguration());
    }

    @Bean
    @ConditionalOnMissingBean
    public Converter<Map<String, Object>, Map<String, Object>> jwtClaimSetConverter() {
        return MappedJwtClaimSetConverter.withDefaults(Map.of());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OIDC")
    public ReactiveJwtDecoder oidcJWTDecoder(@Qualifier(value="oidcClientRegistration") ClientRegistration oidcClientRegistration, @Qualifier(value="oidcJWTValidator") OAuth2TokenValidator<Jwt> oidcJWTValidator, @Qualifier(value="jwtClaimSetConverter") Converter<Map<String, Object>, Map<String, Object>> jwtClaimSetConverter) {
        String jwkSetUri = oidcClientRegistration.getProviderDetails().getJwkSetUri();
        NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SignatureAlgorithm.RS256).jwsAlgorithm(SignatureAlgorithm.RS512).build();
        jwtDecoder.setJwtValidator(oidcJWTValidator);
        jwtDecoder.setClaimSetConverter(jwtClaimSetConverter);
        return jwtDecoder;
    }

    @Bean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OAUTH2")
    public ClientRegistration oauth2ClientRegistration(SRAProperties props) {
        return ClientRegistration.withRegistrationId((String)SRAProperties.AMType.OAUTH2.name()).redirectUri("{baseUrl}/{action}/oauth2/code/{registrationId}").tokenUri(props.getOauth2().getTokenUri()).authorizationUri(props.getOauth2().getAuthorizationUri()).userInfoUri(props.getOauth2().getUserInfoUri()).userNameAttributeName(props.getOauth2().getUserNameAttributeName()).clientId(props.getOauth2().getClientId()).clientSecret(props.getOauth2().getClientSecret()).scope((String[])props.getOauth2().getScopes().toArray(String[]::new)).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).jwkSetUri(props.getOauth2().getJwkSetUri()).build();
    }

    @Bean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OAUTH2")
    public ReactiveClientRegistrationRepository oauth2ClientRegistrationRepository(@Qualifier(value="oauth2ClientRegistration") ClientRegistration oauth2ClientRegistration) {
        return new InMemoryReactiveClientRegistrationRepository(new ClientRegistration[]{oauth2ClientRegistration});
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OAUTH2")
    public OAuth2TokenValidator<Jwt> oauth2JWTValidator(SRAProperties props) {
        return props.getOauth2().getIssuer() == null ? JwtValidators.createDefault() : JwtValidators.createDefaultWithIssuer((String)props.getOauth2().getIssuer());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="OAUTH2")
    public ReactiveJwtDecoder oauth2JWTDecoder(@Qualifier(value="oauth2ClientRegistration") ClientRegistration oauth2ClientRegistration, @Qualifier(value="oauth2JWTValidator") OAuth2TokenValidator<Jwt> oauth2JWTValidator, @Qualifier(value="jwtClaimSetConverter") Converter<Map<String, Object>, Map<String, Object>> jwtClaimSetConverter) {
        String jwkSetUri = oauth2ClientRegistration.getProviderDetails().getJwkSetUri();
        NimbusReactiveJwtDecoder jwtDecoder = StringUtils.isBlank((CharSequence)jwkSetUri) ? new NimbusReactiveJwtDecoder(jwt -> {
            try {
                return Mono.just((Object)jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                return Mono.error((Throwable)e);
            }
        }) : NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).build();
        jwtDecoder.setJwtValidator(oauth2JWTValidator);
        jwtDecoder.setClaimSetConverter(jwtClaimSetConverter);
        return jwtDecoder;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sra", name={"am-type"}, havingValue="SAML2")
    public SAML2Client saml2Client(ResourcePatternResolver resourceResolver, SRAProperties props) {
        final SAML2Configuration cfg = new SAML2Configuration(resourceResolver.getResource(props.getSaml2().getKeystore()), props.getSaml2().getKeystoreStorePass(), props.getSaml2().getKeystoreKeypass(), resourceResolver.getResource(props.getSaml2().getIdpMetadata()));
        cfg.setKeystoreType(props.getSaml2().getKeystoreType());
        if (cfg.getKeystoreResource() instanceof FileUrlResource) {
            cfg.setKeystoreGenerator((SAML2KeystoreGenerator)new BaseSAML2KeystoreGenerator(cfg){

                protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
                }

                public InputStream retrieve() throws Exception {
                    return cfg.getKeystoreResource().getInputStream();
                }
            });
        }
        cfg.setAuthnRequestBindingType(props.getSaml2().getAuthnRequestBinding().getUri());
        cfg.setResponseBindingType(SAML2BindingType.POST.getUri());
        cfg.setSpLogoutRequestBindingType(props.getSaml2().getLogoutRequestBinding().getUri());
        cfg.setSpLogoutResponseBindingType(props.getSaml2().getLogoutResponseBinding().getUri());
        cfg.setServiceProviderEntityId(props.getSaml2().getEntityId());
        cfg.setWantsAssertionsSigned(true);
        cfg.setAuthnRequestSigned(true);
        cfg.setSpLogoutRequestSigned(true);
        cfg.setServiceProviderMetadataResourceFilepath(props.getSaml2().getSpMetadataFilePath());
        cfg.setMaximumAuthenticationLifetime(props.getSaml2().getMaximumAuthenticationLifetime());
        cfg.setAcceptedSkew(props.getSaml2().getAcceptedSkew());
        cfg.setLogoutHandler((LogoutHandler)new NoOpLogoutHandler());
        SAML2Client saml2Client = new SAML2Client(cfg);
        saml2Client.setName(SRAProperties.AMType.SAML2.name());
        saml2Client.setCallbackUrl(props.getSaml2().getEntityId() + "/login/saml2/sso");
        saml2Client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        saml2Client.init();
        return saml2Client;
    }

    @Bean
    @Order(value=2)
    @ConditionalOnProperty(prefix="sra", name={"am-type"})
    public SecurityWebFilterChain routesSecurityFilterChain(@Qualifier(value="saml2Client") ObjectProvider<SAML2Client> saml2Client, SRAProperties props, ServerHttpSecurity http, CacheManager cacheManager, LogoutRouteMatcher logoutRouteMatcher, PublicRouteMatcher publicRouteMatcher, CsrfRouteMatcher csrfRouteMatcher, ConfigurableApplicationContext ctx) {
        ServerHttpSecurity.AuthorizeExchangeSpec builder = ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().matchers(new ServerWebExchangeMatcher[]{publicRouteMatcher})).permitAll().anyExchange().authenticated();
        switch (props.getAmType()) {
            case OIDC: 
            case OAUTH2: {
                OAuth2SecurityConfigUtils.forLogin(http, props.getAmType(), (ApplicationContext)ctx);
                OAuth2SecurityConfigUtils.forLogout(builder, props.getAmType(), cacheManager, logoutRouteMatcher, ctx);
                http.oauth2ResourceServer().jwt().jwtDecoder((ReactiveJwtDecoder)ctx.getBean(ReactiveJwtDecoder.class));
                break;
            }
            case SAML2: {
                saml2Client.ifAvailable(client -> {
                    SAML2SecurityConfigUtils.forLogin(http, client, publicRouteMatcher);
                    SAML2SecurityConfigUtils.forLogout(builder, client, cacheManager, logoutRouteMatcher, ctx);
                });
                break;
            }
            case CAS: {
                CASSecurityConfigUtils.forLogin(http, props.getCas().getProtocol(), props.getCas().getServerPrefix(), publicRouteMatcher);
                CASSecurityConfigUtils.forLogout(builder, cacheManager, props.getCas().getServerPrefix(), logoutRouteMatcher, ctx);
                break;
            }
        }
        return builder.and().csrf().requireCsrfProtectionMatcher((ServerWebExchangeMatcher)csrfRouteMatcher).and().build();
    }
}

