/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.logic.scim.SearchCondConverter;
import org.apache.syncope.core.logic.scim.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

abstract class AbstractSCIMService<R extends SCIMResource> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSCIMService.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected MessageContext messageContext;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final UserLogic userLogic;
    protected final GroupLogic groupLogic;
    protected final SCIMDataBinder binder;
    protected final SCIMConfManager confManager;

    protected AbstractSCIMService(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.userLogic = userLogic;
        this.groupLogic = groupLogic;
        this.binder = binder;
        this.confManager = confManager;
    }

    protected AnyDAO<?> anyDAO(Resource type) {
        switch (type) {
            case User: {
                return this.userDAO;
            }
            case Group: {
                return this.groupDAO;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected AbstractAnyLogic<?, ?, ?> anyLogic(Resource type) {
        switch (type) {
            case User: {
                return this.userLogic;
            }
            case Group: {
                return this.groupLogic;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected Response createResponse(String key, SCIMResource resource) {
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected Response updateResponse(String key, SCIMResource resource, boolean patch) {
        if (patch) {
            Response.ResponseBuilder builder = switch (this.getPreference()) {
                case Preference.RETURN_NO_CONTENT -> Response.noContent();
                default -> Response.ok((Object)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)this.getResource(key));
            };
            if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
                builder.header("Preference-Applied", (Object)this.getPreference().toString());
            }
            return builder.build();
        }
        return Response.ok((Object)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected abstract SCIMResource getResource(String var1);

    protected Response.ResponseBuilder checkETag(Resource resource, String key) {
        OffsetDateTime lastChange = (OffsetDateTime)this.anyDAO(resource).findLastChange(key).orElseThrow(() -> new NotFoundException("Resource" + key + " not found"));
        return this.messageContext.getRequest().evaluatePreconditions(new EntityTag(String.valueOf(lastChange.toInstant().toEpochMilli()), true));
    }

    protected ListResponse<R> doSearch(Resource type, SCIMSearchRequest request) {
        int page;
        if (type == null) {
            throw new UnsupportedOperationException();
        }
        if (request.getCount() > this.confManager.get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results requested");
        }
        SearchCondVisitor visitor = new SearchCondVisitor(type, this.confManager.get());
        int startIndex = request.getStartIndex() <= 1 ? 1 : request.getStartIndex();
        int itemsPerPage = request.getCount() <= 1 ? 500 : request.getCount();
        int n = page = request.getStartIndex() <= 0 ? 0 : request.getStartIndex() / itemsPerPage;
        if ((startIndex - 1) % itemsPerPage != 0) {
            throw new BadRequestException(ErrorType.invalidValue, "Unsupported startIndex value provided");
        }
        List<Object> sort = request.getSortBy() == null ? List.of() : List.of(new Sort.Order(request.getSortOrder() == null || request.getSortOrder() == SortOrder.ascending ? Sort.Direction.ASC : Sort.Direction.DESC, visitor.createAttrCond(request.getSortBy()).getSchema()));
        Page result = this.anyLogic(type).search(StringUtils.isBlank((CharSequence)request.getFilter()) ? null : SearchCondConverter.convert((SearchCondVisitor)visitor, (String)request.getFilter()), (Pageable)PageRequest.of((int)page, (int)itemsPerPage, (Sort)Sort.by(sort)), "/", true, true);
        if (result.getTotalElements() > (long)this.confManager.get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results found");
        }
        ListResponse response = new ListResponse(result.getTotalElements(), (long)startIndex, (long)itemsPerPage);
        result.forEach(anyTO -> {
            SCIMUser resource = null;
            if (anyTO instanceof UserTO) {
                UserTO userTO = (UserTO)anyTO;
                resource = this.binder.toSCIMUser(userTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            } else if (anyTO instanceof GroupTO) {
                GroupTO groupTO = (GroupTO)anyTO;
                resource = this.binder.toSCIMGroup(groupTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            }
            if (resource != null) {
                response.getResources().add(resource);
            }
        });
        return response;
    }

    protected Preference getPreference() {
        return Preference.fromString((String)this.messageContext.getHttpServletRequest().getHeader("Prefer"));
    }
}

