/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.syncope.common.lib.saml2.SAML2LoginResponse;
import org.apache.syncope.common.lib.saml2.SAML2Request;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="SAML 2.0 SP4UI")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="saml2sp4ui/serviceProvider")
public interface SAML2SP4UIService
extends JAXRSService {
    @GET
    @Produces(value={"application/xml"})
    public Response getMetadata(@QueryParam(value="spEntityID") String var1, @QueryParam(value="urlContext") String var2);

    @POST
    @Path(value="loginRequest")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SAML2Request createLoginRequest(@QueryParam(value="spEntityID") String var1, @QueryParam(value="urlContext") String var2, @QueryParam(value="idpEntityID") String var3, @DefaultValue(value="false") @QueryParam(value="reauth") boolean var4);

    @POST
    @Path(value="loginResponse")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SAML2LoginResponse validateLoginResponse(SAML2Response var1);

    @POST
    @Path(value="logoutRequest")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SAML2Request createLogoutRequest(@QueryParam(value="spEntityID") String var1, @QueryParam(value="urlContext") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="logoutResponse")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void validateLogoutResponse(SAML2Response var1);
}

