/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.SAML2SP4UIIdPTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class SAML2ClientCache {
    protected static final Logger LOG = LoggerFactory.getLogger(SAML2ClientCache.class);
    protected static Path METADATA_PATH;
    protected final List<SAML2Client> cache = Collections.synchronizedList(new ArrayList());

    public static Optional<String> getSPMetadataPath(String spEntityID) {
        String entityIDPath = StringUtils.replaceChars((String)StringUtils.removeStart((String)StringUtils.removeStart((String)spEntityID, (String)"https://"), (String)"http://"), (String)":/", (String)"__");
        return Optional.ofNullable(METADATA_PATH).map(path -> path.resolve(entityIDPath).toAbsolutePath().toString());
    }

    public static SAML2SP4UIIdPTO importMetadata(InputStream metadata, SAML2Configuration cfg) throws IOException {
        cfg.setIdentityProviderMetadataResource((Resource)new ByteArrayResource(IOUtils.readBytesFromStream((InputStream)metadata)));
        SAML2IdentityProviderMetadataResolver metadataResolver = new SAML2IdentityProviderMetadataResolver(cfg);
        metadataResolver.init();
        cfg.setIdentityProviderMetadataResolver((SAML2MetadataResolver)metadataResolver);
        String entityId = metadataResolver.getEntityId();
        SAML2SP4UIIdPTO idpTO = new SAML2SP4UIIdPTO();
        idpTO.setEntityID(entityId);
        idpTO.setName(entityId);
        EntityDescriptor entityDescriptor = (EntityDescriptor)metadataResolver.getEntityDescriptorElement();
        if (idpTO.getBindingType() == null) {
            entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleSignOnServices().forEach(sso -> {
                if (SAML2BindingType.POST.getUri().equals(sso.getBinding())) {
                    idpTO.setBindingType(SAML2BindingType.POST);
                } else if (SAML2BindingType.REDIRECT.getUri().equals(sso.getBinding())) {
                    idpTO.setBindingType(SAML2BindingType.REDIRECT);
                }
            });
        }
        if (idpTO.getBindingType() == null) {
            throw new IllegalArgumentException("Neither POST nor REDIRECT artifacts supported by " + entityId);
        }
        cfg.setAuthnRequestBindingType(idpTO.getBindingType().getUri());
        cfg.setResponseBindingType(SAML2BindingType.POST.getUri());
        cfg.setSpLogoutRequestBindingType(idpTO.getBindingType().getUri());
        cfg.setSpLogoutResponseBindingType(idpTO.getBindingType().getUri());
        entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices().stream().filter(slo -> SAML2BindingType.POST.getUri().equals(slo.getBinding()) || SAML2BindingType.REDIRECT.getUri().equals(slo.getBinding())).findFirst().ifPresent(slo -> idpTO.setLogoutSupported(true));
        idpTO.setMetadata(Base64.getEncoder().encodeToString(metadataResolver.getMetadata().getBytes()));
        Item connObjectKeyItem = new Item();
        connObjectKeyItem.setIntAttrName("username");
        connObjectKeyItem.setExtAttrName("NameID");
        idpTO.setConnObjectKeyItem(connObjectKeyItem);
        return idpTO;
    }

    public Optional<SAML2Client> get(String idpEntityID, String spEntityID) {
        return this.cache.stream().filter(c -> idpEntityID.equals(c.getIdentityProviderResolvedEntityId()) && spEntityID.equals(c.getConfiguration().getServiceProviderEntityId())).findFirst();
    }

    public SAML2Client add(SAML2SP4UIIdP idp, SAML2Configuration cfg, String spEntityID, String callbackUrl) {
        cfg.setIdentityProviderEntityId(idp.getEntityID());
        cfg.setIdentityProviderMetadataResource((Resource)new ByteArrayResource(idp.getMetadata()));
        SAML2IdentityProviderMetadataResolver metadataResolver = new SAML2IdentityProviderMetadataResolver(cfg);
        metadataResolver.init();
        cfg.setIdentityProviderMetadataResolver((SAML2MetadataResolver)metadataResolver);
        cfg.setServiceProviderEntityId(spEntityID);
        SAML2ClientCache.getSPMetadataPath(spEntityID).ifPresent(arg_0 -> ((SAML2Configuration)cfg).setServiceProviderMetadataResourceFilepath(arg_0));
        SAML2Client saml2Client = new SAML2Client(cfg);
        saml2Client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        saml2Client.setCallbackUrl(callbackUrl);
        saml2Client.init();
        this.cache.add(saml2Client);
        return saml2Client;
    }

    public boolean removeAll(String idpEntityID) {
        return this.cache.removeIf(c -> idpEntityID.equals(c.getIdentityProviderResolvedEntityId()));
    }

    static {
        try {
            METADATA_PATH = Files.createTempDirectory("saml2sp4ui-", new FileAttribute[0]).toAbsolutePath();
        }
        catch (IOException e) {
            LOG.error("Could not create a temp directory to store metadata files", (Throwable)e);
        }
    }
}

