/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.saml2.SAML2LoginResponse;
import org.apache.syncope.common.lib.saml2.SAML2Request;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.logic.AbstractSAML2SP4UILogic;
import org.apache.syncope.core.logic.SAML2SP4UIProperties;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.saml2.NoOpSessionStore;
import org.apache.syncope.core.logic.saml2.SAML2ClientCache;
import org.apache.syncope.core.logic.saml2.SAML2SP4UIContext;
import org.apache.syncope.core.logic.saml2.SAML2SP4UIUserManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2SP4UIIdPDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.apache.syncope.core.provisioning.api.RequestedAuthnContextProvider;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.Encryptor;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.logout.NoLogoutActionBuilder;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.redirect.SAML2RedirectionActionBuilder;
import org.pac4j.saml.sso.impl.SAML2AuthnRequestBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.ResourceUtils;

public class SAML2SP4UILogic
extends AbstractSAML2SP4UILogic {
    protected static final String JWT_CLAIM_IDP_ENTITYID = "IDP_ENTITYID";
    protected static final String JWT_CLAIM_NAMEID_FORMAT = "NAMEID_FORMAT";
    protected static final String JWT_CLAIM_NAMEID_VALUE = "NAMEID_VALUE";
    protected static final String JWT_CLAIM_SESSIONINDEX = "SESSIONINDEX";
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected final AccessTokenDataBinder accessTokenDataBinder;
    protected final SAML2ClientCache saml2ClientCacheLogin;
    protected final SAML2ClientCache saml2ClientCacheLogout;
    protected final SAML2SP4UIUserManager userManager;
    protected final SAML2SP4UIIdPDAO idpDAO;
    protected final AuthDataAccessor authDataAccessor;
    protected final Map<String, String> metadataCache = new ConcurrentHashMap<String, String>();
    protected final Map<String, RequestedAuthnContextProvider> perContextRACP = new ConcurrentHashMap<String, RequestedAuthnContextProvider>();

    public SAML2SP4UILogic(SAML2SP4UIProperties props, ResourcePatternResolver resourceResolver, AccessTokenDataBinder accessTokenDataBinder, SAML2ClientCache saml2ClientCacheLogin, SAML2ClientCache saml2ClientCacheLogout, SAML2SP4UIUserManager userManager, SAML2SP4UIIdPDAO idpDAO, AuthDataAccessor authDataAccessor) {
        super(props, resourceResolver);
        this.accessTokenDataBinder = accessTokenDataBinder;
        this.saml2ClientCacheLogin = saml2ClientCacheLogin;
        this.saml2ClientCacheLogout = saml2ClientCacheLogout;
        this.userManager = userManager;
        this.idpDAO = idpDAO;
        this.authDataAccessor = authDataAccessor;
    }

    protected static String validateUrl(String url) {
        boolean isValid = true;
        if (url.contains("..")) {
            isValid = false;
        }
        if (isValid) {
            isValid = ResourceUtils.isUrl((String)url);
        }
        if (!isValid) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("Invalid URL: " + url);
            throw sce;
        }
        return url;
    }

    protected static String getCallbackUrl(String spEntityID, String urlContext) {
        return SAML2SP4UILogic.validateUrl(spEntityID + urlContext + "/assertion-consumer");
    }

    @PreAuthorize(value="isAuthenticated()")
    public void getMetadata(String spEntityID, String urlContext, OutputStream os) {
        String metadata = this.metadataCache.get(spEntityID + urlContext);
        if (metadata == null) {
            SAML2Configuration cfg = this.newSAML2Configuration();
            cfg.setServiceProviderEntityId(spEntityID);
            cfg.setCallbackUrl(SAML2SP4UILogic.getCallbackUrl(spEntityID, urlContext));
            SAML2ClientCache.getSPMetadataPath(spEntityID).ifPresent(arg_0 -> ((SAML2Configuration)cfg).setServiceProviderMetadataResourceFilepath(arg_0));
            EntityDescriptor entityDescriptor = (EntityDescriptor)new SAML2ServiceProviderMetadataResolver(cfg).getEntityDescriptorElement();
            AssertionConsumerService postACS = (AssertionConsumerService)entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getAssertionConsumerServices().get(0);
            AssertionConsumerService redirectACS = new AssertionConsumerServiceBuilder().buildObject();
            BeanUtils.copyProperties((Object)postACS, (Object)redirectACS);
            postACS.setBinding(SAML2BindingType.REDIRECT.getUri());
            postACS.setIndex(Integer.valueOf(1));
            entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getAssertionConsumerServices().add(redirectACS);
            entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices().removeIf(slo -> !SAML2BindingType.POST.getUri().equals(slo.getBinding()) && !SAML2BindingType.REDIRECT.getUri().equals(slo.getBinding()));
            entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices().forEach(slo -> slo.setLocation(SAML2SP4UILogic.getCallbackUrl(spEntityID, urlContext).replace("/assertion-consumer", "/logout")));
            try {
                metadata = cfg.toMetadataGenerator().getMetadata(entityDescriptor);
                this.metadataCache.put(spEntityID + urlContext, metadata);
            }
            catch (Exception e) {
                LOG.error("While generating SP metadata", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        try (OutputStreamWriter osw = new OutputStreamWriter(os);){
            osw.write(metadata);
        }
        catch (Exception e) {
            LOG.error("While getting SP metadata", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    protected SAML2Client getSAML2Client(SAML2ClientCache saml2ClientCache, SAML2SP4UIIdP idp, String spEntityID, String urlContext) {
        return saml2ClientCache.get(idp.getEntityID(), spEntityID).orElseGet(() -> saml2ClientCache.add(idp, this.newSAML2Configuration(), spEntityID, SAML2SP4UILogic.getCallbackUrl(spEntityID, urlContext)));
    }

    protected SAML2Client getSAML2Client(SAML2ClientCache saml2ClientCache, String idpEntityID, String spEntityID, String urlContext) {
        SAML2SP4UIIdP idp = Optional.ofNullable(this.idpDAO.findByEntityID(idpEntityID)).orElseThrow(() -> new NotFoundException("SAML 2.0 IdP '" + idpEntityID + "'"));
        return this.getSAML2Client(saml2ClientCache, idp, spEntityID, urlContext);
    }

    protected static SAML2Request buildRequest(String idpEntityID, RedirectionAction action) {
        SAML2Request requestTO = new SAML2Request();
        requestTO.setIdpEntityID(idpEntityID);
        if (action instanceof WithLocationAction) {
            WithLocationAction withLocationAction = (WithLocationAction)action;
            requestTO.setBindingType(SAML2BindingType.REDIRECT);
            requestTO.setContent(withLocationAction.getLocation());
        } else if (action instanceof WithContentAction) {
            WithContentAction withContentAction = (WithContentAction)action;
            requestTO.setBindingType(SAML2BindingType.POST);
            requestTO.setContent(Base64.getMimeEncoder().encodeToString(withContentAction.getContent().getBytes()));
        }
        return requestTO;
    }

    protected Optional<RequestedAuthnContextProvider> getRequestedAuthnContextProvider(SAML2SP4UIIdP idp) {
        Implementation impl = idp.getRequestedAuthnContextProvider();
        if (impl != null) {
            try {
                return Optional.of((RequestedAuthnContextProvider)ImplementationManager.build((Implementation)impl, () -> this.perContextRACP.get(impl.getKey()), instance -> this.perContextRACP.put(impl.getKey(), (RequestedAuthnContextProvider)instance)));
            }
            catch (Exception e) {
                LOG.warn("Cannot instantiate '{}', reverting to default behavior", (Object)impl, (Object)e);
            }
        }
        return Optional.empty();
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2Request createLoginRequest(String spEntityID, String urlContext, String idpEntityID) {
        SAML2SP4UIIdP idp = Optional.ofNullable(this.idpDAO.findByEntityID(idpEntityID)).orElseThrow(() -> new NotFoundException("SAML 2.0 IdP '" + idpEntityID + "'"));
        SAML2Client saml2Client = this.getSAML2Client(this.saml2ClientCacheLogin, idp, spEntityID, urlContext);
        this.getRequestedAuthnContextProvider(idp).ifPresent(requestedAuthnContextProvider -> {
            final RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)requestedAuthnContextProvider.get();
            saml2Client.setRedirectionActionBuilder((RedirectionActionBuilder)new SAML2RedirectionActionBuilder(saml2Client){

                public Optional<RedirectionAction> getRedirectionAction(WebContext wc, SessionStore sessionStore) {
                    this.saml2ObjectBuilder = new SAML2AuthnRequestBuilder(){

                        public AuthnRequest build(SAML2MessageContext context) {
                            AuthnRequest authnRequest = super.build(context);
                            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
                            return authnRequest;
                        }
                    };
                    return super.getRedirectionAction(wc, sessionStore);
                }
            });
        });
        SAML2SP4UIContext ctx = new SAML2SP4UIContext(saml2Client.getConfiguration().getAuthnRequestBindingType(), null);
        RedirectionAction action = (RedirectionAction)saml2Client.getRedirectionAction((WebContext)ctx, (SessionStore)NoOpSessionStore.INSTANCE).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("No RedirectionAction generated for AuthnRequest");
            return sce;
        });
        return SAML2SP4UILogic.buildRequest(idpEntityID, action);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2LoginResponse validateLoginResponse(SAML2Response saml2Response) {
        String username;
        SAML2Credentials.SAMLNameID nameID;
        SAML2LoginResponse loginResp;
        SAML2SP4UIIdP idp;
        block16: {
            SAML2Credentials credentials;
            idp = Optional.ofNullable(this.idpDAO.findByEntityID(saml2Response.getIdpEntityID())).orElseThrow(() -> new NotFoundException("SAML 2.0 IdP '" + saml2Response.getIdpEntityID() + "'"));
            SAML2Client saml2Client = this.getSAML2Client(this.saml2ClientCacheLogin, idp, saml2Response.getSpEntityID(), saml2Response.getUrlContext());
            try {
                SAML2SP4UIContext ctx = new SAML2SP4UIContext(saml2Client.getConfiguration().getAuthnRequestBindingType(), saml2Response);
                credentials = (SAML2Credentials)saml2Client.getCredentialsExtractor().extract((WebContext)ctx, (SessionStore)NoOpSessionStore.INSTANCE).orElseThrow(() -> new IllegalStateException("No AuthnResponse found"));
                saml2Client.getAuthenticator().validate((Credentials)credentials, (WebContext)ctx, (SessionStore)NoOpSessionStore.INSTANCE);
            }
            catch (Exception e) {
                LOG.error("While validating AuthnResponse", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
            loginResp = new SAML2LoginResponse();
            loginResp.setIdp(saml2Client.getIdentityProviderResolvedEntityId());
            loginResp.setSloSupported(!(saml2Client.getLogoutActionBuilder() instanceof NoLogoutActionBuilder));
            nameID = credentials.getNameId();
            Item connObjectKeyItem = idp.getConnObjectKeyItem().orElse(null);
            String keyValue = null;
            if (StringUtils.isNotBlank((CharSequence)nameID.getValue()) && connObjectKeyItem != null && connObjectKeyItem.getExtAttrName().equals("NameID")) {
                keyValue = nameID.getValue();
            }
            loginResp.setNotOnOrAfter(new Date(credentials.getConditions().getNotOnOrAfter().toInstant().toEpochMilli()));
            loginResp.setSessionIndex(credentials.getSessionIndex());
            for (SAML2Credentials.SAMLAttribute attr : credentials.getAttributes()) {
                if (attr.getAttributeValues().isEmpty()) continue;
                String attrName = Optional.ofNullable(attr.getFriendlyName()).orElse(attr.getName());
                if (connObjectKeyItem != null && attrName.equals(connObjectKeyItem.getExtAttrName())) {
                    keyValue = (String)attr.getAttributeValues().get(0);
                }
                loginResp.getAttrs().add(new Attr.Builder(attrName).values((Collection)attr.getAttributeValues()).build());
            }
            List matchingUsers = Optional.ofNullable(keyValue).map(k -> this.userManager.findMatchingUser((String)k, idp.getKey())).orElse(List.of());
            LOG.debug("Found {} matching users for {}", (Object)matchingUsers.size(), (Object)keyValue);
            if (matchingUsers.isEmpty()) {
                if (idp.isCreateUnmatching()) {
                    LOG.debug("No user matching {}, about to create", (Object)keyValue);
                    username = (String)AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> this.userManager.create(idp, loginResp, nameID.getValue()));
                    break block16;
                } else {
                    if (!idp.isSelfRegUnmatching()) {
                        throw new NotFoundException("User matching the provided value " + keyValue);
                    }
                    loginResp.setNameID(nameID.getValue());
                    UserTO userTO = new UserTO();
                    this.userManager.fill(idp.getKey(), loginResp, userTO);
                    loginResp.getAttrs().clear();
                    loginResp.getAttrs().addAll(userTO.getPlainAttrs());
                    if (StringUtils.isNotBlank((CharSequence)userTO.getUsername())) {
                        loginResp.setUsername(userTO.getUsername());
                    } else {
                        loginResp.setUsername(keyValue);
                    }
                    loginResp.setSelfReg(true);
                    return loginResp;
                }
            }
            if (matchingUsers.size() > 1) {
                throw new IllegalArgumentException("Several users match the provided value " + keyValue);
            }
            if (idp.isUpdateMatching()) {
                LOG.debug("About to update {} for {}", matchingUsers.get(0), (Object)keyValue);
                username = (String)AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> this.userManager.update((String)matchingUsers.get(0), idp, loginResp));
            } else {
                username = (String)matchingUsers.get(0);
            }
        }
        loginResp.setUsername(username);
        loginResp.setNameID(nameID.getValue());
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(JWT_CLAIM_IDP_ENTITYID, idp.getEntityID());
        claims.put(JWT_CLAIM_NAMEID_FORMAT, nameID.getFormat());
        claims.put(JWT_CLAIM_NAMEID_VALUE, nameID.getValue());
        claims.put(JWT_CLAIM_SESSIONINDEX, loginResp.getSessionIndex());
        byte[] authorities = null;
        try {
            authorities = ENCRYPTOR.encode(POJOHelper.serialize((Object)this.authDataAccessor.getAuthorities(loginResp.getUsername(), null)), CipherAlgorithm.AES).getBytes();
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        Pair accessTokenInfo = this.accessTokenDataBinder.create(loginResp.getUsername(), claims, authorities, true);
        loginResp.setAccessToken((String)accessTokenInfo.getLeft());
        loginResp.setAccessTokenExpiryTime((OffsetDateTime)accessTokenInfo.getRight());
        return loginResp;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public SAML2Request createLogoutRequest(String accessToken, String spEntityID, String urlContext) {
        JWTClaimsSet claimsSet;
        try {
            SignedJWT jwt = SignedJWT.parse((String)accessToken);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAccessToken);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        String idpEntityID = (String)claimsSet.getClaim(JWT_CLAIM_IDP_ENTITYID);
        if (idpEntityID == null) {
            throw new NotFoundException("No SAML 2.0 IdP information found in the access token");
        }
        SAML2Client saml2Client = this.getSAML2Client(this.saml2ClientCacheLogout, idpEntityID, spEntityID, urlContext);
        if (saml2Client.getLogoutActionBuilder() instanceof NoLogoutActionBuilder) {
            throw new IllegalArgumentException("No SingleLogoutService available for " + saml2Client.getIdentityProviderResolvedEntityId());
        }
        SAML2Profile saml2Profile = new SAML2Profile();
        saml2Profile.setId((String)claimsSet.getClaim(JWT_CLAIM_NAMEID_VALUE));
        saml2Profile.addAuthenticationAttribute("samlNameIdFormat", claimsSet.getClaim(JWT_CLAIM_NAMEID_FORMAT));
        saml2Profile.addAuthenticationAttribute("sessionindex", claimsSet.getClaim(JWT_CLAIM_SESSIONINDEX));
        SAML2SP4UIContext ctx = new SAML2SP4UIContext(saml2Client.getConfiguration().getSpLogoutRequestBindingType(), null);
        RedirectionAction action = (RedirectionAction)saml2Client.getLogoutAction((WebContext)ctx, (SessionStore)NoOpSessionStore.INSTANCE, (UserProfile)saml2Profile, null).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("No RedirectionAction generated for LogoutRequest");
            return sce;
        });
        return SAML2SP4UILogic.buildRequest(idpEntityID, action);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void validateLogoutResponse(SAML2Response saml2Response) {
        LogoutResponse logoutResponse;
        if (saml2Response.getIdpEntityID() == null) {
            LOG.error("No SAML 2.0 IdP entityID provided, ignoring");
            return;
        }
        SAML2Client saml2Client = this.getSAML2Client(this.saml2ClientCacheLogout, saml2Response.getIdpEntityID(), saml2Response.getSpEntityID(), saml2Response.getUrlContext());
        Optional.ofNullable(this.idpDAO.findByEntityID(saml2Client.getIdentityProviderResolvedEntityId())).orElseThrow(() -> new NotFoundException("SAML 2.0 IdP '" + saml2Client.getIdentityProviderResolvedEntityId() + "'"));
        SAML2SP4UIContext ctx = new SAML2SP4UIContext(saml2Client.getConfiguration().getSpLogoutRequestBindingType(), saml2Response);
        try {
            SAML2MessageContext saml2Ctx = saml2Client.getContextProvider().buildContext(saml2Client, (WebContext)ctx, (SessionStore)NoOpSessionStore.INSTANCE);
            saml2Client.getLogoutProfileHandler().receive(saml2Ctx);
            logoutResponse = (LogoutResponse)saml2Ctx.getMessageContext().getMessage();
        }
        catch (Exception e) {
            LOG.error("Could not validate LogoutResponse", (Throwable)e);
            return;
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(logoutResponse.getStatus().getStatusCode().getValue())) {
            LOG.warn("Logout from SAML 2.0 IdP '{}' was not successful", (Object)saml2Client.getIdentityProviderResolvedEntityId());
        }
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

