/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.io.IOException;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexManager;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenSearchReindex
extends AbstractSchedTaskJobDelegate<SchedTask> {
    @Autowired
    protected OpenSearchClient client;
    @Autowired
    protected OpenSearchIndexManager indexManager;
    @Autowired
    protected OpenSearchUtils utils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected RealmDAO realmDAO;

    protected IndexSettings userSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings groupSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings anyObjectSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings realmSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings auditSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected TypeMapping userMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping groupMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping anyObjectMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping realmMapping() throws IOException {
        return this.indexManager.defaultRealmMapping();
    }

    protected TypeMapping auditMapping() throws IOException {
        return this.indexManager.defaultAuditMapping();
    }

    protected String doExecute(boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        if (!dryRun) {
            this.setStatus("Start rebuilding indexes");
            try {
                this.indexManager.createRealmIndex(AuthContextUtils.getDomain(), this.realmSettings(), this.realmMapping());
                int realms = this.realmDAO.count();
                String rindex = OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain());
                this.setStatus("Indexing " + realms + " realms under " + rindex + "...");
                for (int page = 1; page <= realms / 500 + 1; ++page) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    for (String realm : this.realmDAO.findAllKeys(page, 500)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(rindex)).id(realm)).document((Object)this.utils.document(this.realmDAO.find(realm)))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{rindex, page, 500, response});
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{rindex, page, 500, e});
                    }
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.USER, this.userSettings(), this.userMapping());
                int users = this.userDAO.count();
                String uindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.USER);
                this.setStatus("Indexing " + users + " users under " + uindex + "...");
                for (int page = 1; page <= users / 500 + 1; ++page) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    for (String user : this.userDAO.findAllKeys(page, 500)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(uindex)).id(user)).document((Object)this.utils.document(this.userDAO.find(user)))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{uindex, page, 500, response});
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{uindex, page, 500, e});
                    }
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.GROUP, this.groupSettings(), this.groupMapping());
                int groups = this.groupDAO.count();
                String gindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.GROUP);
                this.setStatus("Indexing " + groups + " groups under " + gindex + "...");
                for (int page = 1; page <= groups / 500 + 1; ++page) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    for (String group : this.groupDAO.findAllKeys(page, 500)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(gindex)).id(group)).document((Object)this.utils.document(this.groupDAO.find(group)))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{gindex, page, 500, response});
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{gindex, page, 500, e});
                    }
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.ANY_OBJECT, this.anyObjectSettings(), this.anyObjectMapping());
                int anyObjects = this.anyObjectDAO.count();
                String aindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.ANY_OBJECT);
                this.setStatus("Indexing " + anyObjects + " any objects under " + aindex + "...");
                for (int page = 1; page <= anyObjects / 500 + 1; ++page) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    for (String anyObject : this.anyObjectDAO.findAllKeys(page, 500)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(aindex)).id(anyObject)).document((Object)this.utils.document(this.anyObjectDAO.find(anyObject)))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{aindex, page, 500, response});
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{aindex, page, 500, e});
                    }
                }
                this.indexManager.createAuditIndex(AuthContextUtils.getDomain(), this.auditSettings(), this.auditMapping());
                this.setStatus("Rebuild indexes for domain " + AuthContextUtils.getDomain() + " successfully completed");
                return "Indexes created:\n " + rindex + " [" + realms + "]\n " + uindex + " [" + users + "]\n " + gindex + " [" + groups + "]\n " + aindex + " [" + anyObjects + "]\n " + OpenSearchUtils.getAuditIndex((String)AuthContextUtils.getDomain());
            }
            catch (Exception e) {
                throw new JobExecutionException("While rebuilding index for domain " + AuthContextUtils.getDomain(), (Throwable)e);
            }
        }
        return "SUCCESS";
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }
}

