/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.opensearch.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.BuiltinScriptLanguage;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.ScriptLanguage;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SearchType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class OpenSearchRealmSearchDAO
implements RealmSearchDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDAO.class);
    protected static final List<SortOptions> REALM_SORT_OPTIONS = List.of((SortOptions)new SortOptions.Builder().script(s -> s.type(ScriptSortType.Number).script(t -> t.inline(i -> i.lang((ScriptLanguage)ScriptLanguage.builder().builtin(BuiltinScriptLanguage.Painless).build()).source("doc['fullPath'].value.chars().filter(ch -> ch == '/').count()"))).order(SortOrder.Asc)).build());
    protected final RealmDAO realmDAO;
    protected final OpenSearchClient client;
    protected final int indexMaxResultWindow;

    public OpenSearchRealmSearchDAO(RealmDAO realmDAO, OpenSearchClient client, int indexMaxResultWindow) {
        this.realmDAO = realmDAO;
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    @Transactional(readOnly=true)
    public Optional<Realm> findByFullPath(String fullPath) {
        if ("/".equals(fullPath)) {
            return Optional.of(this.realmDAO.getRoot());
        }
        if (StringUtils.isBlank((CharSequence)fullPath) || !RealmDAO.PATH_PATTERN.matcher(fullPath).matches()) {
            throw new MalformedPathException(fullPath);
        }
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(FieldValue.of((String)fullPath)).caseInsensitive(Boolean.valueOf(false)).build()).build()).size(Integer.valueOf(1)).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        try {
            String result = this.client.search(request, Void.class).hits().hits().stream().findFirst().map(Hit::id).orElse(null);
            return this.realmDAO.findById(result).map(Realm.class::cast);
        }
        catch (Exception e) {
            LOG.error("While searching OpenSearch for Realm path {} with request {}", new Object[]{fullPath, request, e});
            return Optional.empty();
        }
    }

    protected List<String> search(Query query) {
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(query).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        try {
            return this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in OpenSearch with request {}", (Object)request, (Object)e);
            return List.of();
        }
    }

    public List<Realm> findByName(String name) {
        List<String> result = this.search((Query)new Query.Builder().term(QueryBuilders.term().field("name").value(FieldValue.of((String)name)).caseInsensitive(Boolean.valueOf(false)).build()).build());
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    public List<Realm> findChildren(Realm realm) {
        List<String> result = this.search((Query)new Query.Builder().term(QueryBuilders.term().field("parent_id").value(FieldValue.of((String)realm.getKey())).caseInsensitive(Boolean.valueOf(false)).build()).build());
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    protected Query buildDescendantsQuery(Set<String> bases, String keyword) {
        ArrayList basesQueries = new ArrayList();
        bases.forEach(base -> {
            basesQueries.add((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(FieldValue.of((String)base)).caseInsensitive(Boolean.valueOf(false)).build()).build());
            basesQueries.add((Query)new Query.Builder().regexp(QueryBuilders.regexp().field("fullPath").value((String)("/".equals(base) ? "/.*" : base + "/.*")).build()).build());
        });
        Query prefix = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(basesQueries).build()).build();
        if (keyword == null) {
            return prefix;
        }
        return (Query)new Query.Builder().bool(QueryBuilders.bool().filter(prefix, new Query[]{(Query)new Query.Builder().wildcard(QueryBuilders.wildcard().field("name").value(keyword.replace('%', '*').replace("\\_", "_")).caseInsensitive(Boolean.valueOf(true)).build()).build()}).build()).build();
    }

    public long countDescendants(String base, String keyword) {
        return this.countDescendants(Set.of(base), keyword);
    }

    public long countDescendants(Set<String> bases, String keyword) {
        CountRequest request = new CountRequest.Builder().index(OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).query(this.buildDescendantsQuery(bases, keyword)).build();
        LOG.debug("Count request: {}", (Object)request);
        try {
            return this.client.count(request).count();
        }
        catch (Exception e) {
            LOG.error("While counting in OpenSearch with request {}", (Object)request, (Object)e);
            return 0L;
        }
    }

    public List<Realm> findDescendants(String base, String keyword, Pageable pageable) {
        return this.findDescendants(Set.of(base), keyword, pageable);
    }

    public List<Realm> findDescendants(Set<String> bases, String keyword, Pageable pageable) {
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(this.buildDescendantsQuery(bases, keyword)).from(Integer.valueOf(pageable.isUnpaged() ? 0 : pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.isUnpaged() ? this.indexMaxResultWindow : pageable.getPageSize())).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List<Object> result = List.of();
        try {
            result = this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in OpenSearch with request {}", (Object)request, (Object)e);
        }
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    public List<String> findDescendants(String base, String prefix) {
        Query prefixQuery = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(FieldValue.of((String)prefix)).caseInsensitive(Boolean.valueOf(false)).build()).build(), new Query[]{(Query)new Query.Builder().prefix(QueryBuilders.prefix().field("fullPath").value((String)("/".equals(prefix) ? "/" : prefix + "/")).build()).build()}).build()).build();
        Query query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter(this.buildDescendantsQuery(Set.of(base), null), new Query[]{prefixQuery}).build()).build();
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(query).from(Integer.valueOf(0)).size(Integer.valueOf(this.indexMaxResultWindow)).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List<String> result = List.of();
        try {
            result = this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in OpenSearch", (Throwable)e);
        }
        return result;
    }
}

