/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.opensearch.dao;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexManager;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.SearchType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch._types.query_dsl.TextQueryType;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class OpenSearchAuditEventDAO
implements AuditEventDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(AuditEventDAO.class);
    protected final OpenSearchIndexManager indexManager;
    protected final OpenSearchClient client;
    protected final int indexMaxResultWindow;

    public OpenSearchAuditEventDAO(OpenSearchIndexManager indexManager, OpenSearchClient client, int indexMaxResultWindow) {
        this.indexManager = indexManager;
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    public AuditEvent save(AuditEvent auditEvent) {
        try {
            this.indexManager.audit(AuthContextUtils.getDomain(), auditEvent);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not index audit event", e);
        }
        return auditEvent;
    }

    protected Query getQuery(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, OffsetDateTime before, OffsetDateTime after) {
        ArrayList<Query> queries = new ArrayList<Query>();
        if (entityKey != null) {
            queries.add((Query)new Query.Builder().multiMatch(QueryBuilders.multiMatch().fields("before", new String[]{"inputs", "output", "throwable"}).type(TextQueryType.Phrase).query(entityKey).build()).build());
        }
        queries.add((Query)new Query.Builder().regexp(QueryBuilders.regexp().field("opEvent").value(OpEvent.toString((OpEvent.CategoryType)type, (String)category, (String)subcategory, (String)op, (OpEvent.Outcome)outcome).replace("[]", "[.*]").replace("[", "\\[").replace("]", "\\]")).build()).build());
        if (before != null) {
            queries.add((Query)new Query.Builder().range(QueryBuilders.range().field("when").lte(JsonData.of((Object)before.toInstant().toEpochMilli())).build()).build());
        }
        if (after != null) {
            queries.add((Query)new Query.Builder().range(QueryBuilders.range().field("when").gte(JsonData.of((Object)after.toInstant().toEpochMilli())).build()).build());
        }
        return (Query)new Query.Builder().bool(QueryBuilders.bool().filter(queries).build()).build();
    }

    public long count(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, OffsetDateTime before, OffsetDateTime after) {
        CountRequest request = new CountRequest.Builder().index(OpenSearchUtils.getAuditIndex((String)AuthContextUtils.getDomain()), new String[0]).query(this.getQuery(entityKey, type, category, subcategory, op, outcome, before, after)).build();
        LOG.debug("Count request: {}", (Object)request);
        try {
            return this.client.count(request).count();
        }
        catch (IOException e) {
            LOG.error("While counting in OpenSearch with request {}", (Object)request, (Object)e);
            return 0L;
        }
    }

    protected List<SortOptions> sortBuilders(Stream<Sort.Order> orderBy) {
        return orderBy.map(clause -> (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field("id".equals(clause.getProperty()) ? "key" : clause.getProperty()).order(clause.getDirection() == Sort.Direction.ASC ? SortOrder.Asc : SortOrder.Desc).build()).build()).toList();
    }

    public List<AuditEventTO> search(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getAuditIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(this.getQuery(entityKey, type, category, subcategory, op, outcome, before, after)).from(Integer.valueOf(pageable.isUnpaged() ? 0 : pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.isUnpaged() ? this.indexMaxResultWindow : pageable.getPageSize())).sort(this.sortBuilders(pageable.getSort().get())).build();
        LOG.debug("Search request: {}", (Object)request);
        List esResult = null;
        try {
            esResult = this.client.search(request, ObjectNode.class).hits().hits();
        }
        catch (Exception e) {
            LOG.error("While searching in OpenSearch with request {}", (Object)request, (Object)e);
        }
        return CollectionUtils.isEmpty((Collection)esResult) ? List.of() : esResult.stream().map(hit -> (AuditEventTO)POJOHelper.convertValue((Object)hit.source(), AuditEventTO.class)).filter(Objects::nonNull).toList();
    }
}

