/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.opensearch.dao;

import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SearchType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.DisMaxQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class OpenSearchAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final Set<String> ID_PROPS = Set.of("key", "id", "_id");
    protected final OpenSearchClient client;
    protected final int indexMaxResultWindow;

    public OpenSearchAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, OpenSearchClient client, int indexMaxResultWindow) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator);
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    protected Triple<Optional<Query>, Set<String>, Set<String>> getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms, AnyTypeKind kind) {
        HashSet dynRealmKeys = new HashSet();
        HashSet groupOwners = new HashSet();
        ArrayList<Query> queries = new ArrayList<Query>();
        if (recursive) {
            adminRealms.forEach(realmPath -> {
                Optional goRealm = RealmUtils.parseGroupOwnerRealm((String)realmPath);
                if (goRealm.isPresent()) {
                    groupOwners.add((String)((Pair)goRealm.get()).getRight());
                } else if (realmPath.startsWith("/")) {
                    Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmPath).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + realmPath));
                    this.realmSearchDAO.findDescendants(realm.getFullPath(), base.getFullPath()).forEach(descendant -> queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(FieldValue.of((String)descendant)).build()).build()));
                } else {
                    this.dynRealmDAO.findById(realmPath).ifPresentOrElse(dynRealm -> {
                        dynRealmKeys.add(dynRealm.getKey());
                        queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("dynRealm").value(FieldValue.of((String)dynRealm.getKey())).build()).build());
                    }, () -> LOG.warn("Ignoring invalid dynamic realm {}", realmPath));
                }
            });
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(FieldValue.of((String)base.getKey())).build()).build());
        }
        return Triple.of(dynRealmKeys.isEmpty() && groupOwners.isEmpty() ? Optional.of((Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build()) : Optional.empty(), dynRealmKeys, groupOwners);
    }

    protected Query getQuery(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        Query query;
        if (SyncopeConstants.FULL_ADMIN_REALMS.equals(adminRealms)) {
            query = this.getQuery(cond, kind);
            if (!recursive) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(FieldValue.of((String)base.getKey())).build()).build(), new Query[0]).filter(query, new Query[0]).build()).build();
            }
        } else {
            Triple<Optional<Query>, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, kind);
            query = this.getQuery(OpenSearchAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind), kind);
            if (((Optional)filter.getLeft()).isPresent()) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter((Query)((Optional)filter.getLeft()).get(), new Query[0]).filter(query, new Query[0]).build()).build();
            }
        }
        return query;
    }

    protected long doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        CountRequest request = new CountRequest.Builder().index(OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).query(this.getQuery(base, recursive, adminRealms, cond, kind)).build();
        LOG.debug("Count request: {}", (Object)request);
        try {
            return this.client.count(request).count();
        }
        catch (Exception e) {
            LOG.error("While counting in OpenSearch with request {}", (Object)request, (Object)e);
            return 0L;
        }
    }

    protected List<SortOptions> sortBuilders(AnyTypeKind kind, Stream<Sort.Order> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        ArrayList<SortOptions> options = new ArrayList<SortOptions>();
        orderBy.forEach(clause -> {
            String sortName = null;
            String fieldName = clause.getProperty();
            if (!ID_PROPS.contains(fieldName)) {
                Field anyField = anyUtils.getField(fieldName).orElse(null);
                if (anyField == null) {
                    PlainSchema schema = this.plainSchemaDAO.findById(fieldName).orElse(null);
                    if (schema != null) {
                        sortName = fieldName;
                    }
                } else {
                    sortName = fieldName;
                }
            }
            if (sortName == null) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                options.add((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortName).order(clause.getDirection() == Sort.Direction.ASC ? SortOrder.Asc : SortOrder.Desc).build()).build());
            }
        });
        return options;
    }

    protected <T extends Any> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        SearchRequest request = new SearchRequest.Builder().index(OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).searchType(SearchType.QueryThenFetch).query(this.getQuery(base, recursive, adminRealms, cond, kind)).from(Integer.valueOf(pageable.isUnpaged() ? 0 : pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.isUnpaged() ? this.indexMaxResultWindow : pageable.getPageSize())).sort(this.sortBuilders(kind, pageable.getSort().get())).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List esResult = null;
        try {
            esResult = this.client.search(request, Void.class).hits().hits();
        }
        catch (Exception e) {
            LOG.error("While searching in OpenSearch with request {}", (Object)request, (Object)e);
        }
        return CollectionUtils.isEmpty((Collection)esResult) ? List.of() : this.buildResult(esResult.stream().map(Hit::id).collect(Collectors.toList()), kind);
    }

    protected Query getQuery(SearchCond cond, AnyTypeKind kind) {
        Query query = null;
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                query = cond.asLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == kind).map(this::getQuery).orElse(null);
                if (query == null) {
                    query = cond.asLeaf(RelationshipTypeCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(RelationshipCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(MembershipCond.class).filter(leaf -> AnyTypeKind.GROUP != kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(MemberCond.class).filter(leaf -> AnyTypeKind.GROUP == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(DynRealmCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(AuxClassCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(ResourceCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(AnyCond.class).map(ac -> this.getQuery((AnyCond)ac, kind)).or(() -> cond.asLeaf(AttrCond.class).map(this::getQuery)).orElse(null);
                }
                if (query == null) {
                    query = this.getQueryForCustomConds(cond, kind);
                }
                if (query == null) {
                    throw new IllegalArgumentException("Cannot construct QueryBuilder");
                }
                if (cond.getType() != SearchCond.Type.NOT_LEAF) break;
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot(query, new Query[0]).build()).build();
                break;
            }
            case AND: {
                ArrayList<Query> andCompound = new ArrayList<Query>();
                Query andLeft = this.getQuery(cond.getLeft(), kind);
                if (andLeft._kind() == Query.Kind.Bool && !((BoolQuery)andLeft._get()).filter().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andLeft._get()).filter());
                } else {
                    andCompound.add(andLeft);
                }
                Query andRight = this.getQuery(cond.getRight(), kind);
                if (andRight._kind() == Query.Kind.Bool && !((BoolQuery)andRight._get()).filter().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andRight._get()).filter());
                } else {
                    andCompound.add(andRight);
                }
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter(andCompound).build()).build();
                break;
            }
            case OR: {
                ArrayList<Query> orCompound = new ArrayList<Query>();
                Query orLeft = this.getQuery(cond.getLeft(), kind);
                if (orLeft._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orLeft._get()).queries());
                } else {
                    orCompound.add(orLeft);
                }
                Query orRight = this.getQuery(cond.getRight(), kind);
                if (orRight._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orRight._get()).queries());
                } else {
                    orCompound.add(orRight);
                }
                query = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(orCompound).build()).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AnyTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("anyType").value(FieldValue.of((String)cond.getAnyTypeKey())).build()).build();
    }

    protected Query getQuery(RelationshipTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("relationshipTypes").value(FieldValue.of((String)cond.getRelationshipTypeKey())).build()).build();
    }

    protected Query getQuery(RelationshipCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("relationships").value(FieldValue.of((String)key)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(MembershipCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("memberships").value(FieldValue.of((String)key)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(RoleCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("roles").value(FieldValue.of((String)cond.getRole())).build()).build();
    }

    protected Query getQuery(DynRealmCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("dynRealms").value(FieldValue.of((String)cond.getDynRealm())).build()).build();
    }

    protected Query getQuery(MemberCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("members").value(FieldValue.of((String)key)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(AuxClassCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("auxClasses").value(FieldValue.of((String)cond.getAuxClass())).build()).build();
    }

    protected Query getQuery(ResourceCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("resources").value(FieldValue.of((String)cond.getResource())).build()).build();
    }

    protected Query fillAttrQuery(PlainSchema schema, PlainAttrValue attrValue, AttrCond cond) {
        Object value = schema.getType() == AttrSchemaType.Date && attrValue.getDateValue() != null ? FormatUtils.format((TemporalAccessor)attrValue.getDateValue()) : attrValue.getValue();
        Query query = null;
        switch (cond.getType()) {
            case ISNOTNULL: {
                query = (Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build();
                break;
            }
            case ISNULL: {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot((Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build(), new Query[0]).build()).build();
                break;
            }
            case ILIKE: {
                StringBuilder output = new StringBuilder();
                for (char c : cond.getExpression().toLowerCase().replace("\\_", "_").toCharArray()) {
                    if (c == '%') {
                        output.append(".*");
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        output.append('[').append(c).append(Character.toUpperCase(c)).append(']');
                        continue;
                    }
                    output.append(OpenSearchUtils.escapeForLikeRegex((char)c));
                }
                query = (Query)new Query.Builder().regexp(QueryBuilders.regexp().field(schema.getKey()).value(output.toString()).build()).build();
                break;
            }
            case LIKE: {
                query = (Query)new Query.Builder().wildcard(QueryBuilders.wildcard().field(schema.getKey()).value(cond.getExpression().replace('%', '*').replace("\\_", "_")).build()).build();
                break;
            }
            case IEQ: {
                query = (Query)new Query.Builder().match(QueryBuilders.match().field(schema.getKey()).query(FieldValue.of((String)cond.getExpression().toLowerCase())).build()).build();
                break;
            }
            case EQ: {
                FieldValue fieldValue;
                if (value instanceof Double) {
                    Double aDouble = (Double)value;
                    fieldValue = FieldValue.of((double)aDouble);
                } else if (value instanceof Long) {
                    Long aLong = (Long)value;
                    fieldValue = FieldValue.of((long)aLong);
                } else if (value instanceof Boolean) {
                    Boolean aBoolean = (Boolean)value;
                    fieldValue = FieldValue.of((boolean)aBoolean);
                } else {
                    fieldValue = FieldValue.of((String)value.toString());
                }
                query = (Query)new Query.Builder().term(QueryBuilders.term().field(schema.getKey()).value(fieldValue).build()).build();
                break;
            }
            case GE: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).gte(JsonData.of((Object)value)).build()).build();
                break;
            }
            case GT: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).gt(JsonData.of((Object)value)).build()).build();
                break;
            }
            case LE: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).lte(JsonData.of((Object)value)).build()).build();
                break;
            }
            case LT: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).lt(JsonData.of((Object)value)).build()).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AttrCond cond) {
        Pair checked = this.check(cond);
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getRight(), cond);
    }

    protected Triple<PlainSchema, PlainAttrValue, AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        Triple checked = super.check(cond, kind);
        if ("id".equals(((AnyCond)checked.getRight()).getSchema())) {
            ((AnyCond)checked.getRight()).setSchema("_id");
        }
        if ("id".equals(((PlainSchema)checked.getLeft()).getKey())) {
            ((PlainSchema)checked.getLeft()).setKey("_id");
        }
        return checked;
    }

    protected Query getQuery(AnyCond cond, AnyTypeKind kind) {
        if ("realm".equals(cond.getSchema()) && cond.getExpression().startsWith("/")) {
            Realm realm = (Realm)this.realmSearchDAO.findByFullPath(cond.getExpression()).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        Triple<PlainSchema, PlainAttrValue, AnyCond> checked = this.check(cond, kind);
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getMiddle(), (AttrCond)checked.getRight());
    }

    protected Query getQueryForCustomConds(SearchCond cond, AnyTypeKind kind) {
        return null;
    }
}

