/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.opensearch.client;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class OpenSearchClientFactoryBean
implements FactoryBean<OpenSearchClient>,
DisposableBean {
    private final List<HttpHost> hosts;
    private String username;
    private String password;
    private String serviceToken;
    private String apiKeyId;
    private String apiKeySecret;
    private ApacheHttpClient5Transport transport;
    private OpenSearchClient client;

    public OpenSearchClientFactoryBean(List<HttpHost> hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(String serviceToken) {
        this.serviceToken = serviceToken;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public void setApiKeyId(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public String getApiKeySecret() {
        return this.apiKeySecret;
    }

    public void setApiKeySecret(String apiKeySecret) {
        this.apiKeySecret = apiKeySecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchClient getObject() {
        OpenSearchClientFactoryBean openSearchClientFactoryBean = this;
        synchronized (openSearchClientFactoryBean) {
            if (this.client == null) {
                ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])((HttpHost[])this.hosts.toArray(HttpHost[]::new))).setMapper((JsonpMapper)new JacksonJsonpMapper(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build()));
                if (this.username != null && this.password != null) {
                    String encodedAuth = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Basic " + encodedAuth))});
                } else if (this.serviceToken != null) {
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Bearer " + this.serviceToken))});
                } else if (this.apiKeyId != null && this.apiKeySecret != null) {
                    String apiKeyAuth = Base64.getEncoder().encodeToString((this.apiKeyId + ":" + this.apiKeySecret).getBytes(StandardCharsets.UTF_8));
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("ApiKey " + apiKeyAuth))});
                }
                this.transport = builder.build();
                this.client = new OpenSearchClient((OpenSearchTransport)this.transport);
            }
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return OpenSearchClient.class;
    }

    public void destroy() throws Exception {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

