/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.opensearch.client;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class OpenSearchClientFactoryBean
implements FactoryBean<OpenSearchClient>,
DisposableBean {
    private final List<HttpHost> hosts;
    private String username;
    private String password;
    private String serviceToken;
    private String apiKeyId;
    private String apiKeySecret;
    private RestClient restClient;
    private OpenSearchClient client;

    public OpenSearchClientFactoryBean(List<HttpHost> hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(String serviceToken) {
        this.serviceToken = serviceToken;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public void setApiKeyId(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public String getApiKeySecret() {
        return this.apiKeySecret;
    }

    public void setApiKeySecret(String apiKeySecret) {
        this.apiKeySecret = apiKeySecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchClient getObject() throws Exception {
        OpenSearchClientFactoryBean openSearchClientFactoryBean = this;
        synchronized (openSearchClientFactoryBean) {
            if (this.client == null) {
                RestClientBuilder builder = RestClient.builder((HttpHost[])((HttpHost[])this.hosts.toArray(HttpHost[]::new)));
                if (this.username != null && this.password != null) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                    builder.setHttpClientConfigCallback(arg_0 -> OpenSearchClientFactoryBean.lambda$getObject$1((CredentialsProvider)credentialsProvider, arg_0));
                } else if (this.serviceToken != null) {
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Bearer " + this.serviceToken)});
                } else if (this.apiKeyId != null && this.apiKeySecret != null) {
                    String apiKeyAuth = Base64.getEncoder().encodeToString((this.apiKeyId + ":" + this.apiKeySecret).getBytes(StandardCharsets.UTF_8));
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "ApiKey " + apiKeyAuth)});
                }
                this.restClient = builder.build();
                this.client = new OpenSearchClient((OpenSearchTransport)new RestClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build())));
            }
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return OpenSearchClient.class;
    }

    public void destroy() throws Exception {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getObject$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder b) {
        return b.setDefaultCredentialsProvider(credentialsProvider);
    }
}

