/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Store;

@JsonPropertyOrder(value={"stores", "continuation_token"})
public class ListStoresResponse {
    public static final String JSON_PROPERTY_STORES = "stores";
    @Nonnull
    private List<Store> stores = new ArrayList<Store>();
    public static final String JSON_PROPERTY_CONTINUATION_TOKEN = "continuation_token";
    @Nonnull
    private String continuationToken;

    public ListStoresResponse stores(@Nonnull List<Store> stores) {
        this.stores = stores;
        return this;
    }

    public ListStoresResponse addStoresItem(Store storesItem) {
        if (this.stores == null) {
            this.stores = new ArrayList<Store>();
        }
        this.stores.add(storesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Store> getStores() {
        return this.stores;
    }

    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStores(@Nonnull List<Store> stores) {
        this.stores = stores;
    }

    public ListStoresResponse continuationToken(@Nonnull String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nonnull
    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContinuationToken(@Nonnull String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListStoresResponse listStoresResponse = (ListStoresResponse)o;
        return Objects.equals(this.stores, listStoresResponse.stores) && Objects.equals(this.continuationToken, listStoresResponse.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.stores, this.continuationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListStoresResponse {\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStores() != null) {
            for (int i = 0; i < this.getStores().size(); ++i) {
                if (this.getStores().get(i) == null) continue;
                joiner.add(this.getStores().get(i).toUrlQueryString(String.format("%sstores%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContinuationToken() != null) {
            joiner.add(String.format("%scontinuation_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContinuationToken()))));
        }
        return joiner.toString();
    }
}

