/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Condition;
import org.apache.syncope.ext.openfga.client.model.TypeDefinition;

@JsonPropertyOrder(value={"id", "schema_version", "type_definitions", "conditions"})
public class AuthorizationModel {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schema_version";
    @Nonnull
    private String schemaVersion;
    public static final String JSON_PROPERTY_TYPE_DEFINITIONS = "type_definitions";
    @Nonnull
    private List<TypeDefinition> typeDefinitions = new ArrayList<TypeDefinition>();
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    @Nullable
    private Map<String, Condition> conditions = new HashMap<String, Condition>();

    public AuthorizationModel id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public AuthorizationModel schemaVersion(@Nonnull String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema_version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="schema_version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchemaVersion(@Nonnull String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public AuthorizationModel typeDefinitions(@Nonnull List<TypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
        return this;
    }

    public AuthorizationModel addTypeDefinitionsItem(TypeDefinition typeDefinitionsItem) {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = new ArrayList<TypeDefinition>();
        }
        this.typeDefinitions.add(typeDefinitionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="type_definitions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="type_definitions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeDefinitions(@Nonnull List<TypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
    }

    public AuthorizationModel conditions(@Nullable Map<String, Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public AuthorizationModel putConditionsItem(String key, Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new HashMap<String, Condition>();
        }
        this.conditions.put(key, conditionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(@Nullable Map<String, Condition> conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationModel authorizationModel = (AuthorizationModel)o;
        return Objects.equals(this.id, authorizationModel.id) && Objects.equals(this.schemaVersion, authorizationModel.schemaVersion) && Objects.equals(this.typeDefinitions, authorizationModel.typeDefinitions) && Objects.equals(this.conditions, authorizationModel.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemaVersion, this.typeDefinitions, this.conditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationModel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    schemaVersion: ").append(this.toIndentedString(this.schemaVersion)).append("\n");
        sb.append("    typeDefinitions: ").append(this.toIndentedString(this.typeDefinitions)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getId()))));
        }
        if (this.getSchemaVersion() != null) {
            joiner.add(String.format("%sschema_version%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getSchemaVersion()))));
        }
        if (this.getTypeDefinitions() != null) {
            for (int i = 0; i < this.getTypeDefinitions().size(); ++i) {
                if (this.getTypeDefinitions().get(i) == null) continue;
                joiner.add(this.getTypeDefinitions().get(i).toUrlQueryString(String.format("%stype_definitions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getConditions() != null) {
            for (String _key : this.getConditions().keySet()) {
                if (this.getConditions().get(_key) == null) continue;
                joiner.add(this.getConditions().get(_key).toUrlQueryString(String.format("%sconditions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

