/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.CheckRequestTupleKey;
import org.apache.syncope.ext.openfga.client.model.ConsistencyPreference;
import org.apache.syncope.ext.openfga.client.model.ContextualTupleKeys;

@JsonPropertyOrder(value={"tuple_key", "contextual_tuples", "authorization_model_id", "trace", "context", "consistency"})
public class CheckRequest {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nonnull
    private CheckRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    @Nullable
    private ContextualTupleKeys contextualTuples;
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    @Nullable
    private String authorizationModelId;
    public static final String JSON_PROPERTY_TRACE = "trace";
    @Nullable
    private Boolean trace;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    @Nullable
    private Object context;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    @Nullable
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public CheckRequest() {
    }

    @JsonCreator
    public CheckRequest(@JsonProperty(value="trace") Boolean trace) {
        this();
        this.trace = trace;
    }

    public CheckRequest tupleKey(@Nonnull CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CheckRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(@Nonnull CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public CheckRequest contextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public CheckRequest authorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    @Nullable
    @JsonProperty(value="trace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrace() {
        return this.trace;
    }

    public CheckRequest context(@Nullable Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(@Nullable Object context) {
        this.context = context;
    }

    public CheckRequest consistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckRequest checkRequest = (CheckRequest)o;
        return Objects.equals(this.tupleKey, checkRequest.tupleKey) && Objects.equals(this.contextualTuples, checkRequest.contextualTuples) && Objects.equals(this.authorizationModelId, checkRequest.authorizationModelId) && Objects.equals(this.trace, checkRequest.trace) && Objects.equals(this.context, checkRequest.context) && Objects.equals((Object)this.consistency, (Object)checkRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.contextualTuples, this.authorizationModelId, this.trace, this.context, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckRequest {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    trace: ").append(this.toIndentedString(this.trace)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getAuthorizationModelId()))));
        }
        if (this.getTrace() != null) {
            joiner.add(String.format("%strace%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getTrace()))));
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContext()))));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getConsistency()))));
        }
        return joiner.toString();
    }
}

