/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.model.ReadAssertionsResponse;
import org.apache.syncope.ext.openfga.client.model.WriteAssertionsRequest;

public class AssertionsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public AssertionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssertionsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ReadAssertionsResponse readAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId) throws ApiException {
        ApiResponse<ReadAssertionsResponse> localVarResponse = this.readAssertionsWithHttpInfo(storeId, authorizationModelId);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAssertionsResponse> readAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAssertionsRequestBuilder(storeId, authorizationModelId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("readAssertions", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ReadAssertionsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAssertionsResponse>(this){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAssertionsRequestBuilder(@Nonnull String storeId, @Nonnull String authorizationModelId) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAssertions");
        }
        if (authorizationModelId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationModelId' when calling readAssertions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void writeAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body) throws ApiException {
        this.writeAssertionsWithHttpInfo(storeId, authorizationModelId, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> writeAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.writeAssertionsRequestBuilder(storeId, authorizationModelId, body);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("writeAssertions", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder writeAssertionsRequestBuilder(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling writeAssertions");
        }
        if (authorizationModelId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationModelId' when calling writeAssertions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling writeAssertions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

