/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hc.core5.http.HttpHost;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchClientFactoryBean;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexLoader;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexManager;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchProperties;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.apache.syncope.ext.elasticsearch.client.SyncopeElasticsearchHealthContributor;
import org.identityconnectors.common.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@EnableConfigurationProperties(value={ElasticsearchProperties.class})
@Configuration(proxyBeanMethods=false)
public class ElasticsearchClientContext {
    protected static final Logger LOG = LoggerFactory.getLogger(ElasticsearchClientContext.class);

    @ConditionalOnMissingBean
    @Bean
    public ElasticsearchClientFactoryBean elasticsearchClientFactoryBean(ElasticsearchProperties props) {
        return new ElasticsearchClientFactoryBean(CollectionUtil.nullAsEmpty(props.getHosts()).stream().map(host -> {
            try {
                return HttpHost.create((String)host);
            }
            catch (URISyntaxException e) {
                LOG.error("Invalid host: {}", host, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }

    @ConditionalOnMissingBean
    @Bean
    public ElasticsearchUtils elasticsearchUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO) {
        return new ElasticsearchUtils(userDAO, groupDAO, anyObjectDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public ElasticsearchIndexManager elasticsearchIndexManager(ElasticsearchProperties props, ElasticsearchClient client, ElasticsearchUtils elasticsearchUtils) {
        return new ElasticsearchIndexManager(client, elasticsearchUtils, props.getNumberOfShards(), props.getNumberOfReplicas());
    }

    @ConditionalOnMissingBean
    @Bean
    public ElasticsearchIndexLoader elasticsearchIndexLoader(ElasticsearchIndexManager indexManager) {
        return new ElasticsearchIndexLoader(indexManager);
    }

    @ConditionalOnMissingBean(name={"syncopeElasticsearchHealthContributor"})
    @Bean(name={"syncopeElasticsearchHealthContributor", "elasticsearchHealthIndicator", "elasticsearchHealthContributor"})
    public HealthContributor syncopeElasticsearchHealthContributor(ElasticsearchClient client) {
        return new SyncopeElasticsearchHealthContributor(client);
    }
}

