/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.syncope.common.lib.to.AuditConfTO;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.rest.api.beans.AuditQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Audit")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="audit")
public interface AuditService
extends JAXRSService {
    @GET
    @Path(value="conf")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<AuditConfTO> confs();

    @GET
    @Path(value="conf/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public AuditConfTO getConf(@NotNull @PathParam(value="key") String var1);

    @Parameter(name="key", description="Audit configuration 's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="conf/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void setConf(@NotNull AuditConfTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="conf/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void deleteConf(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="opEvents")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<OpEvent> events();

    @GET
    @Path(value="auditEvents")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<AuditEventTO> search(@BeanParam AuditQuery var1);

    @POST
    @Path(value="auditEvents")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public void create(@NotNull AuditEventTO var1);
}

