/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.wicket.request.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource
extends AbstractResource {
    private static final long serialVersionUID = -7875801358718612782L;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseResource.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    protected final boolean xsrfCheck(HttpServletRequest request) {
        String requestXSRFHeader = request.getHeader("X-XSRF-TOKEN");
        return SyncopeEnduserApplication.get().isXsrfEnabled() ? StringUtils.isNotBlank((CharSequence)requestXSRFHeader) && SyncopeEnduserSession.get().getCookieUtils().getCookie("XSRF-TOKEN").getValue().equals(requestXSRFHeader) : true;
    }

    protected final boolean captchaCheck(String enteredCaptcha, Object currentCaptcha) {
        return SyncopeEnduserApplication.get().isCaptchaEnabled() ? (StringUtils.isBlank((CharSequence)currentCaptcha.toString()) || enteredCaptcha == null ? false : enteredCaptcha.equals(currentCaptcha.toString())) : true;
    }
}

