/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.adapters.PlatformInfoAdapter;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.client.enduser.util.SaltGenerator;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.cookies.CookieUtils;

@Resource(key="info", path="/api/info")
public class InfoResource
extends BaseResource {
    private static final long serialVersionUID = 6453101466981543020L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            CookieUtils sessionCookieUtils = SyncopeEnduserSession.get().getCookieUtils();
            if (!SyncopeEnduserSession.get().isXsrfTokenGenerated() && (sessionCookieUtils.getCookie("XSRF-TOKEN") == null || StringUtils.isBlank((CharSequence)sessionCookieUtils.getCookie("XSRF-TOKEN").getValue()))) {
                LOG.debug("Set XSRF-TOKEN cookie");
                SyncopeEnduserSession.get().setXsrfTokenGenerated(true);
                sessionCookieUtils.save("XSRF-TOKEN", SaltGenerator.generate(SyncopeEnduserSession.get().getId()));
            }
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    HashMap customFormAttributes = SyncopeEnduserApplication.get().getCustomFormAttributes();
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)PlatformInfoAdapter.toPlatformInfoRequest(SyncopeEnduserSession.get().getPlatformInfo(), customFormAttributes == null ? new HashMap() : customFormAttributes)));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving syncope info", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

