/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class ConnectorDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = -2435937897614232137L;
    private final RealmRestClient realmRestClient = new RealmRestClient();

    public ConnectorDetailsPanel(final ConnInstanceTO connInstanceTO, final List<ConnBundleTO> bundles) {
        FieldPanel location;
        this.setOutputMarkupId(true);
        final boolean isSearchEnabled = RealmsUtils.isSearchEnabled();
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(!isSearchEnabled);
        settings.setShowListOnEmptyInput(!isSearchEnabled);
        AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("adminRealm", "adminRealm", (IModel)new PropertyModel((Object)connInstanceTO, "adminRealm"), settings){
            private static final long serialVersionUID = -6390474600233486704L;

            @Override
            protected Iterator<String> getChoices(String input) {
                return (isSearchEnabled ? ConnectorDetailsPanel.this.realmRestClient.search(RealmsUtils.buildQuery(input)).getResult() : ConnectorDetailsPanel.this.realmRestClient.list("/")).stream().filter(realm -> SyncopeConsoleSession.get().getAuthRealms().stream().anyMatch(authRealm -> realm.getFullPath().startsWith((String)authRealm))).map(item -> item.getFullPath()).collect(Collectors.toList()).iterator();
            }
        };
        realm.setOutputMarkupId(true);
        realm.addRequiredLabel();
        this.add(new Component[]{realm});
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "displayName", (IModel<String>)new PropertyModel((Object)connInstanceTO, "displayName"), false);
        displayName.setOutputMarkupId(true);
        displayName.addRequiredLabel();
        this.add(new Component[]{displayName});
        final AjaxDropDownChoicePanel bundleName = new AjaxDropDownChoicePanel("bundleName", "bundleName", new PropertyModel((Object)connInstanceTO, "bundleName"), false);
        if (StringUtils.isNotBlank((CharSequence)connInstanceTO.getLocation())) {
            location = new AjaxTextFieldPanel("location", "location", (IModel<String>)new PropertyModel((Object)connInstanceTO, "location"), false);
            location.addRequiredLabel();
            location.setOutputMarkupId(true);
            location.setEnabled(false);
            this.add(new Component[]{location});
        } else {
            location = new AjaxDropDownChoicePanel("location", "location", new PropertyModel((Object)connInstanceTO, "location"), false);
            ((AjaxDropDownChoicePanel)location).setChoices(new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations()));
            location.addRequiredLabel();
            location.setOutputMarkupId(true);
            location.getField().setOutputMarkupId(true);
            this.add(new Component[]{location});
            location.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change", (AjaxDropDownChoicePanel)location, bundleName, connInstanceTO){
                private static final long serialVersionUID = -5609231641453245929L;
                final /* synthetic */ AjaxDropDownChoicePanel val$location;
                final /* synthetic */ AjaxDropDownChoicePanel val$bundleName;
                final /* synthetic */ ConnInstanceTO val$connInstanceTO;
                {
                    this.val$location = ajaxDropDownChoicePanel;
                    this.val$bundleName = ajaxDropDownChoicePanel2;
                    this.val$connInstanceTO = connInstanceTO;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    ((DropDownChoice)this.val$location.getField()).setNullValid(false);
                    this.val$bundleName.setEnabled(true);
                    ConnectorRestClient connectorRestClient = new ConnectorRestClient();
                    List bundles = connectorRestClient.getAllBundles().stream().filter(object -> object.getLocation().equals(this.val$connInstanceTO.getLocation())).collect(Collectors.toList());
                    List listBundles = ConnectorDetailsPanel.this.getBundles(this.val$connInstanceTO, bundles);
                    if (listBundles.size() == 1) {
                        this.val$connInstanceTO.setBundleName((String)listBundles.get(0));
                        this.val$bundleName.getField().setModelObject(listBundles.get(0));
                    }
                    this.val$bundleName.setChoices(listBundles);
                    target.add(new Component[]{this.val$bundleName});
                }
            }});
        }
        ((DropDownChoice)bundleName.getField()).setNullValid(true);
        ArrayList bundleNames = new ArrayList();
        bundles.stream().filter(bundle -> !bundleNames.contains(bundle.getBundleName())).forEachOrdered(bundle -> bundleNames.add(bundle.getBundleName()));
        bundleName.setChoices(bundleNames);
        bundleName.addRequiredLabel();
        bundleName.setOutputMarkupId(true);
        bundleName.setEnabled(connInstanceTO.getKey() == null);
        bundleName.getField().setOutputMarkupId(true);
        this.add(new Component[]{bundleName});
        final AjaxDropDownChoicePanel version = new AjaxDropDownChoicePanel("version", "version", new PropertyModel((Object)connInstanceTO, "version"), false);
        version.setChoices(this.getVersions(connInstanceTO, bundles));
        version.addRequiredLabel();
        version.setEnabled(connInstanceTO.getBundleName() != null);
        version.setOutputMarkupId(true);
        version.getField().setOutputMarkupId(true);
        this.add(new Component[]{version});
        bundleName.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                List versions;
                ((DropDownChoice)bundleName.getField()).setNullValid(false);
                version.setEnabled(true);
                if (bundles.isEmpty()) {
                    ConnectorRestClient connectorRestClient = new ConnectorRestClient();
                    List bundles2 = connectorRestClient.getAllBundles().stream().filter(object -> object.getLocation().equals(connInstanceTO.getLocation())).collect(Collectors.toList());
                    versions = ConnectorDetailsPanel.this.getVersions(connInstanceTO, bundles2);
                } else {
                    versions = ConnectorDetailsPanel.this.getVersions(connInstanceTO, bundles);
                }
                if (versions.size() == 1) {
                    connInstanceTO.setVersion((String)versions.get(0));
                    version.getField().setModelObject(versions.get(0));
                }
                version.setChoices(versions);
                target.add(new Component[]{version});
            }
        }});
        if (connInstanceTO.getPoolConf() == null) {
            connInstanceTO.setPoolConf(new ConnPoolConfTO());
        }
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("connRequestTimeout", "connRequestTimeout", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO, "connRequestTimeout"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMaxObjects", "poolMaxObjects", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxObjects"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMinIdle", "poolMinIdle", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minIdle"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMaxIdle", "poolMaxIdle", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxIdle"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Long>().min(0L).max(Long.MAX_VALUE).build("poolMaxWait", "poolMaxWait", Long.class, (IModel<Long>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxWait"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Long>().min(0L).max(Long.MAX_VALUE).build("poolMinEvictableIdleTime", "poolMinEvictableIdleTime", Long.class, (IModel<Long>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minEvictableIdleTimeMillis"))});
    }

    private List<String> getVersions(ConnInstanceTO connInstanceTO, List<ConnBundleTO> bundles) {
        return bundles.stream().filter(object -> object.getLocation().equals(connInstanceTO.getLocation()) && object.getBundleName().equals(connInstanceTO.getBundleName())).map(ConnBundleTO::getVersion).collect(Collectors.toList());
    }

    private List<String> getBundles(ConnInstanceTO connInstanceTO, List<ConnBundleTO> bundles) {
        return bundles.stream().filter(object -> object.getLocation().equals(connInstanceTO.getLocation())).map(ConnBundleTO::getBundleName).collect(Collectors.toList());
    }
}

