/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wizards.resources.AbstractConnConfPanel;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class ResourceConnConfPanel
extends AbstractConnConfPanel<ResourceTO> {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;

    public ResourceConnConfPanel(final ResourceTO resourceTO) {
        super(resourceTO);
        this.model = new LoadableDetachableModel<List<ConnConfProperty>>(){
            private static final long serialVersionUID = -2965284931860212687L;

            protected List<ConnConfProperty> load() {
                List<ConnConfProperty> confOverride = ResourceConnConfPanel.this.getConnProperties(resourceTO);
                resourceTO.getConfOverride().clear();
                resourceTO.getConfOverride().addAll(confOverride);
                return new PropertyModel<List<ConnConfProperty>>(ResourceConnConfPanel.this.modelObject, "confOverride"){
                    private static final long serialVersionUID = -7809699384012595307L;

                    public List<ConnConfProperty> getObject() {
                        ArrayList<ConnConfProperty> res = new ArrayList<ConnConfProperty>((Collection)super.getObject());
                        res.sort((left, right) -> {
                            if (left == null) {
                                return -1;
                            }
                            return left.compareTo(right);
                        });
                        return res;
                    }
                }.getObject();
            }
        };
        this.setConfPropertyListView((IModel<List<ConnConfProperty>>)this.model, true);
        this.check.setEnabled(!((List)this.model.getObject()).isEmpty());
        this.check.setVisible(!((List)this.model.getObject()).isEmpty());
    }

    @Override
    protected final List<ConnConfProperty> getConnProperties(ResourceTO resourceTO) {
        ArrayList<ConnConfProperty> props = new ArrayList<ConnConfProperty>();
        if (resourceTO.getConnector() != null) {
            this.connectorRestClient.read(resourceTO.getConnector()).getConf().stream().filter(ConnConfProperty::isOverridable).forEachOrdered(props::add);
        }
        if (resourceTO.getConfOverride().isEmpty()) {
            resourceTO.getConfOverride().clear();
        } else {
            HashMap valuedProps = new HashMap();
            resourceTO.getConfOverride().forEach(prop -> valuedProps.put(prop.getSchema().getName(), prop));
            for (int i = 0; i < props.size(); ++i) {
                if (!valuedProps.containsKey(((ConnConfProperty)props.get(i)).getSchema().getName())) continue;
                props.set(i, (ConnConfProperty)valuedProps.get(((ConnConfProperty)props.get(i)).getSchema().getName()));
            }
        }
        return props;
    }

    public LoadableDetachableModel<List<ConnConfProperty>> getModel() {
        return this.model;
    }

    public AjaxButton getCheck() {
        return this.check;
    }
}

