/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result.xslt;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.result.xslt.AbstractAdapterNode;
import org.apache.struts2.result.xslt.AdapterFactory;
import org.apache.struts2.result.xslt.AdapterNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ProxyNodeAdapter
extends AbstractAdapterNode {
    private static final Logger LOG = LogManager.getLogger(ProxyNodeAdapter.class);

    protected ProxyNodeAdapter(AdapterFactory factory, AdapterNode parent, Node value) {
        this.setContext(factory, parent, "document", value);
        LOG.debug("Proxied node is: {}", (Object)value);
        LOG.debug("Node class is: {}", value.getClass());
        LOG.debug("Node type is: {}", (Object)value.getNodeType());
        LOG.debug("Node name is: {}", (Object)value.getNodeName());
    }

    protected Node node() {
        return (Node)this.getPropertyValue();
    }

    protected Node wrap(Node node) {
        return this.getAdapterFactory().proxyNode(this, node);
    }

    protected NamedNodeMap wrap(NamedNodeMap nnm) {
        return this.getAdapterFactory().proxyNamedNodeMap(this, nnm);
    }

    @Override
    public String getNodeName() {
        LOG.trace("getNodeName");
        return this.node().getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        LOG.trace("getNodeValue");
        return this.node().getNodeValue();
    }

    @Override
    public short getNodeType() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("getNodeType: {}:{}", (Object)this.getNodeName(), (Object)this.node().getNodeType());
        }
        return this.node().getNodeType();
    }

    @Override
    public NamedNodeMap getAttributes() {
        NamedNodeMap nnm = this.wrap(this.node().getAttributes());
        LOG.trace("getAttributes: {}", (Object)nnm);
        return nnm;
    }

    @Override
    public boolean hasChildNodes() {
        LOG.trace("hasChildNodes");
        return this.node().hasChildNodes();
    }

    @Override
    public boolean isSupported(String s, String s1) {
        LOG.trace("isSupported");
        return this.node().isSupported(s, s1);
    }

    @Override
    public String getNamespaceURI() {
        LOG.trace("getNamespaceURI");
        return this.node().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        LOG.trace("getPrefix");
        return this.node().getPrefix();
    }

    @Override
    public String getLocalName() {
        LOG.trace("getLocalName");
        return this.node().getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        LOG.trace("hasAttributes");
        return this.node().hasAttributes();
    }

    @Override
    public String toString() {
        return "ProxyNode for: " + String.valueOf(this.node());
    }
}

