/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result.xslt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.apache.struts2.result.xslt.AdapterNode;
import org.apache.struts2.result.xslt.ArrayAdapter;
import org.apache.struts2.result.xslt.BeanAdapter;
import org.apache.struts2.result.xslt.CollectionAdapter;
import org.apache.struts2.result.xslt.MapAdapter;
import org.apache.struts2.result.xslt.ProxyAttrAdapter;
import org.apache.struts2.result.xslt.ProxyElementAdapter;
import org.apache.struts2.result.xslt.ProxyNamedNodeMap;
import org.apache.struts2.result.xslt.ProxyTextNodeAdapter;
import org.apache.struts2.result.xslt.SimpleAdapterDocument;
import org.apache.struts2.result.xslt.StringAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AdapterFactory {
    private final Map<Class<?>, Class<?>> adapterTypes = new HashMap();

    public void registerAdapterType(Class<?> type, Class<?> adapterType) {
        this.adapterTypes.put(type, adapterType);
    }

    public Document adaptDocument(String propertyName, Object propertyValue) {
        return new SimpleAdapterDocument(this, null, propertyName, propertyValue);
    }

    public Node adaptNode(AdapterNode parent, String propertyName, Object value) {
        Class<Object> adapterClass = this.getAdapterForValue(value);
        if (adapterClass != null) {
            return this.constructAdapterInstance(adapterClass, parent, propertyName, value);
        }
        if (value instanceof Document) {
            value = ((Document)value).getDocumentElement();
        }
        if (value instanceof Node) {
            return this.proxyNode(parent, (Node)value);
        }
        Class<?> valueType = value.getClass();
        adapterClass = valueType.isArray() ? ArrayAdapter.class : (value instanceof String || value instanceof Number || value instanceof Boolean || valueType.isPrimitive() ? StringAdapter.class : (value instanceof Collection ? CollectionAdapter.class : (value instanceof Map ? MapAdapter.class : BeanAdapter.class)));
        return this.constructAdapterInstance(adapterClass, parent, propertyName, value);
    }

    public Node proxyNode(AdapterNode parent, Node node) {
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return new ProxyElementAdapter(this, parent, (Element)node);
        }
        if (node.getNodeType() == 3) {
            return new ProxyTextNodeAdapter(this, parent, (Text)node);
        }
        if (node.getNodeType() == 2) {
            return new ProxyAttrAdapter(this, parent, (Attr)node);
        }
        return null;
    }

    public NamedNodeMap proxyNamedNodeMap(AdapterNode parent, NamedNodeMap nnm) {
        return new ProxyNamedNodeMap(this, parent, nnm);
    }

    private Node constructAdapterInstance(Class<?> adapterClass, AdapterNode parent, String propertyName, Object propertyValue) {
        try {
            adapterClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            throw new StrutsException("Adapter class: " + adapterClass + " does not have a no-args constructor.");
        }
        try {
            AdapterNode adapterNode = (AdapterNode)adapterClass.newInstance();
            adapterNode.setAdapterFactory(this);
            adapterNode.setParent(parent);
            adapterNode.setPropertyName(propertyName);
            adapterNode.setPropertyValue(propertyValue);
            return adapterNode;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new StrutsException("Cannot adapt " + propertyValue + " (" + propertyName + ") :" + e.getMessage(), (Throwable)e);
        }
    }

    public Node adaptNullValue(AdapterNode parent, String propertyName) {
        return new StringAdapter(this, parent, propertyName, "null");
    }

    public Class<?> getAdapterForValue(Object value) {
        return this.adapterTypes.get(value.getClass());
    }
}

