/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpClient;
import org.apache.sshd.client.subsystem.sftp.impl.SftpAckData;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.OutputStreamWithChannel;

public class SftpOutputStreamAsync
extends OutputStreamWithChannel {
    protected final byte[] bb = new byte[1];
    protected final int bufferSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long offset;
    protected final Deque<SftpAckData> pendingWrites = new LinkedList<SftpAckData>();
    private final AbstractSftpClient client;
    private final String path;

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.client = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = client.open(path, mode);
        this.bufferSize = bufferSize;
    }

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, SftpClient.CloseableHandle handle) throws IOException {
        this.client = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = handle;
        this.bufferSize = bufferSize;
    }

    public final AbstractSftpClient getClient() {
        return this.client;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    public void write(int b) throws IOException {
        this.bb[0] = (byte)b;
        this.write(this.bb, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int nb;
        byte[] id = this.handle.getIdentifier();
        ClientSession session = this.client.getSession();
        do {
            if (this.buffer == null) {
                this.buffer = session.createBuffer((byte)94, this.bufferSize);
                int hdr = 33 + id.length + this.buffer.wpos();
                this.buffer.rpos(hdr);
                this.buffer.wpos(hdr);
            }
            int max = this.bufferSize - (25 + id.length + 72);
            nb = Math.min(len, max - (this.buffer.wpos() - this.buffer.rpos()));
            this.buffer.putRawBytes(b, off, nb);
            if (this.buffer.available() == max) {
                this.flush();
            }
            off += nb;
        } while ((len -= nb) > 0);
    }

    public void flush() throws IOException {
        ByteArrayBuffer buf;
        Buffer response;
        SftpAckData ack;
        if (!this.isOpen()) {
            throw new IOException("flush(" + this.getPath() + ") stream is closed");
        }
        while ((ack = this.pendingWrites.peek()) != null && (response = this.client.receive(ack.id, 0L)) != null) {
            this.pendingWrites.removeFirst();
            this.client.checkResponseStatus(6, response);
        }
        byte[] id = this.handle.getIdentifier();
        int avail = this.buffer.available();
        if (this.buffer.rpos() >= 16 + id.length) {
            int wpos = this.buffer.wpos();
            this.buffer.rpos(this.buffer.rpos() - 16 - id.length);
            this.buffer.wpos(this.buffer.rpos());
            this.buffer.putBytes(id);
            this.buffer.putLong(this.offset);
            this.buffer.putInt((long)avail);
            this.buffer.wpos(wpos);
            buf = this.buffer;
        } else {
            buf = new ByteArrayBuffer(id.length + avail + 64, false);
            buf.putBytes(id);
            buf.putLong(this.offset);
            buf.putBytes(this.buffer.array(), this.buffer.rpos(), avail);
        }
        int reqId = this.client.send(6, (Buffer)buf);
        this.pendingWrites.add(new SftpAckData(reqId, this.offset, avail));
        this.offset += (long)avail;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isOpen()) {
            try {
                try {
                    if (this.buffer != null && this.buffer.available() > 0) {
                        this.flush();
                    }
                    while (!this.pendingWrites.isEmpty()) {
                        SftpAckData ack = this.pendingWrites.removeFirst();
                        Buffer response = this.client.receive(ack.id);
                        this.client.checkResponseStatus(6, response);
                    }
                }
                finally {
                    this.handle.close();
                }
            }
            finally {
                this.handle = null;
            }
        }
    }
}

