/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.scp.ScpSourceStreamResolver;
import org.apache.sshd.common.scp.ScpTargetStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.io.DirectoryScanner;
import org.apache.sshd.common.util.io.IoUtils;

public interface ScpFileOpener {
    default public Path resolveIncomingFilePath(Path localPath, String name, boolean preserve, Set<PosixFilePermission> permissions, ScpTimestamp time) throws IOException {
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        Boolean status = IoUtils.checkFileExists((Path)localPath, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory existence status cannot be determined: " + localPath);
        }
        Path file = null;
        if (status.booleanValue() && Files.isDirectory(localPath, options)) {
            String localName = name.replace('/', File.separatorChar);
            file = localPath.resolve(localName);
        } else if (!status.booleanValue()) {
            Path parent = localPath.getParent();
            status = IoUtils.checkFileExists((Path)parent, (LinkOption[])options);
            if (status == null) {
                throw new AccessDeniedException("Receive directory parent (" + parent + ") existence status cannot be determined for " + localPath);
            }
            if (status.booleanValue() && Files.isDirectory(parent, options)) {
                file = localPath;
            }
        }
        if (file == null) {
            throw new IOException("Cannot write to " + localPath);
        }
        status = IoUtils.checkFileExists(file, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory file existence status cannot be determined: " + file);
        }
        if (!status.booleanValue() || !Files.isDirectory(file, options)) {
            Files.createDirectory(file, new FileAttribute[0]);
        }
        if (preserve) {
            ScpFileOpener.updateFileProperties(file, permissions, time);
        }
        return file;
    }

    default public Iterable<String> getMatchingFilesToSend(String basedir, String pattern) {
        Object[] matches = new DirectoryScanner(basedir, new String[]{pattern}).scan();
        if (GenericUtils.isEmpty((Object[])matches)) {
            return Collections.emptyList();
        }
        return Arrays.asList(matches);
    }

    default public boolean sendAsRegularFile(Path path, LinkOption ... options) throws IOException {
        return Files.isRegularFile(path, options);
    }

    default public boolean sendAsDirectory(Path path, LinkOption ... options) throws IOException {
        return Files.isDirectory(path, options);
    }

    default public DirectoryStream<Path> getLocalFolderChildren(Path path) throws IOException {
        return Files.newDirectoryStream(path);
    }

    default public BasicFileAttributes getLocalBasicFileAttributes(Path path, LinkOption ... options) throws IOException {
        return Files.getFileAttributeView(path, BasicFileAttributeView.class, options).readAttributes();
    }

    default public Set<PosixFilePermission> getLocalFilePermissions(Path path, LinkOption ... options) throws IOException {
        return IoUtils.getPermissions((Path)path, (LinkOption[])options);
    }

    default public Path resolveLocalPath(FileSystem fileSystem, String commandPath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath((String)commandPath, (char)File.separatorChar, (FileSystem)fileSystem);
        Path lcl = fileSystem.getPath(path, new String[0]);
        Path abs = lcl.isAbsolute() ? lcl : lcl.toAbsolutePath();
        return abs.normalize();
    }

    default public Path resolveIncomingReceiveLocation(Path path, boolean recursive, boolean shouldBeDir, boolean preserve) throws IOException {
        if (!shouldBeDir) {
            return path;
        }
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        Boolean status = IoUtils.checkFileExists((Path)path, (LinkOption[])options);
        if (status == null) {
            throw new SshException("Target directory " + path + " is most like inaccessible");
        }
        if (!status.booleanValue()) {
            throw new SshException("Target directory " + path + " does not exist");
        }
        if (!Files.isDirectory(path, options)) {
            throw new SshException("Target directory " + path + " is not a directory");
        }
        return path;
    }

    default public Path resolveOutgoingFilePath(Path localPath, LinkOption ... options) throws IOException {
        Boolean status = IoUtils.checkFileExists((Path)localPath, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Send file existence status cannot be determined: " + localPath);
        }
        if (!status.booleanValue()) {
            throw new IOException(localPath + ": no such file or directory");
        }
        return localPath;
    }

    public InputStream openRead(Session var1, Path var2, OpenOption ... var3) throws IOException;

    public ScpSourceStreamResolver createScpSourceStreamResolver(Path var1) throws IOException;

    public OutputStream openWrite(Session var1, Path var2, OpenOption ... var3) throws IOException;

    public ScpTargetStreamResolver createScpTargetStreamResolver(Path var1) throws IOException;

    public static void updateFileProperties(Path file, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        IoUtils.setPermissions((Path)file, perms);
        if (time != null) {
            BasicFileAttributeView view = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
            FileTime lastModified = FileTime.from(time.getLastModifiedTime(), TimeUnit.MILLISECONDS);
            FileTime lastAccess = FileTime.from(time.getLastAccessTime(), TimeUnit.MILLISECONDS);
            view.setTimes(lastModified, lastAccess, null);
        }
    }
}

