/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.config.keys.IdentityResourceLoader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public interface PuttyKeyPairResourceParser<PUB extends PublicKey, PRV extends PrivateKey>
extends IdentityResourceLoader<PUB, PRV>,
KeyPairResourceParser {
    public static final String KEY_FILE_HEADER_PREFIX = "PuTTY-User-Key-File";
    public static final String PUBLIC_LINES_HEADER = "Public-Lines";
    public static final String PRIVATE_LINES_HEADER = "Private-Lines";
    public static final String PPK_FILE_SUFFIX = ".ppk";
    public static final List<String> KNOWN_HEADERS = Collections.unmodifiableList(Arrays.asList("PuTTY-User-Key-File", "Public-Lines", "Private-Lines"));
    public static final String NO_PRIVATE_KEY_ENCRYPTION_VALUE = "none";

    default public boolean canExtractKeyPairs(String resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(lines)) {
            return false;
        }
        for (String l : lines) {
            l = GenericUtils.trimToEmpty((String)l);
            for (String hdr : KNOWN_HEADERS) {
                if (!l.startsWith(hdr)) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] decodePrivateKeyBytes(byte[] prvBytes, String algName, int numBits, String algMode, String password) throws GeneralSecurityException {
        Objects.requireNonNull(prvBytes, "No encrypted key bytes");
        ValidateUtils.checkNotNullAndNotEmpty((String)algName, (String)"No encryption algorithm", (Object[])GenericUtils.EMPTY_OBJECT_ARRAY);
        ValidateUtils.checkTrue((numBits > 0 ? 1 : 0) != 0, (String)"Invalid encryption key size: %d", (long)numBits);
        ValidateUtils.checkNotNullAndNotEmpty((String)algMode, (String)"No encryption mode", (Object[])GenericUtils.EMPTY_OBJECT_ARRAY);
        ValidateUtils.checkNotNullAndNotEmpty((String)password, (String)"No encryption password", (Object[])GenericUtils.EMPTY_OBJECT_ARRAY);
        if (!"AES".equalsIgnoreCase(algName)) {
            throw new NoSuchAlgorithmException("decodePrivateKeyBytes(" + algName + "-" + numBits + "-" + algMode + ") N/A");
        }
        return PuttyKeyPairResourceParser.decodePrivateKeyBytes(prvBytes, algName, algMode, numBits, new byte[16], PuttyKeyPairResourceParser.toEncryptionKey(password));
    }

    public static byte[] decodePrivateKeyBytes(byte[] encBytes, String cipherName, String cipherMode, int numBits, byte[] initVector, byte[] keyValue) throws GeneralSecurityException {
        String xform = cipherName + "/" + cipherMode + "/NoPadding";
        int maxAllowedBits = Cipher.getMaxAllowedKeyLength(xform);
        if (numBits > maxAllowedBits) {
            throw new InvalidKeySpecException("decodePrivateKeyBytes(" + xform + ") required key length (" + numBits + ") exceeds max. available: " + maxAllowedBits);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(keyValue, cipherName);
        IvParameterSpec ivspec = new IvParameterSpec(initVector);
        Cipher cipher = SecurityUtils.getCipher((String)xform);
        cipher.init(2, (Key)skeySpec, ivspec);
        return cipher.doFinal(encBytes);
    }

    public static byte[] toEncryptionKey(String passphrase) throws GeneralSecurityException {
        if (GenericUtils.isEmpty((CharSequence)passphrase)) {
            return null;
        }
        MessageDigest hash = SecurityUtils.getMessageDigest((String)BuiltinDigests.sha1.getAlgorithm());
        byte[] stateValue = new byte[]{0, 0, 0, 0};
        byte[] passBytes = passphrase.getBytes(StandardCharsets.UTF_8);
        byte[] keyValue = new byte[32];
        int remLen = keyValue.length;
        for (int i = 0; i < 2; ++i) {
            hash.reset();
            stateValue[3] = (byte)i;
            hash.update(stateValue);
            hash.update(passBytes);
            byte[] digest = hash.digest();
            System.arraycopy(digest, 0, keyValue, i * 20, Math.min(20, remLen));
            remLen -= 20;
        }
        return keyValue;
    }
}

