/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.git.pgm.EmbeddedCommandRunner;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPgmCommand
implements Command,
Runnable {
    private String rootDir;
    private String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public GitPgmCommand(String rootDir, String command) {
        this.rootDir = rootDir;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
        if (out instanceof ChannelOutputStream) {
            ((ChannelOutputStream)out).setNoDelay(true);
        }
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
        if (err instanceof ChannelOutputStream) {
            ((ChannelOutputStream)err).setNoDelay(true);
        }
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        new Thread(this).start();
    }

    @Override
    public void run() {
        block7: {
            try {
                List<String> strs = GitPgmCommand.parseDelimitedString(this.command, " ", true);
                String[] args = strs.toArray(new String[strs.size()]);
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("'") && args[i].endsWith("'")) {
                        args[i] = args[i].substring(1, args[i].length() - 1);
                    }
                    if (!args[i].startsWith("\"") || !args[i].endsWith("\"")) continue;
                    args[i] = args[i].substring(1, args[i].length() - 1);
                }
                new EmbeddedCommandRunner(this.rootDir).execute(args, this.in, this.out, this.err);
                if (this.callback != null) {
                    this.callback.onExit(0);
                }
            }
            catch (Throwable t) {
                try {
                    this.err.write((t.getMessage() + "\n").getBytes());
                    this.err.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.callback == null) break block7;
                this.callback.onExit(-1);
            }
        }
    }

    public void destroy() {
    }

    private static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuilder sb = new StringBuilder();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & DELIMITER) > 0) {
                if (trim) {
                    list.add(sb.toString().trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
            } else if (c == '\"' && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
            } else if (c == '\"' && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
            } else if ((expecting & CHAR) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                list.add(sb.toString().trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }
}

