/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.BasicCredentials;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.STSCredentials;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0001\u0003\u0005\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\tA2*\u001b8fg&\u001cX\u000b^5mgBKH\u000f[8o\u0011\u0016d\u0007/\u001a:\u000b\u0005\u00151\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000f!\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0003\u0002\u0019\r\u0014X-\u0019;f'R\u0014X-Y7\u0015\u001fqQs\u0006\u0010 A\u0005\u001ekujV-\\;~\u00032!\b\u0012%\u001b\u0005q\"BA\u0010!\u0003\u0011Q\u0017M^1\u000b\u0005\u00052\u0011aA1qS&\u00111E\b\u0002\u0019\u0015\u00064\u0018MU3dK&4XM]%oaV$Hi\u0015;sK\u0006l\u0007cA\t&O%\u0011aE\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003#!J!!\u000b\n\u0003\t\tKH/\u001a\u0005\u0006W\t\u0001\r\u0001L\u0001\u0005UN\u001c8\r\u0005\u0002\u001e[%\u0011aF\b\u0002\u0015\u0015\u00064\u0018m\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000bA\u0012\u0001\u0019A\u0019\u0002\u001d-Lg.Z:jg\u0006\u0003\bOT1nKB\u0011!'\u000f\b\u0003g]\u0002\"\u0001\u000e\n\u000e\u0003UR!A\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\tA$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u0013\u0011\u0015i$\u00011\u00012\u0003)\u0019HO]3b[:\u000bW.\u001a\u0005\u0006\u007f\t\u0001\r!M\u0001\fK:$\u0007o\\5oiV\u0013H\u000eC\u0003B\u0005\u0001\u0007\u0011'\u0001\u0006sK\u001eLwN\u001c(b[\u0016DQa\u0011\u0002A\u0002\u0011\u000bq#\u001b8ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\u0011\u0005E)\u0015B\u0001$\u0013\u0005\rIe\u000e\u001e\u0005\u0006\u0011\n\u0001\r!S\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002K\u00176\ta!\u0003\u0002M\r\tAA)\u001e:bi&|g\u000eC\u0003O\u0005\u0001\u0007A)\u0001\u0007nKR\u0014\u0018nY:MKZ,G\u000eC\u0003Q\u0005\u0001\u0007\u0011+\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0002S+6\t1K\u0003\u0002U\u0011\u000591\u000f^8sC\u001e,\u0017B\u0001,T\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u0015A&\u00011\u00012\u00039\two]!dG\u0016\u001c8oS3z\u0013\u0012DQA\u0017\u0002A\u0002E\nA\"Y<t'\u0016\u001c'/\u001a;LKfDQ\u0001\u0018\u0002A\u0002E\n\u0001c\u001d;t\u0003N\u001cX/\\3S_2,\u0017I\u001d8\t\u000by\u0013\u0001\u0019A\u0019\u0002\u001dM$8oU3tg&|gNT1nK\")\u0001M\u0001a\u0001c\u0005i1\u000f^:FqR,'O\\1m\u0013\u0012\u0004")
public class KinesisUtilsPythonHelper {
    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, int initialPositionInStream, Duration checkpointInterval, int metricsLevel, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        JavaReceiverInputDStream javaReceiverInputDStream;
        MetricsLevel metricsLevel2;
        InitialPositionInStream initialPositionInStream2;
        if (!(stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null || stsAssumeRoleArn == null && stsSessionName == null && stsExternalId == null)) {
            throw new IllegalArgumentException("stsAssumeRoleArn, stsSessionName, and stsExternalId must all be defined or all be null");
        }
        if (awsAccessKeyId == null && awsSecretKey != null) {
            throw new IllegalArgumentException("awsSecretKey is set but awsAccessKeyId is null");
        }
        if (awsAccessKeyId != null && awsSecretKey == null) {
            throw new IllegalArgumentException("awsAccessKeyId is set but awsSecretKey is null");
        }
        int n = initialPositionInStream;
        switch (n) {
            case 0: {
                initialPositionInStream2 = InitialPositionInStream.LATEST;
                break;
            }
            case 1: {
                initialPositionInStream2 = InitialPositionInStream.TRIM_HORIZON;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal InitialPositionInStream. Please use InitialPositionInStream.LATEST or InitialPositionInStream.TRIM_HORIZON");
            }
        }
        InitialPositionInStream kinesisInitialPosition = initialPositionInStream2;
        int n2 = metricsLevel;
        switch (n2) {
            case 0: {
                metricsLevel2 = MetricsLevel.DETAILED;
                break;
            }
            case 1: {
                metricsLevel2 = MetricsLevel.SUMMARY;
                break;
            }
            case 2: {
                metricsLevel2 = MetricsLevel.NONE;
                break;
            }
            default: {
                metricsLevel2 = MetricsLevel.DETAILED;
                break;
            }
        }
        MetricsLevel cloudWatchMetricsLevel = metricsLevel2;
        KinesisInputDStream.Builder builder = KinesisInputDStream$.MODULE$.builder().streamingContext(jssc).checkpointAppName(kinesisAppName).streamName(streamName).endpointUrl(endpointUrl).regionName(regionName).initialPosition(KinesisInitialPositions.fromKinesisInitialPosition(kinesisInitialPosition)).checkpointInterval(checkpointInterval).metricsLevel(cloudWatchMetricsLevel).storageLevel(storageLevel);
        if (stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null) {
            STSCredentials kinesisCredsProvider = new STSCredentials(stsAssumeRoleArn, stsSessionName, (Option<String>)Option$.MODULE$.apply((Object)stsExternalId), new BasicCredentials(awsAccessKeyId, awsSecretKey));
            javaReceiverInputDStream = JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.kinesisCredentials(kinesisCredsProvider).buildWithMessageHandler((Function1 & Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        } else {
            javaReceiverInputDStream = awsAccessKeyId == null && awsSecretKey == null ? JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.build(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.kinesisCredentials(new BasicCredentials(awsAccessKeyId, awsSecretKey)).build(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }
        return javaReceiverInputDStream;
    }
}

