/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KinesisTestUtils$ {
    public static final KinesisTestUtils$ MODULE$ = new KinesisTestUtils$();
    private static boolean shouldRunTests;
    private static String endpointUrl;
    private static final String envVarNameForEnablingTests;
    private static final String endVarNameForEndpoint;
    private static final String defaultEndpointUrl;
    private static volatile byte bitmap$0;

    static {
        envVarNameForEnablingTests = "ENABLE_KINESIS_TESTS";
        endVarNameForEndpoint = "KINESIS_TEST_ENDPOINT_URL";
        defaultEndpointUrl = "https://kinesis.us-west-2.amazonaws.com";
    }

    public int $lessinit$greater$default$1() {
        return 2;
    }

    public String envVarNameForEnablingTests() {
        return envVarNameForEnablingTests;
    }

    public String endVarNameForEndpoint() {
        return endVarNameForEndpoint;
    }

    public String defaultEndpointUrl() {
        return defaultEndpointUrl;
    }

    public String getRegionNameByEndpoint(String endpoint) {
        URI uri = new URI(endpoint);
        return (String)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(RegionUtils.getRegionsForService((String)"kinesis")).asScala()).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KinesisTestUtils$.$anonfun$getRegionNameByEndpoint$1(uri, x$2))).map((Function1 & Serializable)x$3 -> x$3.getName()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(39).append("Could not resolve region for endpoint: ").append(endpoint).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldRunTests$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                void var2_3;
                boolean isEnvSet;
                Option option = package$.MODULE$.env().get((Object)this.envVarNameForEnablingTests());
                Some some = new Some((Object)"1");
                boolean bl = !(option != null ? !option.equals(some) : some != null) ? true : (isEnvSet = false);
                if (isEnvSet) {
                    Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(536).append("\n          |Kinesis tests that actually send data has been enabled by setting the environment\n          |variable ").append(this.envVarNameForEnablingTests()).append(" to 1. This will create Kinesis Streams and\n          |DynamoDB tables in AWS. Please be aware that this may incur some AWS costs.\n          |By default, the tests use the endpoint URL ").append(this.defaultEndpointUrl()).append(" to create Kinesis streams.\n          |To change this endpoint URL to a different region, you can set the environment variable\n          |").append(this.endVarNameForEndpoint()).append(" to the desired endpoint URL\n          |(e.g. ").append(this.endVarNameForEndpoint()).append("=\"https://kinesis.us-west-2.amazonaws.com\").\n        ").toString())));
                }
                shouldRunTests = var2_3;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return shouldRunTests;
    }

    public boolean shouldRunTests() {
        return (byte)(bitmap$0 & 1) == 0 ? this.shouldRunTests$lzycompute() : shouldRunTests;
    }

    /*
     * WARNING - void declaration
     */
    private String endpointUrl$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                void var2_2;
                String url = (String)package$.MODULE$.env().getOrElse((Object)this.endVarNameForEndpoint(), (Function0 & Serializable)() -> MODULE$.defaultEndpointUrl());
                Predef$.MODULE$.println((Object)new StringBuilder(59).append("Using endpoint URL ").append(url).append(" for creating Kinesis streams for tests.").toString());
                endpointUrl = var2_2;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return endpointUrl;
    }

    public String endpointUrl() {
        return (byte)(bitmap$0 & 2) == 0 ? this.endpointUrl$lzycompute() : endpointUrl;
    }

    public boolean isAWSCredentialsPresent() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new DefaultAWSCredentialsProviderChain().getCredentials()).isSuccess();
    }

    public AWSCredentials getAWSCredentials() {
        AWSCredentials cred;
        Predef$.MODULE$.assert(this.shouldRunTests(), (Function0 & Serializable)() -> "Kinesis test not enabled, should not attempt to get AWS credentials");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new DefaultAWSCredentialsProviderChain().getCredentials());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new Exception(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |Kinesis tests enabled using environment variable ").append(this.envVarNameForEnablingTests()).append("\n             |but could not find AWS credentials. Please follow instructions in AWS documentation\n             |to set the credentials in your system such that the DefaultAWSCredentialsProviderChain\n             |can find the credentials.\n           ").toString())));
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        AWSCredentials aWSCredentials = cred = (AWSCredentials)success.value();
        return aWSCredentials;
    }

    public static final /* synthetic */ boolean $anonfun$getRegionNameByEndpoint$1(URI uri$1, Region x$2) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$2.getAvailableEndpoints()).asScala()).toSeq().contains((Object)uri$1.getHost());
    }

    private KinesisTestUtils$() {
    }
}

