/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tEh!B\u001b7\u0001Y\u0002\u0005\u0002C/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011)\u0004!\u0011!Q\u0001\n}C\u0001b\u001b\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tY\u0002\u0011\t\u0011)A\u0005?\"AQ\u000e\u0001B\u0001B\u0003%a\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\bA!A!\u0002\u0013!\b\"\u0003=\u0001\u0005\u0003\u0005\u000b\u0011B=\u0000\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002.!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005U\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013Bq!a\u0014\u0001\t\u0003\t\t\u0006\u0003\u0005\u0002p\u0001\u0001\r\u0011\"\u0003_\u0011%\t\t\b\u0001a\u0001\n\u0013\t\u0019\bC\u0004\u0002\u0000\u0001\u0001\u000b\u0015B0\t\u0013\u0005%\u0005\u00011A\u0005\n\u0005-\u0005\"CAP\u0001\u0001\u0007I\u0011BAQ\u0011!\t)\u000b\u0001Q!\n\u00055\u0005\"CAU\u0001\u0001\u0007I\u0011BAV\u0011%\ti\f\u0001a\u0001\n\u0013\ty\f\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BAW\u0011%\t9\r\u0001a\u0001\n\u0013\tI\rC\u0005\u0002R\u0002\u0001\r\u0011\"\u0003\u0002T\"A\u0011q\u001b\u0001!B\u0013\tY\rC\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\"A\u0011Q\u001f\u0001!\u0002\u0013\ty\u000eC\u0005\u0002x\u0002\u0011\r\u0011\"\u0003\u0002z\"A!q\u0003\u0001!\u0002\u0013\tY\u0010C\u0005\u0003\u001a\u0001\u0001\r\u0011\"\u0003\u0003\u001c!I!1\u0005\u0001A\u0002\u0013%!Q\u0005\u0005\t\u0005S\u0001\u0001\u0015)\u0003\u0003\u001e!I!Q\u0006\u0001C\u0002\u0013%!q\u0006\u0005\t\u0005g\u0001\u0001\u0015!\u0003\u00032!9!Q\u0007\u0001\u0005B\t]\u0002b\u0002B\u001d\u0001\u0011\u0005#q\u0007\u0005\t\u0005w\u0001A\u0011\u0001\u001c\u0003>!A!q\n\u0001\u0005\u0002Y\u0012\t\u0006\u0003\u0005\u0003Z\u0001!\tA\u000eB.\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqA!\u001e\u0001\t\u0003\u00119\bC\u0004\u0003~\u0001!IAa \t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!Q\u0012\u0001\u0005\n\t=eA\u0002BM\u0001\u0011\u0011Y\nC\u0004\u0002P=\"\tA!+\t\u000f\t=v\u0006\"\u0001\u00032\"9!1X\u0018\u0005\u0002\tu\u0006b\u0002Ba_\u0011\u0005!1\u0019\u0005\b\u0005'|C\u0011\u0001Bk\u0005=Y\u0015N\\3tSN\u0014VmY3jm\u0016\u0014(BA\u001c9\u0003\u001dY\u0017N\\3tSNT!!\u000f\u001e\u0002\u0013M$(/Z1nS:<'BA\u001e=\u0003\u0015\u0019\b/\u0019:l\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0016\u0005\u0005S5c\u0001\u0001C/B\u00191I\u0012%\u000e\u0003\u0011S!!\u0012\u001d\u0002\u0011I,7-Z5wKJL!a\u0012#\u0003\u0011I+7-Z5wKJ\u0004\"!\u0013&\r\u0001\u0011)1\n\u0001b\u0001\u001b\n\tAk\u0001\u0001\u0012\u00059#\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&a\u0002(pi\"Lgn\u001a\t\u0003\u001fVK!A\u0016)\u0003\u0007\u0005s\u0017\u0010\u0005\u0002Y76\t\u0011L\u0003\u0002[u\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002]3\n9Aj\\4hS:<\u0017AC:ue\u0016\fWNT1nKV\tq\f\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003EBk\u0011a\u0019\u0006\u0003I2\u000ba\u0001\u0010:p_Rt\u0014B\u00014Q\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u0004\u0016aC:ue\u0016\fWNT1nK\u0002\n1\"\u001a8ea>Lg\u000e^+sY\u0006Q!/Z4j_:t\u0015-\\3\u0002\u001f%t\u0017\u000e^5bYB{7/\u001b;j_:\u0004\"a\u001c9\u000e\u0003YJ!!\u001d\u001c\u0003--Kg.Z:jg&s\u0017\u000e^5bYB{7/\u001b;j_:\f\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0003I\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197\u0011\u0005U4X\"\u0001\u001d\n\u0005]D$\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0005ilX\"A>\u000b\u0005qT\u0014aB:u_J\fw-Z\u0005\u0003}n\u0014Ab\u0015;pe\u0006<W\rT3wK2L!\u0001\u001f$\u0002\u001d5,7o]1hK\"\u000bg\u000e\u001a7feB1q*!\u0002\u0002\n!K1!a\u0002Q\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\f\u0005}QBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000b5|G-\u001a7\u000b\u0007]\n\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001C:feZL7-Z:\u000b\t\u0005e\u00111D\u0001\nC6\f'p\u001c8boNT!!!\b\u0002\u0007\r|W.\u0003\u0003\u0002\"\u00055!A\u0002*fG>\u0014H-\u0001\u0007lS:,7/[:De\u0016$7\u000fE\u0002p\u0003OI1!!\u000b7\u0005M\u0019\u0006/\u0019:l\u0003^\u001b6I]3eK:$\u0018.\u00197t\u00035!\u0017P\\1n_\u0012\u00135I]3egB)q*a\f\u0002&%\u0019\u0011\u0011\u0007)\u0003\r=\u0003H/[8o\u0003=\u0019Gn\\;e/\u0006$8\r[\"sK\u0012\u001c\u0018\u0001D7fiJL7m\u001d'fm\u0016d\u0007\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u000bS:$XM\u001d4bG\u0016\u001c(\u0002BA!\u0003#\tq!\\3ue&\u001c7/\u0003\u0003\u0002F\u0005m\"\u0001D'fiJL7m\u001d'fm\u0016d\u0017\u0001G7fiJL7m]#oC\ndW\r\u001a#j[\u0016t7/[8ogB!\u0001-a\u0013`\u0013\r\ti%\u001b\u0002\u0004'\u0016$\u0018A\u0002\u001fj]&$h\b\u0006\u000f\u0002T\u0005U\u0013qKA-\u00037\ni&a\u0018\u0002b\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0011\u0007=\u0004\u0001\nC\u0003^\u001f\u0001\u0007q\fC\u0003l\u001f\u0001\u0007q\fC\u0003m\u001f\u0001\u0007q\fC\u0003n\u001f\u0001\u0007a\u000eC\u0003s\u001f\u0001\u0007q\fC\u0003t\u001f\u0001\u0007A\u000fC\u0003y\u001f\u0001\u0007\u0011\u0010C\u0004\u0002\u0002=\u0001\r!a\u0001\t\u000f\u0005\rr\u00021\u0001\u0002&!9\u00111F\bA\u0002\u00055\u0002bBA\u001a\u001f\u0001\u0007\u0011Q\u0006\u0005\b\u0003ky\u0001\u0019AA\u001c\u0011\u001d\t9e\u0004a\u0001\u0003\u0013\n\u0001b^8sW\u0016\u0014\u0018\nZ\u0001\ro>\u00148.\u001a:JI~#S-\u001d\u000b\u0005\u0003k\nY\bE\u0002P\u0003oJ1!!\u001fQ\u0005\u0011)f.\u001b;\t\u0011\u0005u\u0014#!AA\u0002}\u000b1\u0001\u001f\u00132\u0003%9xN]6fe&#\u0007\u0005K\u0002\u0013\u0003\u0007\u00032aTAC\u0013\r\t9\t\u0015\u0002\tm>d\u0017\r^5mK\u00061qo\u001c:lKJ,\"!!$\u0011\t\u0005=\u00151T\u0007\u0003\u0003#SA!!#\u0002\u0014*!\u0011QSAL\u0003\ra\u0017N\u0019\u0006\u0005\u00033\u000b\t\"A\u0007dY&,g\u000e\u001e7jEJ\f'/_\u0005\u0005\u0003;\u000b\tJ\u0001\u0004X_J\\WM]\u0001\u000bo>\u00148.\u001a:`I\u0015\fH\u0003BA;\u0003GC\u0011\"! \u0015\u0003\u0003\u0005\r!!$\u0002\u000f]|'o[3sA!\u001aQ#a!\u0002\u0019]|'o[3s)\"\u0014X-\u00193\u0016\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0006!!.\u0019<b\u0013\u0011\tY,!-\u0003\rQC'/Z1e\u0003A9xN]6feRC'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002v\u0005\u0005\u0007\"CA?/\u0005\u0005\t\u0019AAW\u000359xN]6feRC'/Z1eA!\u001a\u0001$a!\u0002\u001d\tdwnY6HK:,'/\u0019;peV\u0011\u00111\u001a\t\u0004\u0007\u00065\u0017bAAh\t\nq!\t\\8dW\u001e+g.\u001a:bi>\u0014\u0018A\u00052m_\u000e\\w)\u001a8fe\u0006$xN]0%KF$B!!\u001e\u0002V\"I\u0011Q\u0010\u000e\u0002\u0002\u0003\u0007\u00111Z\u0001\u0010E2|7m[$f]\u0016\u0014\u0018\r^8sA!\u001a1$a!\u00025M,\u0017OT;n%\u0006tw-Z:J]\u000e+(O]3oi\ncwnY6\u0016\u0005\u0005}\u0007CBAq\u0003W\fy/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u001diW\u000f^1cY\u0016T1!!;Q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\f\u0019OA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA8\u0002r&\u0019\u00111\u001f\u001c\u0003'M+\u0017/^3oG\u0016tU/\u001c2feJ\u000bgnZ3\u00027M,\u0017OT;n%\u0006tw-Z:J]\u000e+(O]3oi\ncwnY6!\u0003U\u0011Gn\\2l\u0013\u0012$vnU3r\u001dVl'+\u00198hKN,\"!a?\u0011\u0011\u0005u(q\u0001B\u0006\u0005#i!!a@\u000b\t\t\u0005!1A\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B\u0003\u0003k\u000bA!\u001e;jY&!!\u0011BA\u0000\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004u\n5\u0011b\u0001B\bw\ni1\u000b\u001e:fC6\u0014En\\2l\u0013\u0012\u00042a\u001cB\n\u0013\r\u0011)B\u000e\u0002\u0015'\u0016\fX/\u001a8dK:+XNY3s%\u0006tw-Z:\u0002-\tdwnY6JIR{7+Z9Ok6\u0014\u0016M\\4fg\u0002\n1c[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ,\"A!\b\u0011\u0007=\u0014y\"C\u0002\u0003\"Y\u00121cS5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\fqc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ|F%Z9\u0015\t\u0005U$q\u0005\u0005\n\u0003{\n\u0013\u0011!a\u0001\u0005;\tAc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\u0004\u0003f\u0001\u0012\u0002\u0004\u0006Y2\u000f[1sI&#Gk\u001c'bi\u0016\u001cHo\u0015;pe\u0016$7+Z9Ok6,\"A!\r\u0011\r\u0005u(qA0`\u0003q\u0019\b.\u0019:e\u0013\u0012$v\u000eT1uKN$8\u000b^8sK\u0012\u001cV-\u001d(v[\u0002\nqa\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002v\u00051qN\\*u_B\f!\"\u00193e%\u0016\u001cwN\u001d3t)\u0019\t)Ha\u0010\u0003D!1!\u0011I\u0014A\u0002}\u000bqa\u001d5be\u0012LE\rC\u0004\u0003F\u001d\u0002\rAa\u0012\u0002\u000fI,7m\u001c:egB1!\u0011\nB&\u0003\u0013i!Aa\u0001\n\t\t5#1\u0001\u0002\u0005\u0019&\u001cH/A\bhKR\u001cUO\u001d:f]Rd\u0015.\\5u+\t\u0011\u0019\u0006E\u0002P\u0005+J1Aa\u0016Q\u0005\rIe\u000e^\u0001\u001cO\u0016$H*\u0019;fgR\u001cV-\u001d(v[R{7\t[3dWB|\u0017N\u001c;\u0015\t\tu#q\f\t\u0005\u001f\u0006=r\f\u0003\u0004\u0003B%\u0002\raX\u0001\u0010g\u0016$8\t[3dWB|\u0017N\u001c;feR1\u0011Q\u000fB3\u0005OBaA!\u0011+\u0001\u0004y\u0006b\u0002B5U\u0001\u0007!1N\u0001\rG\",7m\u001b9pS:$XM\u001d\t\u0005\u0005[\u0012\t(\u0004\u0002\u0003p)!\u0011QHAL\u0013\u0011\u0011\u0019Ha\u001c\u00039%\u0013VmY8sIB\u0013xnY3tg>\u00148\t[3dWB|\u0017N\u001c;fe\u0006\u0011\"/Z7pm\u0016\u001c\u0005.Z2la>Lg\u000e^3s)\u0019\t)H!\u001f\u0003|!1!\u0011I\u0016A\u0002}CqA!\u001b,\u0001\u0004\u0011Y'\u0001\nsK6,WNY3s\u0003\u0012$W\r\u001a*b]\u001e,G\u0003BA;\u0005\u0003CqAa!-\u0001\u0004\ty/A\u0003sC:<W-A\u000fgS:\fG.\u001b>f%\u0006tw-Z:G_J\u001cUO\u001d:f]R\u0014En\\2l)\u0011\t)H!#\t\u000f\t-U\u00061\u0001\u0003\f\u00059!\r\\8dW&#\u0017\u0001F:u_J,'\t\\8dW^KG\u000f\u001b*b]\u001e,7\u000f\u0006\u0004\u0002v\tE%1\u0013\u0005\b\u0005\u0017s\u0003\u0019\u0001B\u0006\u0011\u001d\u0011)J\fa\u0001\u0005/\u000b1\"\u0019:sCf\u0014UO\u001a4feB)\u0011\u0011]Av\u0011\n)r)\u001a8fe\u0006$X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u00148#B\u0018\u0003\u001e\n\r\u0006cA(\u0003 &\u0019!\u0011\u0015)\u0003\r\u0005s\u0017PU3g!\r\u0019%QU\u0005\u0004\u0005O#%A\u0006\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\u0015\u0005\t-\u0006c\u0001BW_5\t\u0001!A\u0005p]\u0006#G\rR1uCR1\u0011Q\u000fBZ\u0005oCaA!.2\u0001\u0004!\u0016\u0001\u00023bi\u0006DaA!/2\u0001\u0004!\u0016\u0001C7fi\u0006$\u0017\r^1\u0002\u001f=tw)\u001a8fe\u0006$XM\u00117pG.$B!!\u001e\u0003@\"9!1\u0012\u001aA\u0002\t-\u0011aC8o!V\u001c\bN\u00117pG.$b!!\u001e\u0003F\n\u001d\u0007b\u0002BFg\u0001\u0007!1\u0002\u0005\b\u0005+\u001b\u0004\u0019\u0001Bea\u0011\u0011YMa4\u0011\r\u0005\u0005\u00181\u001eBg!\rI%q\u001a\u0003\f\u0005#\u00149-!A\u0001\u0002\u000b\u0005QJA\u0002`IE\nqa\u001c8FeJ|'\u000f\u0006\u0004\u0002v\t]'1\u001c\u0005\u0007\u00053$\u0004\u0019A0\u0002\u000f5,7o]1hK\"9!Q\u001c\u001bA\u0002\t}\u0017!\u0003;ie><\u0018M\u00197f!\u0011\u0011\tOa;\u000f\t\t\r(q\u001d\b\u0004E\n\u0015\u0018\"A)\n\u0007\t%\b+A\u0004qC\u000e\\\u0017mZ3\n\t\t5(q\u001e\u0002\n)\"\u0014xn^1cY\u0016T1A!;Q\u0001")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final MetricsLevel metricsLevel;
    private final scala.collection.immutable.Set<String> metricsEnabledDimensions;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    private ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges() {
        return this.blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    private ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum() {
        return this.shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        KinesisClientLibConfiguration kinesisClientLibConfiguration;
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.workerId_$eq(new StringBuilder(1).append(Utils$.MODULE$.localHostName()).append(":").append(UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider kinesisProvider = this.kinesisCreds.provider();
        KinesisClientLibConfiguration baseClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), kinesisProvider, (AWSCredentialsProvider)this.dynamoDBCreds.map((Function1 & Serializable)x$1 -> x$1.provider()).getOrElse((Function0 & Serializable)() -> kinesisProvider), (AWSCredentialsProvider)this.cloudWatchCreds.map((Function1 & Serializable)x$2 -> x$2.provider()).getOrElse((Function0 & Serializable)() -> kinesisProvider), this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName).withMetricsLevel(this.metricsLevel).withMetricsEnabledDimensions((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.metricsEnabledDimensions).asJava());
        KinesisInitialPosition kinesisInitialPosition = this.initialPosition;
        if (kinesisInitialPosition instanceof KinesisInitialPositions.AtTimestamp) {
            KinesisInitialPositions.AtTimestamp atTimestamp = (KinesisInitialPositions.AtTimestamp)kinesisInitialPosition;
            kinesisClientLibConfiguration = baseClientLibConfiguration.withTimestampAtInitialPositionInStream(atTimestamp.getTimestamp());
        } else {
            kinesisClientLibConfiguration = baseClientLibConfiguration.withInitialPositionInStream(this.initialPosition.getPosition());
        }
        KinesisClientLibConfiguration kinesisClientLibConfiguration2 = kinesisClientLibConfiguration;
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration2));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.restart("Error running the KCL worker in Receiver", e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringBuilder(17).append("Kinesis Receiver ").append(this.streamId()).toString());
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Started receiver with workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
    }

    public void onStop() {
        block2: {
            if (this.workerThread() != null) {
                if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                    this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                    this.worker_$eq(null);
                }
                this.workerThread().join();
                this.workerThread_$eq(null);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Stopped receiver for workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
            }
            this.workerId_$eq(null);
            if (this.kinesisCheckpointer() == null) break block2;
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        block0: {
            if (records.size() <= 0) break block0;
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber(), records.size());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public int getCurrentLimit() {
        Predef$.MODULE$.assert(this.blockGenerator() != null);
        return (int)package$.MODULE$.min(this.blockGenerator().getCurrentLimit(), Integer.MAX_VALUE);
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Generated block ").append(blockId).append(" has ").append(this.blockIdToSeqNumRanges()).toString());
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        Option rangesToReportOption = Option$.MODULE$.apply((Object)this.blockIdToSeqNumRanges().remove(blockId));
        if (rangesToReportOption.isEmpty()) {
            this.stop(new StringBuilder(76).append("Error while storing block into Spark, could not find sequence number ranges ").append(new StringBuilder(10).append("for block ").append(blockId).toString()).toString());
            return;
        }
        SequenceNumberRanges rangesToReport = (SequenceNumberRanges)rangesToReportOption.get();
        int attempt = 0;
        boolean stored = false;
        Throwable throwable = null;
        while (!stored && attempt <= 3) {
            try {
                this.store(arrayBuffer, rangesToReport);
                stored = true;
            }
            catch (Throwable throwable2) {
                Option option;
                Throwable throwable3 = throwable2;
                if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    Throwable th = (Throwable)option.get();
                    ++attempt;
                    throwable = th;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable2;
            }
        }
        if (!stored) {
            this.stop("Error while storing block into Spark", throwable);
        }
        rangesToReport.ranges().foreach((Function1 & Serializable)range -> this.shardIdToLatestStoredSeqNum().put(range.shardId(), range.toSeqNumber()));
    }

    public KinesisReceiver(String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, MetricsLevel metricsLevel, scala.collection.immutable.Set<String> metricsEnabledDimensions) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.metricsLevel = metricsLevel;
        this.metricsEnabledDimensions = metricsEnabledDimensions;
        super(storageLevel);
        Logging.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    private class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

