/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.examples.streaming.StreamingExamples$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class KinesisWordProducerASL$ {
    public static final KinesisWordProducerASL$ MODULE$ = new KinesisWordProducerASL$();

    public void main(String[] args) {
        Object object;
        if (args.length != 4) {
            System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordProducerASL <stream-name> <endpoint-url> <records-per-sec>\n          |                              <words-per-record>\n          |\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n          |    <records-per-sec> is the rate of records per second to put onto the stream\n          |    <words-per-record> is the number of words per record\n          |\n        ")));
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 4) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String stream = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String endpoint = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String recordsPerSecond = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        String wordsPerRecord = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3);
        Tuple4 tuple4 = new Tuple4((Object)stream, (Object)endpoint, (Object)recordsPerSecond, (Object)wordsPerRecord);
        Tuple4 tuple42 = tuple4;
        String stream2 = (String)tuple42._1();
        String endpoint2 = (String)tuple42._2();
        String recordsPerSecond2 = (String)tuple42._3();
        String wordsPerRecord2 = (String)tuple42._4();
        Seq<Tuple2<String, Object>> totals = this.generate(stream2, endpoint2, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(recordsPerSecond2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(wordsPerRecord2)));
        Predef$.MODULE$.println((Object)"Totals for the words sent");
        totals.foreach((Function1 & Serializable)x$5 -> {
            Predef$.MODULE$.println((Object)x$5);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Tuple2<String, Object>> generate(String stream, String endpoint, int recordsPerSecond, int wordsPerRecord) {
        List randomWords = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark", "you", "are", "my", "father"}));
        Map totals = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpoint);
        Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(55).append("Putting records onto stream ").append(stream).append(" and endpoint ").append(endpoint).append(" at a rate of").toString()).append(new StringBuilder(42).append(" ").append(recordsPerSecond).append(" records per second and ").append(wordsPerRecord).append(" words per record").toString()).toString());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), recordsPerSecond).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)recordNum -> {
                String data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), wordsPerRecord).map((Function1 & Serializable)x -> KinesisWordProducerASL$.$anonfun$generate$3(randomWords, totals, BoxesRunTime.unboxToInt((Object)x))).mkString(" ");
                String partitionKey = new StringBuilder(13).append("partitionKey-").append(recordNum).toString();
                PutRecordRequest putRecordRequest = new PutRecordRequest().withStreamName(stream).withPartitionKey(partitionKey).withData(ByteBuffer.wrap(data.getBytes()));
                PutRecordResult putRecordResult = kinesisClient.putRecord(putRecordRequest);
            });
            BoxedUnit records = BoxedUnit.UNIT;
            Thread.sleep(1000L);
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("Sent ").append(recordsPerSecond).append(" records").toString());
        });
        return (Seq)totals.toSeq().sortBy((Function1 & Serializable)x$6 -> (String)x$6._1(), (Ordering)Ordering.String$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$3(List randomWords$1, Map totals$1, int x) {
        int randomWordIdx = Random$.MODULE$.nextInt(randomWords$1.size());
        String randomWord = (String)randomWords$1.apply(randomWordIdx);
        totals$1.update((Object)randomWord, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)totals$1.getOrElse((Object)randomWord, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
        return randomWord;
    }

    private KinesisWordProducerASL$() {
    }
}

