/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.protobuf.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.NoSuchFileException;
import org.apache.commons.io.FileUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.spark_protobuf.protobuf.AnyProto;
import org.sparkproject.spark_protobuf.protobuf.DescriptorProtos;
import org.sparkproject.spark_protobuf.protobuf.Descriptors;
import org.sparkproject.spark_protobuf.protobuf.InvalidProtocolBufferException;
import org.sparkproject.spark_protobuf.protobuf.Message;
import org.sparkproject.spark_protobuf.protobuf.TypeRegistry;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class ProtobufUtils$
implements Logging {
    public static final ProtobufUtils$ MODULE$ = new ProtobufUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Descriptors.Descriptor buildDescriptor(String messageName, Option<byte[]> binaryFileDescriptorSet) {
        Descriptors.Descriptor descriptor;
        Option<byte[]> option = binaryFileDescriptorSet;
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] bytes = (byte[])some.value();
            descriptor = this.buildDescriptor(bytes, messageName);
        } else if (None$.MODULE$.equals(option)) {
            descriptor = this.buildDescriptorFromJavaClass(messageName);
        } else {
            throw new MatchError(option);
        }
        return descriptor;
    }

    public Descriptors.Descriptor buildDescriptorFromJavaClass(String protobufClassName) {
        Method method;
        Class clazz;
        Class<Message> shadedMessageClass = Message.class;
        String missingShadingErrorMessage = new StringBuilder(49).append("The jar with Protobuf classes needs to be shaded ").append(new StringBuilder(30).append("(com.google.protobuf.* --> ").append(shadedMessageClass.getPackage().getName()).append(".*)").toString()).toString();
        try {
            clazz = Utils$.MODULE$.classForName(protobufClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        }
        catch (Throwable throwable) {
            NoClassDefFoundError noClassDefFoundError;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException) {
                ClassNotFoundException classNotFoundException = (ClassNotFoundException)throwable2;
                String explanation = protobufClassName.contains(".") ? "Ensure the class include in the jar" : "Ensure the class name includes package prefix";
                throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, explanation, (Throwable)classNotFoundException);
            }
            if (throwable2 instanceof NoClassDefFoundError && (noClassDefFoundError = (NoClassDefFoundError)throwable2).getMessage().matches("com/google/proto.*Generated.*")) {
                throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, missingShadingErrorMessage, (Throwable)noClassDefFoundError);
            }
            throw throwable;
        }
        Class protobufClass = clazz;
        if (!shadedMessageClass.isAssignableFrom(protobufClass)) {
            Class unshadedMessageClass = Utils$.MODULE$.classForName(String.join((CharSequence)".", "com", "google", "protobuf", "Message"), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            String explanation = unshadedMessageClass.isAssignableFrom(protobufClass) ? new StringBuilder(0).append(new StringBuilder(47).append(protobufClassName).append(" does not extend shaded Protobuf Message class ").toString()).append(new StringBuilder(2).append(shadedMessageClass.getName()).append(". ").append(missingShadingErrorMessage).toString()).toString() : new StringBuilder(31).append(protobufClassName).append(" is not a Protobuf Message type").toString();
            throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, explanation, QueryCompilationErrors$.MODULE$.protobufClassLoadError$default$3());
        }
        try {
            method = protobufClass.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (NoSuchMethodError e) {
            throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, "Could not find getDescriptor() method", (Throwable)e);
        }
        Method getDescriptorMethod = method;
        return (Descriptors.Descriptor)getDescriptorMethod.invoke(null, new Object[0]);
    }

    public Descriptors.Descriptor buildDescriptor(byte[] binaryFileDescriptorSet, String messageName) {
        Descriptors.Descriptor d;
        Option descriptorOpt = this.parseFileDescriptorSet(binaryFileDescriptorSet).flatMap((Function1 & Serializable)fileDesc -> ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileDesc.getMessageTypes()).asScala()).find((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)ProtobufUtils$.$anonfun$buildDescriptor$2(messageName, desc)))).headOption();
        Option option = descriptorOpt;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw QueryCompilationErrors$.MODULE$.unableToLocateProtobufMessageError(messageName);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Descriptors.Descriptor descriptor = d = (Descriptors.Descriptor)some.value();
        return descriptor;
    }

    public byte[] readDescriptorFileContent(String filePath) {
        byte[] byArray;
        try {
            byArray = FileUtils.readFileToByteArray((File)new File(filePath));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                throw QueryCompilationErrors$.MODULE$.cannotFindDescriptorFileError(filePath, (Throwable)fileNotFoundException);
            }
            if (throwable2 instanceof NoSuchFileException) {
                NoSuchFileException noSuchFileException = (NoSuchFileException)throwable2;
                throw QueryCompilationErrors$.MODULE$.cannotFindDescriptorFileError(filePath, (Throwable)noSuchFileException);
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable ex = (Throwable)option.get();
                throw QueryCompilationErrors$.MODULE$.descriptorParseError(ex);
            }
            throw throwable;
        }
        return byArray;
    }

    private List<Descriptors.FileDescriptor> parseFileDescriptorSet(byte[] bytes) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = null;
        try {
            fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw QueryCompilationErrors$.MODULE$.descriptorParseError((Throwable)ex);
        }
        Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoIndex = this.createDescriptorProtoMap(fileDescriptorSet);
        List fileDescriptorList = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileDescriptorSet.getFileList()).asScala()).map((Function1 & Serializable)fileDescriptorProto -> MODULE$.buildFileDescriptor((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, fileDescriptorProtoIndex))).toList();
        return fileDescriptorList;
    }

    private Descriptors.FileDescriptor buildFileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoMap) {
        Buffer fileDescriptorList = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)fileDescriptorProto.getDependencyList()).asScala()).map(arg_0 -> ProtobufUtils$.$anonfun$buildFileDescriptor$1(fileDescriptorProtoMap, arg_0));
        return Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptorList.toArray(ClassTag$.MODULE$.apply(Descriptors.FileDescriptor.class)));
    }

    private Map<String, DescriptorProtos.FileDescriptorProto> createDescriptorProtoMap(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileDescriptorSet.getFileList()).asScala()).map((Function1 & Serializable)descriptorProto -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)descriptorProto.getName()), descriptorProto))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String toFieldStr(Seq<String> names) {
        SeqOps seqOps;
        Seq<String> seq = names;
        String string = seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0 ? "top-level record" : new StringBuilder(8).append("field '").append(seq.mkString(".")).append("'").toString();
        return string;
    }

    public TypeRegistry buildTypeRegistry(byte[] descriptorBytes) {
        TypeRegistry.Builder registryBuilder = TypeRegistry.newBuilder();
        this.parseFileDescriptorSet(descriptorBytes).foreach((Function1 & Serializable)fileDesc -> registryBuilder.add(fileDesc.getMessageTypes()));
        return registryBuilder.build();
    }

    public TypeRegistry buildTypeRegistry(Descriptors.Descriptor descriptor) {
        return TypeRegistry.newBuilder().add(descriptor).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$buildDescriptor$2(String messageName$1, Descriptors.Descriptor desc) {
        String string = desc.getName();
        String string2 = messageName$1;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = desc.getFullName();
        String string4 = messageName$1;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Descriptors.FileDescriptor $anonfun$buildFileDescriptor$1(Map fileDescriptorProtoMap$1, String dependency) {
        block4: {
            block3: {
                var3_2 = fileDescriptorProtoMap$1.get((Object)dependency);
                if (!(var3_2 instanceof Some)) break block3;
                var4_3 = (Some)var3_2;
                dependencyProto = (DescriptorProtos.FileDescriptorProto)var4_3.value();
                v0 = dependencyProto.getName();
                var6_5 = "google/protobuf/any.proto";
                if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                v1 = dependencyProto.getPackage();
                var7_6 = "google.protobuf";
                if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
                    v2 = AnyProto.getDescriptor();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = ProtobufUtils$.MODULE$.buildFileDescriptor(dependencyProto, (Map<String, DescriptorProtos.FileDescriptorProto>)fileDescriptorProtoMap$1);
                }
                break block4;
            }
            if (None$.MODULE$.equals(var3_2)) {
                throw QueryCompilationErrors$.MODULE$.protobufDescriptorDependencyError(dependency);
            }
            throw new MatchError((Object)var3_2);
        }
        var2_7 = v2;
        return var2_7;
    }

    private ProtobufUtils$() {
    }
}

