/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!\u0002\r\u001a\u0001})\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019Q\u0006\u0001)A\u0005!\"91\f\u0001b\u0001\n\u0013a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\rM\u0004\u0001\u0015!\u0003i\u0011)!\b\u0001%A\u0001\u0004\u0003\u0006I!\u001e\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bA\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\t\u000f\u0005M\u0001\u0001)Q\u0005q\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037Aq!a\b\u0001A\u0003&a\u0010C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005E\u0002\u0001\"\u0003\u00020!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0002\"\u001b\u0016\u001cxn\u001d%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d\u0006\u00035m\tQ!\\3t_NT!\u0001H\u000f\u0002\u000f\rdWo\u001d;fe*\u0011adH\u0001\ng\u000eDW\rZ;mKJT!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.a5\taF\u0003\u00020?\u0005A\u0011N\u001c;fe:\fG.\u0003\u00022]\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u00026m5\tq$\u0003\u00028?\tI1\u000b]1sW\u000e{gNZ\u0001\rQ\u0006$wn\u001c9D_:4\u0017n\u001a\t\u0003uyj\u0011a\u000f\u0006\u0003eqR!!P\u0011\u0002\r!\fGm\\8q\u0013\ty4HA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u!\t\u0011U)D\u0001D\u0015\t!u$A\u0002sa\u000eL!AR\"\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u00061A(\u001b8jiz\"B!S&M\u001bB\u0011!\nA\u0007\u00023!)!\u0007\u0002a\u0001i!)\u0001\b\u0002a\u0001s!)\u0001\t\u0002a\u0001\u0003\u000692M]3eK:$\u0018.\u00197SK:,w/\u001a:UQJ,\u0017\rZ\u000b\u0002!B\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011L\u0015\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001G2sK\u0012,g\u000e^5bYJ+g.Z<feRC'/Z1eA\u0005aAo\\6f]6\u000bg.Y4feV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006A1/Z2ve&$\u0018P\u0003\u0002c?\u00051A-\u001a9m_fL!\u0001Z0\u00039!\u000bGm\\8q\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe\u0006iAo\\6f]6\u000bg.Y4fe\u0002\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6)\u001b\u0005a'BA74\u0003\u0019a$o\\8u}%\u0011q\u000eK\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pQ\u0005Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u0007a$\u0013\u0007\u0005\u0003(mbt\u0018BA<)\u0005\u0019!V\u000f\u001d7feA\u0019q%_>\n\u0005iD#!B!se\u0006L\bCA\u0014}\u0013\ti\bF\u0001\u0003CsR,\u0007CA\u0014\u0000\u0013\r\t\t\u0001\u000b\u0002\u0005\u0019>tw-\u0001\u0004u_.,gn]\u000b\u0002q\u0006QAo\\6f]N|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004O\u00055\u0011bAA\bQ\t!QK\\5u\u0011\u001d!X\"!AA\u0002a\fq\u0001^8lK:\u001c\b%A\tuS6,wJ\u001a(fqR\u0014VM\\3xC2,\u0012A`\u0001\u0016i&lWm\u00144OKb$(+\u001a8fo\u0006dw\fJ3r)\u0011\tY!!\b\t\u000fQ\u0004\u0012\u0011!a\u0001}\u0006\u0011B/[7f\u001f\u001atU\r\u001f;SK:,w/\u00197!\u0003)YW-\u001f;bE\u001aKG.Z\u000b\u0003\u0003K\u0001BaJA\u0014Q&\u0019\u0011\u0011\u0006\u0015\u0003\r=\u0003H/[8o\u0003-YW-\u001f;bE\u001aKG.\u001a\u0011\u0002)M\u001c\u0007.\u001a3vY\u0016$vn[3o%\u0016tWm^1m)\t\tY!\u0001\fhKRtUm\u001e#fY\u0016<\u0017\r^5p]R{7.\u001a8t\u0003e\u0011'o\\1eG\u0006\u001cH\u000fR3mK\u001e\fG/[8o)>\\WM\\:\u0015\t\u0005-\u0011q\u0007\u0005\u0007\u0003\u00071\u0002\u0019\u0001=\u0002\u0013\u001d,G\u000fV8lK:\u001cH#\u0001=")
public class MesosHadoopDelegationTokenManager
implements Logging {
    public final SparkConf org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf;
    private final RpcEndpointRef driverEndpoint;
    private final ScheduledExecutorService org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread;
    private final HadoopDelegationTokenManager org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager;
    private final String principal;
    private final /* synthetic */ Tuple2 x$1;
    private byte[] org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens;
    private long timeOfNextRenewal;
    private final Option<String> keytabFile;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ScheduledExecutorService org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread;
    }

    public HadoopDelegationTokenManager org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager;
    }

    private String principal() {
        return this.principal;
    }

    public byte[] org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens;
    }

    private void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens_$eq(byte[] x$1) {
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens = x$1;
    }

    private long timeOfNextRenewal() {
        return this.timeOfNextRenewal;
    }

    private void timeOfNextRenewal_$eq(long x$1) {
        this.timeOfNextRenewal = x$1;
    }

    private Option<String> keytabFile() {
        return this.keytabFile;
    }

    private void scheduleTokenRenewal() {
        if (!this.keytabFile().isDefined()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using ticket cache for Kerberos authentication, no token renewal.");
            return;
        }
        Predef$.MODULE$.require(this.principal() != null, (Function0 & Serializable & scala.Serializable)() -> "Principal is required for Keytab-based authentication");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Using keytab: ").append(this.keytabFile().get()).append(" and principal ").append(this.principal()).toString());
        Runnable credentialRenewerRunnable = new Runnable(this){
            private final /* synthetic */ MesosHadoopDelegationTokenManager $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$getNewDelegationTokens();
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$broadcastDelegationTokens(this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens());
                }
                catch (Exception e) {
                    long delay = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf.get(package$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Couldn't broadcast tokens, trying again in ").append(UIUtils$.MODULE$.formatDuration(delay)).toString(), e);
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread().schedule(this, delay, TimeUnit.MILLISECONDS);
                    return;
                }
                this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(this);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(long )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(credentialRenewerRunnable);
    }

    public void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$getNewDelegationTokens() {
        long l;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Attempting to login to KDC with principal ").append(this.principal()).toString());
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal(), (String)((String)this.keytabFile().get()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Successfully logged into KDC");
        Credentials tempCreds = ugi.getCredentials();
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
        long nextRenewalTime = BoxesRunTime.unboxToLong((Object)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(this, hadoopConf, tempCreds){
            private final /* synthetic */ MesosHadoopDelegationTokenManager $outer;
            private final Configuration hadoopConf$1;
            private final Credentials tempCreds$1;

            public long run() {
                return this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager().obtainDelegationTokens(this.hadoopConf$1, this.tempCreds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hadoopConf$1 = hadoopConf$1;
                this.tempCreds$1 = tempCreds$1;
            }
        }));
        long currTime = System.currentTimeMillis();
        if (nextRenewalTime <= currTime) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Next credential renewal time (").append(nextRenewalTime).append(") is earlier than ").append(new StringBuilder(75).append("current time (").append(currTime).append("), which is unexpected, please check your credential renewal ").toString()).append("related configurations in the target services.").toString());
            l = currTime;
        } else {
            l = SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(nextRenewalTime, this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
        }
        this.timeOfNextRenewal_$eq(l);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Time of next renewal is in ").append(this.timeOfNextRenewal() - System.currentTimeMillis()).append(" ms").toString());
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens_$eq(SparkHadoopUtil$.MODULE$.get().serialize(tempCreds));
    }

    public void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$broadcastDelegationTokens(byte[] tokens) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sending new tokens to all executors");
        this.driverEndpoint.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
    }

    public byte[] getTokens() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens();
    }

    private final Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            Credentials creds = UserGroupInformation.getCurrentUser().getCredentials();
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
            long rt = this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager().obtainDelegationTokens(hadoopConf, creds);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Initialized tokens: ").append(SparkHadoopUtil$.MODULE$.get().dumpTokens(creds)).toString());
            tuple2 = new Tuple2((Object)SparkHadoopUtil$.MODULE$.get().serialize(creds), (Object)BoxesRunTime.boxToLong((long)SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(rt, this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf)));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to fetch Hadoop delegation tokens ").append(e).toString());
            throw e;
        }
        return tuple2;
    }

    public final void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(Runnable runnable) {
        long remainingTime = this.timeOfNextRenewal() - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Credentials have expired, creating new ones now.");
            runnable.run();
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Scheduling login from keytab in ").append(remainingTime).append(" millis.").toString());
            this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread().schedule(runnable, remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public MesosHadoopDelegationTokenManager(SparkConf conf, Configuration hadoopConfig, RpcEndpointRef driverEndpoint) {
        long timeOfNextRenewal;
        byte[] tokens;
        block3: {
            Tuple2 tuple2;
            block2: {
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf = conf;
                this.driverEndpoint = driverEndpoint;
                Logging.$init$((Logging)this);
                Predef$.MODULE$.require(driverEndpoint != null, (Function0 & Serializable & scala.Serializable)() -> "DriverEndpoint is not initialized");
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Renewal Thread");
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager = new HadoopDelegationTokenManager(conf, hadoopConfig);
                this.principal = (String)((Option)conf.get((ConfigEntry)package$.MODULE$.PRINCIPAL())).orNull(Predef$.MODULE$.$conforms());
                tuple2 = this.liftedTree1$1();
                if (tuple2 == null) break block2;
                tokens = (byte[])tuple2._1();
                timeOfNextRenewal = tuple2._2$mcJ$sp();
                if (tokens != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        byte[] byArray = tokens;
        long l = timeOfNextRenewal;
        Tuple2 tuple2 = new Tuple2((Object)byArray, (Object)BoxesRunTime.boxToLong((long)l));
        this.x$1 = tuple2;
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens = (byte[])this.x$1._1();
        this.timeOfNextRenewal = this.x$1._2$mcJ$sp();
        this.keytabFile = (Option)conf.get((ConfigEntry)package$.MODULE$.KEYTAB());
        this.scheduleTokenRenewal();
    }
}

