/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngine;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001!q!A\n.p_.,W\r]3s\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oK*\u00111\u0001B\u0001\u0006[\u0016\u001cxn\u001d\u0006\u0003\u000b\u0019\tqa\u00197vgR,'O\u0003\u0002\b\u0011\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON!\u0001aD\u000b\u001a!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u001e\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oKB\u0011!$H\u0007\u00027)\u0011A\u0004C\u0001\tS:$XM\u001d8bY&\u0011ad\u0007\u0002\b\u0019><w-\u001b8h\u0011!\u0001\u0003A!A!\u0002\u0013\u0011\u0013a\u00022bg\u0016$\u0015N]\u0002\u0001!\t\u0019#F\u0004\u0002%QA\u0011Q%E\u0007\u0002M)\u0011q%I\u0001\u0007yI|w\u000e\u001e \n\u0005%\n\u0012A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!K\t\t\u00119\u0002!\u0011!Q\u0001\n=\n!A_6\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!\u00034sC6,wo\u001c:l\u0015\t!$\"A\u0004dkJ\fGo\u001c:\n\u0005Y\n$\u0001E\"ve\u0006$xN\u001d$sC6,wo\u001c:l\u0011!A\u0004A!A!\u0002\u0013I\u0014\u0001B2p]\u001a\u0004\"AO\u001e\u000e\u0003!I!\u0001\u0010\u0005\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002 \u0001\t\u0003y\u0014A\u0002\u001fj]&$h\b\u0006\u0003A\u0003\n\u001b\u0005C\u0001\f\u0001\u0011\u0015\u0001S\b1\u0001#\u0011\u0015qS\b1\u00010\u0011\u0015AT\b1\u0001:\u0011\u001d)\u0005A1A\u0005\n\u0019\u000b1bV(S\u0017&sui\u0018#J%V\tq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!aK%\t\r=\u0003\u0001\u0015!\u0003H\u000319vJU&J\u001d\u001e{F)\u0013*!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005\t\u001a\u0006\"\u0002+Q\u0001\u0004\u0011\u0013\u0001\u00028b[\u0016DQA\u0016\u0001\u0005B]\u000bq!\u001a=qk:<W\r\u0006\u0002Y7B\u0011\u0001#W\u0005\u00035F\u0011A!\u00168ji\")A+\u0016a\u0001E!)Q\f\u0001C!=\u00069\u0001/\u001a:tSN$Hc\u0001-`A\")A\u000b\u0018a\u0001E!)\u0011\r\u0018a\u0001E\u0006\u0019qN\u00196\u0011\u0005!\u001b\u0017B\u00013J\u0005\u0019y%M[3di\")a\r\u0001C!O\u0006)a-\u001a;dQV\u0011\u0001N\u001c\u000b\u0003S^\u00042\u0001\u00056m\u0013\tY\u0017C\u0001\u0004PaRLwN\u001c\t\u0003[:d\u0001\u0001B\u0003pK\n\u0007\u0001OA\u0001U#\t\tH\u000f\u0005\u0002\u0011e&\u00111/\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001R/\u0003\u0002w#\t\u0019\u0011I\\=\t\u000bQ+\u0007\u0019\u0001\u0012\t\u000be\u0004A\u0011\t>\u0002\u0011\u0019,Go\u00195BY2,2a_A\u0007)\u0005a\b#B?\u0002\u0006\u0005-ab\u0001@\u0002\u00029\u0011Qe`\u0005\u0002%%\u0019\u00111A\t\u0002\u000fA\f7m[1hK&!\u0011qAA\u0005\u0005!IE/\u001a:bE2,'bAA\u0002#A\u0019Q.!\u0004\u0005\u000b=D(\u0019\u00019")
public class ZookeeperMesosClusterPersistenceEngine
implements MesosClusterPersistenceEngine,
Logging {
    private final CuratorFramework zk;
    private final String WORKING_DIR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    public String path(String name) {
        return new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString();
    }

    @Override
    public void expunge(String name) {
        this.zk.delete().forPath(this.path(name));
    }

    @Override
    public void persist(String name, Object obj) {
        byte[] serialized = Utils$.MODULE$.serialize(obj);
        String zkPath = this.path(name);
        ((PathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).forPath(zkPath, serialized);
    }

    @Override
    public <T> Option<T> fetch(String name) {
        None$ none$;
        String zkPath = this.path(name);
        try {
            byte[] fileData = (byte[])this.zk.getData().forPath(zkPath);
            none$ = new Some(Utils$.MODULE$.deserialize(fileData));
        }
        catch (KeeperException.NoNodeException e) {
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while reading persisted file, deleting", e);
            this.zk.delete().forPath(zkPath);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public <T> Iterable<T> fetchAll() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk.getChildren().forPath(this.WORKING_DIR())).asScala()).flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.option2Iterable(this.fetch((String)name)), Buffer$.MODULE$.canBuildFrom());
    }

    public ZookeeperMesosClusterPersistenceEngine(String baseDir, CuratorFramework zk, SparkConf conf) {
        this.zk = zk;
        Logging.$init$((Logging)this);
        this.WORKING_DIR = new StringBuilder(1).append(conf.get("spark.deploy.zookeeper.dir", "/spark_mesos_dispatcher")).append("/").append(baseDir).toString();
        SparkCuratorUtil$.MODULE$.mkdir(zk, this.WORKING_DIR());
    }
}

