/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest.mesos;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.mesos.MesosDriverDescription;
import org.apache.spark.deploy.mesos.MesosDriverDescription$;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.SubmitRequestServlet;
import org.apache.spark.deploy.rest.SubmitRestMissingFieldException;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.package$;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterScheduler;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u0001\u0003\u0001\tq!!G'fg>\u001c8+\u001e2nSR\u0014V-];fgR\u001cVM\u001d<mKRT!a\u0001\u0003\u0002\u000b5,7o\\:\u000b\u0005\u00151\u0011\u0001\u0002:fgRT!a\u0002\u0005\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\u0005\u0013\t\u0011BA\u0001\u000bTk\nl\u0017\u000e\u001e*fcV,7\u000f^*feZdW\r\u001e\u0005\t)\u0001\u0011\t\u0011)A\u0005-\u0005I1o\u00195fIVdWM]\u0002\u0001!\t9B$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u001b7\u000591\r\\;ti\u0016\u0014(B\u0001\u000b\t\u0013\ti\u0002DA\u000bNKN|7o\u00117vgR,'oU2iK\u0012,H.\u001a:\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nAaY8oMB\u0011\u0011EI\u0007\u0002\u0011%\u00111\u0005\u0003\u0002\n'B\f'o[\"p]\u001aDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDcA\u0014*UA\u0011\u0001\u0006A\u0007\u0002\u0005!)A\u0003\na\u0001-!)q\u0004\na\u0001A!9A\u0006\u0001b\u0001\n\u0013i\u0013!\u0005#F\r\u0006+F\nV0T+B+%KV%T\u000bV\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0004C_>dW-\u00198\t\rU\u0002\u0001\u0015!\u0003/\u0003I!UIR!V\u0019R{6+\u0016)F%ZK5+\u0012\u0011\t\u000f]\u0002!\u0019!C\u0005q\u0005qA)\u0012$B+2#v,T#N\u001fJKV#A\u001d\u0011\u0005=R\u0014BA\u001e1\u0005\rIe\u000e\u001e\u0005\u0007{\u0001\u0001\u000b\u0011B\u001d\u0002\u001f\u0011+e)Q+M)~kU)T(S3\u0002Bqa\u0010\u0001C\u0002\u0013%\u0001)A\u0007E\u000b\u001a\u000bU\u000b\u0014+`\u0007>\u0013ViU\u000b\u0002\u0003B\u0011qFQ\u0005\u0003\u0007B\u0012a\u0001R8vE2,\u0007BB#\u0001A\u0003%\u0011)\u0001\bE\u000b\u001a\u000bU\u000b\u0014+`\u0007>\u0013Vi\u0015\u0011\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u0006\u0001b.\u001a=u\tJLg/\u001a:Ok6\u0014WM]\u000b\u0002\u0013B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\u0007CR|W.[2\u000b\u00059{\u0015AC2p]\u000e,(O]3oi*\u0011\u0001+U\u0001\u0005kRLGNC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q[%AC!u_6L7\rT8oO\"1a\u000b\u0001Q\u0001\n%\u000b\u0011C\\3yi\u0012\u0013\u0018N^3s\u001dVl'-\u001a:!\u0011\u0015A\u0006\u0001\"\u0003Z\u0003A\u0019'/Z1uK\u0012\u000bG/\u001a$pe6\fG/F\u0001[!\tYf,D\u0001]\u0015\ti\u0016+\u0001\u0003uKb$\u0018BA0]\u0005A\u0019\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG\u000fC\u0003b\u0001\u0011%!-A\u0006oK^$%/\u001b<fe&#GCA2o!\t!7N\u0004\u0002fSB\u0011a\rM\u0007\u0002O*\u0011\u0001.F\u0001\u0007yI|w\u000e\u001e \n\u0005)\u0004\u0014A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\u0019\t\u000b=\u0004\u0007\u0019\u00019\u0002\u0015M,(-\\5u\t\u0006$X\r\u0005\u0002re6\tq*\u0003\u0002t\u001f\n!A)\u0019;f\u0011\u0015)\b\u0001\"\u0003w\u0003Y\u0011W/\u001b7e\tJLg/\u001a:EKN\u001c'/\u001b9uS>tGCA<}!\tA(0D\u0001z\u0015\t\u0019a!\u0003\u0002|s\n1R*Z:pg\u0012\u0013\u0018N^3s\t\u0016\u001c8M]5qi&|g\u000eC\u0003~i\u0002\u0007a0A\u0004sKF,Xm\u001d;\u0011\u0005Ay\u0018bAA\u0001\t\t92I]3bi\u0016\u001cVOY7jgNLwN\u001c*fcV,7\u000f\u001e\u0005\b\u0003\u000b\u0001A\u0011KA\u0004\u00031A\u0017M\u001c3mKN+(-\\5u)!\tI!a\u0004\u0002\u0014\u0005u\u0001c\u0001\t\u0002\f%\u0019\u0011Q\u0002\u0003\u00035M+(-\\5u%\u0016\u001cH\u000f\u0015:pi>\u001cw\u000e\u001c*fgB|gn]3\t\u000f\u0005E\u00111\u0001a\u0001G\u0006\u0011\"/Z9vKN$X*Z:tC\u001e,'j]8o\u0011!\t)\"a\u0001A\u0002\u0005]\u0011A\u0004:fcV,7\u000f^'fgN\fw-\u001a\t\u0004!\u0005e\u0011bAA\u000e\t\tI2+\u001e2nSR\u0014Vm\u001d;Qe>$xnY8m\u001b\u0016\u001c8/Y4f\u0011!\ty\"a\u0001A\u0002\u0005\u0005\u0012a\u0004:fgB|gn]3TKJ4H.\u001a;\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005!\u0001\u000e\u001e;q\u0015\u0011\tY#!\f\u0002\u000fM,'O\u001e7fi*\u0011\u0011qF\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003g\t)CA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX\r")
public class MesosSubmitRequestServlet
extends SubmitRequestServlet {
    private final MesosClusterScheduler scheduler;
    private final boolean DEFAULT_SUPERVISE;
    private final int DEFAULT_MEMORY;
    private final double DEFAULT_CORES;
    private final AtomicLong nextDriverNumber;

    private boolean DEFAULT_SUPERVISE() {
        return this.DEFAULT_SUPERVISE;
    }

    private int DEFAULT_MEMORY() {
        return this.DEFAULT_MEMORY;
    }

    private double DEFAULT_CORES() {
        return this.DEFAULT_CORES;
    }

    private AtomicLong nextDriverNumber() {
        return this.nextDriverNumber;
    }

    private SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    }

    private String newDriverId(Date submitDate) {
        String arg$macro$1 = this.createDateFormat().format(submitDate);
        long arg$macro$2 = this.nextDriverNumber().incrementAndGet();
        return new StringOps("driver-%s-%04d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToLong((long)arg$macro$2)}));
    }

    private MesosDriverDescription buildDriverDescription(CreateSubmissionRequest request) {
        String appResource = (String)Option$.MODULE$.apply((Object)request.appResource()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application jar 'appResource' is missing.");
        });
        String mainClass = (String)Option$.MODULE$.apply((Object)request.mainClass()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Main class 'mainClass' is missing.");
        });
        String[] appArgs = (String[])Option$.MODULE$.apply((Object)request.appArgs()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application arguments 'appArgs' are missing.");
        });
        scala.collection.immutable.Map environmentVariables = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)request.environmentVariables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Environment variables 'environmentVariables' are missing.");
        });
        scala.collection.immutable.Map sparkProperties = request.sparkProperties();
        Option driverExtraJavaOptions = sparkProperties.get((Object)"spark.driver.extraJavaOptions");
        Option driverExtraClassPath = sparkProperties.get((Object)"spark.driver.extraClassPath");
        Option driverExtraLibraryPath = sparkProperties.get((Object)"spark.driver.extraLibraryPath");
        Option superviseDriver = sparkProperties.get((Object)"spark.driver.supervise");
        Option driverMemory = sparkProperties.get((Object)"spark.driver.memory");
        Option driverCores = sparkProperties.get((Object)"spark.driver.cores");
        String name = (String)request.sparkProperties().getOrElse((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> mainClass);
        SparkConf conf = new SparkConf(false).setAll((Traversable)sparkProperties);
        Seq extraClassPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraClassPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq extraLibraryPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraLibraryPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq extraJavaOpts = (Seq)driverExtraJavaOptions.map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString(s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, Utils$.MODULE$.sparkJavaOpts$default$2());
        Seq javaOpts = (Seq)sparkJavaOpts.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command(mainClass, (Seq)Predef$.MODULE$.wrapRefArray((Object[])appArgs), (Map)environmentVariables, extraClassPath, extraLibraryPath, javaOpts);
        boolean actualSuperviseDriver = BoxesRunTime.unboxToBoolean((Object)superviseDriver.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$10(x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.DEFAULT_SUPERVISE()));
        int actualDriverMemory = BoxesRunTime.unboxToInt((Object)driverMemory.map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)Utils$.MODULE$.memoryStringToMb(str))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.DEFAULT_MEMORY()));
        double actualDriverCores = BoxesRunTime.unboxToDouble((Object)driverCores.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$14(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.DEFAULT_CORES()));
        Date submitDate = new Date();
        String submissionId = this.newDriverId(submitDate);
        return new MesosDriverDescription(name, appResource, actualDriverMemory, actualDriverCores, actualSuperviseDriver, command, (scala.collection.immutable.Map<String, String>)request.sparkProperties(), submissionId, submitDate, MesosDriverDescription$.MODULE$.$lessinit$greater$default$10());
    }

    public SubmitRestProtocolResponse handleSubmit(String requestMessageJson, SubmitRestProtocolMessage requestMessage, HttpServletResponse responseServlet) {
        ErrorResponse errorResponse;
        SubmitRestProtocolMessage submitRestProtocolMessage = requestMessage;
        if (submitRestProtocolMessage instanceof CreateSubmissionRequest) {
            CreateSubmissionRequest createSubmissionRequest = (CreateSubmissionRequest)submitRestProtocolMessage;
            MesosDriverDescription driverDescription = this.buildDriverDescription(createSubmissionRequest);
            CreateSubmissionResponse s = this.scheduler.submitDriver(driverDescription);
            s.serverSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
            String[] unknownFields = this.findUnknownFields(requestMessageJson, requestMessage);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unknownFields)).nonEmpty()) {
                s.unknownFields_$eq(unknownFields);
            }
            errorResponse = s;
        } else {
            responseServlet.setStatus(400);
            errorResponse = this.handleError(new StringBuilder(37).append("Received message of unexpected type ").append(submitRestProtocolMessage.messageType()).append(".").toString());
        }
        return errorResponse;
    }

    public static final /* synthetic */ boolean $anonfun$buildDriverDescription$10(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ double $anonfun$buildDriverDescription$14(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toDouble();
    }

    public MesosSubmitRequestServlet(MesosClusterScheduler scheduler, SparkConf conf) {
        this.scheduler = scheduler;
        this.DEFAULT_SUPERVISE = false;
        this.DEFAULT_MEMORY = Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB();
        this.DEFAULT_CORES = 1.0;
        this.nextDriverNumber = new AtomicLong(0L);
    }
}

