/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.FileExistsException;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.shuffle.ShuffleChecksumUtils$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class KubernetesLocalDiskShuffleExecutorComponents$
implements Logging {
    public static final KubernetesLocalDiskShuffleExecutorComponents$ MODULE$ = new KubernetesLocalDiskShuffleExecutorComponents$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void recoverDiskStore(SparkConf conf, BlockManager bm) {
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf)), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$1(x$2)))), (Function1 & Serializable)s -> new File(new File(new File((String)s).getParent()).getParent()), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)dir -> {
            File[] oldDirs = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$4(f)));
            File[] files = (File[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])oldDirs), (Function1 & Serializable)x$3 -> x$3.listFiles(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()))), (Function1 & Serializable)x$5 -> x$5.listFiles(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDirectory()))), (Function1 & Serializable)x$7 -> x$7.listFiles(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDirectory()))), (Function1 & Serializable)x$9 -> x$9.listFiles(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class));
            if (files != null) {
                return ArrayImplicits$.MODULE$.SparkArrayOps((Object)files).toImmutableArraySeq();
            }
            return (Seq)package$.MODULE$.Seq().empty();
        }, ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$16(x$10)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] checksumFiles = (File[])tuple2._1();
        File[] files = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)checksumFiles, (Object)files);
        File[] checksumFiles2 = (File[])tuple22._1();
        File[] files2 = (File[])tuple22._2();
        Tuple2 tuple23 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])files2), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$17(x$12)));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        File[] indexFiles = (File[])tuple23._1();
        File[] dataFiles = (File[])tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)indexFiles, (Object)dataFiles);
        File[] indexFiles2 = (File[])tuple24._1();
        File[] dataFiles2 = (File[])tuple24._2();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " data files, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_DATA_FILE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)dataFiles2.length))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " index files, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_INDEX_FILE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)indexFiles2.length))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " checksum files."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_CHECKSUM_FILE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)checksumFiles2.length))})))));
        HashMap checksumFileMap = new HashMap();
        String algorithm = (String)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])checksumFiles2), (Function1 & Serializable)f -> {
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)f.getName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_ABSOLUTE_PATH$.MODULE$, (Object)f.getAbsolutePath())})))));
            return checksumFileMap.put((Object)f.getName(), f);
        });
        HashMap indexFileMap = new HashMap();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])indexFiles2), (Function1 & Serializable)f -> {
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)f.getName().replace(".index", ".data"))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_ABSOLUTE_PATH$.MODULE$, (Object)f.getAbsolutePath())})))));
            return indexFileMap.put((Object)f.getName().replace(".index", ".data"), f);
        });
        ClassTag classTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.Object());
        StorageLevel level = StorageLevel$.MODULE$.DISK_ONLY();
        boolean checksumDisabled = !BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ENABLED()));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])dataFiles2), (Object)indexFiles2, ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)f -> {
            Object object;
            block6: {
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Try to recover ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_ABSOLUTE_PATH$.MODULE$, (Object)f.getAbsolutePath())}))));
                try {
                    BlockId id = BlockId$.MODULE$.apply(f.getName());
                    if (id.isShuffle()) {
                        boolean skipVerification = checksumDisabled || f.getName().endsWith(".index");
                        File checksumFile = (File)checksumFileMap.getOrElse((Object)ShuffleChecksumUtils$.MODULE$.getChecksumFileName(id, algorithm), (Function0 & Serializable)() -> null);
                        File indexFile = (File)indexFileMap.getOrElse((Object)f.getName(), (Function0 & Serializable)() -> null);
                        if (skipVerification || MODULE$.verifyChecksum(algorithm, id, checksumFile, indexFile, (File)f)) {
                            long decryptedSize = f.length();
                            object = BoxesRunTime.boxToBoolean((boolean)new BlockManager.TempFileBasedBlockStoreUpdater(bm, id, level, classTag, f, decryptedSize, bm.TempFileBasedBlockStoreUpdater().apply$default$6(), bm.TempFileBasedBlockStoreUpdater().apply$default$7()).save());
                        } else {
                            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_ABSOLUTE_PATH$.MODULE$, (Object)f.getAbsolutePath())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"due to the verification failure."}))).log((Seq)Nil$.MODULE$))));
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Ignore a non-shuffle block file.");
                    object = BoxedUnit.UNIT;
                }
                catch (UnrecognizedBlockId unrecognizedBlockId) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Skip due to UnrecognizedBlockId.");
                    object = BoxedUnit.UNIT;
                }
                catch (FileExistsException fileExistsException) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Ignore due to FileExistsException.");
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
    }

    public boolean verifyChecksum(String algorithm, BlockId blockId, File checksumFile, File indexFile, File dataFile) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleDataBlockId) {
            if (dataFile == null || !dataFile.exists()) {
                return false;
            }
            if (checksumFile == null || !checksumFile.exists()) {
                return true;
            }
            if (checksumFile.length() == 0L || checksumFile.length() % 8L != 0L) {
                return false;
            }
            if (indexFile == null || !indexFile.exists()) {
                return false;
            }
            if (indexFile.length() == 0L) {
                return false;
            }
            int numPartition = (int)(checksumFile.length() / 8L);
            return ShuffleChecksumUtils$.MODULE$.compareChecksums(numPartition, algorithm, checksumFile, dataFile, indexFile);
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$1(String x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$4(File f) {
        return f.isDirectory() && f.getName().startsWith("spark-");
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$16(File x$10) {
        return x$10.getName().contains(".checksum");
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$17(File x$12) {
        return x$12.getName().endsWith(".index");
    }

    private KubernetesLocalDiskShuffleExecutorComponents$() {
    }
}

