/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileExistsException;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KubernetesLocalDiskShuffleExecutorComponents$
implements Logging {
    public static KubernetesLocalDiskShuffleExecutorComponents$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KubernetesLocalDiskShuffleExecutorComponents$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void recoverDiskStore(SparkConf conf, BlockManager bm) {
        File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$1(x$1))))).map((Function1 & Serializable & scala.Serializable)s -> new File(new File(new File((String)s).getParent()).getParent()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File[] oldDirs = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$4(f)));
            File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldDirs)).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.listFiles())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory())))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4.listFiles())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDirectory())))).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.listFiles())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDirectory())))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8.listFiles())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$12(x$9)));
            if (files != null) {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toSeq();
            }
            return (Seq)Nil$.MODULE$;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Found ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).size()).append(" files").toString());
        ClassTag classTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.Object());
        StorageLevel level = StorageLevel$.MODULE$.DISK_ONLY();
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).partition((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KubernetesLocalDiskShuffleExecutorComponents$.$anonfun$recoverDiskStore$14(x$10)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] indexFiles = (File[])tuple2._1();
        File[] dataFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexFiles, (Object)dataFiles);
        File[] indexFiles2 = (File[])tuple22._1();
        File[] dataFiles2 = (File[])tuple22._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFiles2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            Object object;
            block4: {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Try to recover ").append(f.getAbsolutePath()).toString());
                try {
                    BlockId id = BlockId$.MODULE$.apply(f.getName());
                    if (id.isShuffle()) {
                        long decryptedSize = f.length();
                        object = BoxesRunTime.boxToBoolean((boolean)new BlockManager.TempFileBasedBlockStoreUpdater(bm, id, level, classTag, f, decryptedSize, bm.TempFileBasedBlockStoreUpdater().apply$default$6(), bm.TempFileBasedBlockStoreUpdater().apply$default$7()).save());
                        break block4;
                    }
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignore a non-shuffle block file.");
                    object = BoxedUnit.UNIT;
                }
                catch (UnrecognizedBlockId unrecognizedBlockId) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skip due to UnrecognizedBlockId.");
                    object = BoxedUnit.UNIT;
                }
                catch (FileExistsException fileExistsException) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignore due to FileExistsException.");
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$1(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$4(File f) {
        return f.isDirectory() && f.getName().startsWith("spark-");
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$12(File x$9) {
        return x$9.getName().contains(".checksum");
    }

    public static final /* synthetic */ boolean $anonfun$recoverDiskStore$14(File x$10) {
        return x$10.getName().endsWith(".index");
    }

    private KubernetesLocalDiskShuffleExecutorComponents$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

