/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\n\u0015\u0001i\u0001\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000bE\u0002A\u0011\u0001\u001a\t\u000fU\u0002!\u0019!C\u0001m!1Q\n\u0001Q\u0001\n]BQA\u0014\u0001\u0005B=CQ!\u0016\u0001\u0005\nYCQA\u001d\u0001\u0005BM<aa\u001e\u000b\t\u0002iAhAB\n\u0015\u0011\u0003Q\u0012\u0010C\u00032\u0013\u0011\u0005!\u0010C\u0004|\u0013\t\u0007I\u0011\u0001?\t\u000f\u0005-\u0011\u0002)A\u0005{\"A\u0011QB\u0005C\u0002\u0013\u0005A\u0010C\u0004\u0002\u0010%\u0001\u000b\u0011B?\t\u0011\u0005E\u0011B1A\u0005\u0002qDq!a\u0005\nA\u0003%Q\u0010\u0003\u0005\u0002\u0016%\u0011\r\u0011\"\u0001}\u0011\u001d\t9\"\u0003Q\u0001\nu\u0014q#T8v]R4v\u000e\\;nKN4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005U1\u0012\u0001\u00034fCR,(/Z:\u000b\u0005]A\u0012aA69g*\u0011\u0011DG\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c2\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&K\u0007\u0002)%\u0011!\u0006\u0006\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\t\r|gNZ\u0002\u0001!\tqs&D\u0001\u0017\u0013\t\u0001dC\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t\u0019D\u0007\u0005\u0002)\u0001!)1F\u0001a\u0001[\u0005\u0019\u0012\r\u001a3ji&|g.\u00197SKN|WO]2fgV\tq\u0007E\u00029{}j\u0011!\u000f\u0006\u0003um\nq!\\;uC\ndWM\u0003\u0002=G\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yJ$aC!se\u0006L()\u001e4gKJ\u0004\"\u0001Q&\u000e\u0003\u0005S!AQ\"\u0002\u000b5|G-\u001a7\u000b\u0005\u0011+\u0015aA1qS*\u0011aiR\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001%J\u0003\u001d1\u0017M\u0019:jGbR\u0011AS\u0001\u0003S>L!\u0001T!\u0003\u0017!\u000b7/T3uC\u0012\fG/Y\u0001\u0015C\u0012$\u0017\u000e^5p]\u0006d'+Z:pkJ\u001cWm\u001d\u0011\u0002\u0019\r|gNZ5hkJ,\u0007k\u001c3\u0015\u0005A\u001b\u0006C\u0001\u0018R\u0013\t\u0011fC\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u0015!V\u00011\u0001Q\u0003\r\u0001x\u000eZ\u0001\u0011G>t7\u000f\u001e:vGR4v\u000e\\;nKN$\"a\u00167\u0011\u0007a\u00037M\u0004\u0002Z=:\u0011!,X\u0007\u00027*\u0011A\fL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!aX\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\t\u0013R,'/\u00192mK*\u0011ql\t\t\u0005E\u00114\u0017.\u0003\u0002fG\t1A+\u001e9mKJ\u0002\"\u0001Q4\n\u0005!\f%a\u0003,pYVlW-T8v]R\u0004\"\u0001\u00116\n\u0005-\f%A\u0002,pYVlW\rC\u0003n\r\u0001\u0007a.A\u0006w_2,X.Z*qK\u000e\u001c\bc\u0001-a_B\u0011a\u0006]\u0005\u0003cZ\u0011AcS;cKJtW\r^3t->dW/\\3Ta\u0016\u001c\u0017\u0001I4fi\u0006#G-\u001b;j_:\fGnS;cKJtW\r^3t%\u0016\u001cx.\u001e:dKN$\u0012\u0001\u001e\t\u00041V|\u0014B\u0001<c\u0005\r\u0019V-]\u0001\u0018\u001b>,h\u000e\u001e,pYVlWm\u001d$fCR,(/Z*uKB\u0004\"\u0001K\u0005\u0014\u0005%\tC#\u0001=\u0002\u001bA36iX(O?\u0012+U*\u0011(E+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(AB*ue&tw-\u0001\bQ-\u000e{vJT0E\u000b6\u000be\n\u0012\u0011\u0002\u0007A36)\u0001\u0003Q-\u000e\u0003\u0013a\u0003)W\u0007~\u0003vj\u0015+G\u0013b\u000bA\u0002\u0015,D?B{5\u000b\u0016$J1\u0002\nq\u0002\u0015,D?\u0006\u001b5)R*T?6{E)R\u0001\u0011!Z\u001bu,Q\"D\u000bN\u001bv,T(E\u000b\u0002\u0002")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;
    private final ArrayBuffer<HasMetadata> additionalResources;

    public static String PVC_ACCESS_MODE() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE();
    }

    public static String PVC_POSTFIX() {
        return MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX();
    }

    public static String PVC() {
        return MountVolumesFeatureStep$.MODULE$.PVC();
    }

    public static String PVC_ON_DEMAND() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND();
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    public ArrayBuffer<HasMetadata> additionalResources() {
        return this.additionalResources;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes((Iterable<KubernetesVolumeSpec>)this.conf.volumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Iterable volumeMounts2 = (Iterable)tuple22._1();
        Iterable volumes2 = (Iterable)tuple22._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec> volumeSpecs) {
        scala.collection.immutable.Iterable duplicateMountPaths = (scala.collection.immutable.Iterable)((TraversableOnce)volumeSpecs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mountPath(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String x = (String)A1._1();
                    Seq ys = (Seq)A1._2();
                    if (ys.length() > 1) {
                        return (B1)new StringBuilder(2).append("'").append(x).append("'").toString();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                Seq ys;
                Tuple2<String, Seq<String>> tuple2 = x1;
                return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(duplicateMountPaths.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Found duplicated mountPath: ").append(duplicateMountPaths.mkString(", ")).toString());
        return (Iterable)((TraversableLike)volumeSpecs.zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                VolumeBuilder volumeBuilder;
                KubernetesVolumeSpec spec = (KubernetesVolumeSpec)tuple2._1();
                int i = tuple2._2$mcI$sp();
                VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withSubPath(spec.mountSubPath())).withName(spec.volumeName())).build();
                KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf = spec.volumeConf();
                if (kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf) {
                    KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
                    String hostPath = kubernetesHostPathVolumeConf.hostPath();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath, ""));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf) {
                    String claimName;
                    String string;
                    KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
                    String claimNameTemplate = kubernetesPVCVolumeConf.claimName();
                    Option<String> storageClass = kubernetesPVCVolumeConf.storageClass();
                    Option<String> size = kubernetesPVCVolumeConf.size();
                    KubernetesConf kubernetesConf = $this.conf;
                    if (kubernetesConf instanceof KubernetesExecutorConf) {
                        KubernetesExecutorConf kubernetesExecutorConf = (KubernetesExecutorConf)kubernetesConf;
                        string = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(7).append($this.conf.resourceNamePrefix()).append("-exec-").append(kubernetesExecutorConf.executorId()).append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), kubernetesExecutorConf.executorId());
                    } else {
                        string = claimName = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(8).append($this.conf.resourceNamePrefix()).append("-driver").append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString());
                    }
                    if (storageClass.isDefined() && size.isDefined()) {
                        this.additionalResources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasMetadata[]{((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluentImpl)new PersistentVolumeClaimBuilder().withKind(MountVolumesFeatureStep$.MODULE$.PVC())).withApiVersion("v1")).withNewMetadata().withName(claimName).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.conf.appId())).endMetadata()).withNewSpec().withStorageClassName((String)storageClass.get()).withAccessModes(new String[]{MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE()}).withResources(((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withRequests((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storage"), (Object)new Quantity((String)size.get()))}))).asJava())).build())).endSpec()).build()}));
                    }
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf) {
                    KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
                    Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                    Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Quantity)sizeLimit.map((Function1 & Serializable & scala.Serializable)x$3 -> new Quantity(x$3)).orNull(Predef$.MODULE$.$conforms())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesNFSVolumeConf) {
                    KubernetesNFSVolumeConf kubernetesNFSVolumeConf = (KubernetesNFSVolumeConf)kubernetesVolumeSpecificConf;
                    String path = kubernetesNFSVolumeConf.path();
                    String server = kubernetesNFSVolumeConf.server();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withNfs(new NFSVolumeSource(path, null, server));
                } else {
                    throw new MatchError((Object)kubernetesVolumeSpecificConf);
                }
                VolumeBuilder volumeBuilder2 = volumeBuilder;
                Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
                return new Tuple2((Object)volumeMount, (Object)volume);
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.additionalResources().toSeq();
    }

    public MountVolumesFeatureStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.additionalResources = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }
}

