/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorDecommission;
import org.apache.spark.scheduler.ExecutorDecommission$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEe!\u0002\u00192\u0001]j\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011U\u0004!\u0011!Q\u0001\nYDQ!\u001f\u0001\u0005\u0002iD\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005%\u0002\u0001)A\u0005\u0003\u001fA\u0011\"a\u000b\u0001\u0005\u0004%\t&!\f\t\u0011\u0005]\u0002\u0001)A\u0005\u0003_A\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u00033B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005%\u0004\u0001)A\u0005\u0003\u001fA\u0001\"a\u001b\u0001\t\u0003\t\u0014Q\u000e\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!!*\u0001\t\u0003\n9\u000bC\u0004\u0002*\u0002!\t%a*\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\t)\u000f\u0001C!\u0003ODqAa\u0002\u0001\t\u0003\u0012I\u0001C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u0013\tm\u0001A1A\u0005\u0002\tu\u0001\u0002\u0003B\u0016\u0001\u0001\u0006IAa\b\t\u000f\t5\u0002\u0001\"\u0015\u00030!9!1\t\u0001\u0005R\t\u0015cA\u0002B'\u0001\u0011\u0011y\u0005\u0003\u0004zS\u0011\u0005!\u0011\u000b\u0005\b\u0005+JC\u0011\u0002B,\u0011\u001d\u0011)(\u000bC\u0005\u0005oBqA!\u001f*\t\u0003\u0012Y\bC\u0004\u0003\u0000%\"\tE!!\t\u001d\t5\u0005\u0001%A\u0002\u0002\u0003%I!a*\u0003\u0010\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011!gM\u0001\u0004Wb\u001a(B\u0001\u001b6\u0003\u001d\u0019G.^:uKJT!AN\u001c\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0014\u0005\u0001q\u0004CA A\u001b\u0005\u0019\u0014BA!4\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$7\u0001\u0001\t\u0003\t\u0016k\u0011!N\u0005\u0003\rV\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003\t\u00198\r\u0005\u0002J\u00156\tq'\u0003\u0002Lo\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003\u001d^k\u0011a\u0014\u0006\u0003!F\u000baa\u00197jK:$(B\u0001*T\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003)V\u000bqAZ1ce&\u001c\u0007HC\u0001W\u0003\tIw.\u0003\u0002Y\u001f\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0010Kb,7-\u001e;peN+'O^5dKB\u00111LY\u0007\u00029*\u0011QLX\u0001\u000bG>t7-\u001e:sK:$(BA0a\u0003\u0011)H/\u001b7\u000b\u0003\u0005\fAA[1wC&\u00111\r\u0018\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003M\u001el\u0011!M\u0005\u0003QF\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fA\u0002]8e\u00032dwnY1u_J\u0004\"AZ6\n\u00051\f$!F!cgR\u0014\u0018m\u0019;Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0016Y&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\t1w.\u0003\u0002qc\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC<bi\u000eDWI^3oiN\u0004\"AZ:\n\u0005Q\f$aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006Q\u0001o\u001c7m\u000bZ,g\u000e^:\u0011\u0005\u0019<\u0018B\u0001=2\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0003\u0019a\u0014N\\5u}Qy1\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI\u0001\u0005\u0002g\u0001!)aG\u0003a\u0001\u0007\")qI\u0003a\u0001\u0011\")AJ\u0003a\u0001\u001b\")\u0011L\u0003a\u00015\")AM\u0003a\u0001K\")\u0011N\u0003a\u0001U\")QN\u0003a\u0001]\")\u0011O\u0003a\u0001e\")QO\u0003a\u0001m\u0006)\u0011\r\u001d9JIV\u0011\u0011q\u0002\t\u0005\u0003#\t\u0019C\u0004\u0003\u0002\u0014\u0005}\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e!)\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003;\tQa]2bY\u0006LA!!\t\u0002\u001c\u00051\u0001K]3eK\u001aLA!!\n\u0002(\t11\u000b\u001e:j]\u001eTA!!\t\u0002\u001c\u00051\u0011\r\u001d9JI\u0002\n!#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_V\u0011\u0011q\u0006\t\u0005\u0003c\t\u0019$\u0004\u0002\u0002\u001c%!\u0011QGA\u000e\u0005\u0019!u.\u001e2mK\u0006\u0019R.\u001b8SK\u001eL7\u000f^3sK\u0012\u0014\u0016\r^5pA\u0005\u0001\u0012N\\5uS\u0006dW\t_3dkR|'o]\u000b\u0003\u0003{\u0001B!!\r\u0002@%!\u0011\u0011IA\u000e\u0005\rIe\u000e^\u0001\u0012S:LG/[1m\u000bb,7-\u001e;peN\u0004\u0013!G:i_VdG\rR3mKR,GI]5wKJ\u001cVM\u001d<jG\u0016,\"!!\u0013\u0011\t\u0005E\u00121J\u0005\u0005\u0003\u001b\nYBA\u0004C_>dW-\u00198\u00025MDw.\u001e7e\t\u0016dW\r^3Ee&4XM]*feZL7-\u001a\u0011\u0002+MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u000612\u000f[8vY\u0012$U\r\\3uK\u0016CXmY;u_J\u001c\b%\u0001\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}s'\u0001\u0005sKN|WO]2f\u0013\u0011\t\u0019'!\u0018\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\fq\u0002Z3gCVdG\u000f\u0015:pM&dW\rI\u0001\n]\u0006lWm\u001d9bG\u0016\f!B\\1nKN\u0004\u0018mY3!\u0003A!wNU3n_Z,W\t_3dkR|'\u000f\u0006\u0004\u0002p\u0005U\u0014\u0011\u0010\t\u0005\u0003c\t\t(\u0003\u0003\u0002t\u0005m!\u0001B+oSRDq!a\u001e\u001a\u0001\u0004\ty!\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Dq!a\u001f\u001a\u0001\u0004\ti(\u0001\u0004sK\u0006\u001cxN\u001c\t\u0004\t\u0006}\u0014bAAAk\t\u0011R\t_3dkR|'\u000fT8tgJ+\u0017m]8o\u0003Y\u0019X\r^+q\u000bb,7-\u001e;pe\u000e{gNZ5h\u001b\u0006\u0004H\u0003BA8\u0003\u000fCq!!#\u001b\u0001\u0004\tY)A\u0005ee&4XM\u001d)pIB1\u0011\u0011GAG\u0003#KA!a$\u0002\u001c\t1q\n\u001d;j_:\u0004B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0003n_\u0012,GNC\u0002\u0002\u001cF\u000b1!\u00199j\u0013\u0011\ty*!&\u0003\u0007A{G-A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u000b\u0003\u0003\u001f\tQa\u001d;beR$\"!a\u001c\u0002\tM$x\u000e]\u0001\u0018I>\u0014V-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$B!a,\u0002:B1\u0011\u0011WA[\u0003\u0013j!!a-\u000b\u0007u\u000bY\"\u0003\u0003\u00028\u0006M&A\u0002$viV\u0014X\rC\u0004\u0002<z\u0001\r!!0\u00027I,7o\\;sG\u0016\u0004&o\u001c4jY\u0016$v\u000eV8uC2,\u00050Z2t!!\t\t\"a0\u0002Z\u0005u\u0012\u0002BAa\u0003O\u00111!T1q\u0003u\u0019XO\u001a4jG&,g\u000e\u001e*fg>,(oY3t%\u0016<\u0017n\u001d;fe\u0016$GCAA%\u000399W\r^#yK\u000e,Ho\u001c:JIN$\"!a3\u0011\r\u00055\u0017q[A\b\u001d\u0011\ty-a5\u000f\t\u0005U\u0011\u0011[\u0005\u0003\u0003;IA!!6\u0002\u001c\u00059\u0001/Y2lC\u001e,\u0017\u0002BAm\u00037\u00141aU3r\u0015\u0011\t).a\u0007\u000231\f'-\u001a7EK\u000e|W.\\5tg&|g.\u001b8h\u000bb,7m\u001d\u000b\u0005\u0003_\n\t\u000fC\u0004\u0002d\u0006\u0002\r!a3\u0002\u000f\u0015DXmY%eg\u0006)B-Z2p[6L7o]5p]\u0016CXmY;u_J\u001cH\u0003CAf\u0003S\fyPa\u0001\t\u000f\u0005-(\u00051\u0001\u0002n\u0006)R\r_3dkR|'o]!oI\u0012+7m\\7J]\u001a|\u0007CBA\u0019\u0003_\f\u00190\u0003\u0003\u0002r\u0006m!!B!se\u0006L\b\u0003CA\u0019\u0003k\fy!!?\n\t\u0005]\u00181\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0011\u000bY0C\u0002\u0002~V\u0012\u0001$\u0012=fGV$xN\u001d#fG>lW.[:tS>t\u0017J\u001c4p\u0011\u001d\u0011\tA\ta\u0001\u0003\u0013\n\u0001$\u00193kkN$H+\u0019:hKRtU/\\#yK\u000e,Ho\u001c:t\u0011\u001d\u0011)A\ta\u0001\u0003\u0013\n1\u0003\u001e:jO\u001e,'/\u001a3Cs\u0016CXmY;u_J\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0003_\u0013Y\u0001C\u0004\u0003\u000e\r\u0002\r!a3\u0002\u0017\u0015DXmY;u_JLEm]\u0001\u0015GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;\u0015\u0005\tM\u0001\u0003\u0002B\u000b\u0005/i\u0011\u0001A\u0005\u0004\u00053\u0001%A\u0004#sSZ,'/\u00128ea>Lg\u000e^\u0001\u0007Kb,7-\u00133\u0016\u0005\t}\u0001\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\u0007\t\u0015B,\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005S\u0011\u0019CA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\bKb,7-\u00133!\u0003I\u0019'/Z1uKR{7.\u001a8NC:\fw-\u001a:\u0015\u0005\tE\u0002CBA\u0019\u0003\u001b\u0013\u0019\u0004\u0005\u0003\u00036\t}RB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u0011M,7-\u001e:jifT1A!\u00108\u0003\u0019!W\r\u001d7ps&!!\u0011\tB\u001c\u0005qA\u0015\rZ8pa\u0012+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJ\f!#[:Fq\u0016\u001cW\u000f^8s\u000bb\u001cG.\u001e3fIR1\u0011\u0011\nB$\u0005\u0013Bq!a\u001e)\u0001\u0004\ty\u0001C\u0004\u0003L!\u0002\r!a\u0004\u0002\u0011!|7\u000f\u001e8b[\u0016\u0014\u0001dS;cKJtW\r^3t\tJLg/\u001a:F]\u0012\u0004x.\u001b8u'\rI#1\u0003\u000b\u0003\u0005'\u00022A!\u0006*\u000399WM\\3sCR,W\t_3d\u0013\u0012#BA!\u0017\u0003fAA\u0011\u0011\u0007B.\u0005?\ny'\u0003\u0003\u0003^\u0005m!a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\u0005E\"\u0011M\u0005\u0005\u0005G\nYBA\u0002B]fDqAa\u001a,\u0001\u0004\u0011I'A\u0004d_:$X\r\u001f;\u0011\t\t-$\u0011O\u0007\u0003\u0005[R1Aa\u001c8\u0003\r\u0011\boY\u0005\u0005\u0005g\u0012iG\u0001\bSa\u000e\u001c\u0015\r\u001c7D_:$X\r\u001f;\u0002M%<gn\u001c:f%\u0016<\u0017n\u001d;fe\u0016CXmY;u_J\fEo\u0015;paB,GmQ8oi\u0016DH/\u0006\u0002\u0003Z\u0005y!/Z2fSZ,\u0017I\u001c3SKBd\u0017\u0010\u0006\u0003\u0003Z\tu\u0004b\u0002B4[\u0001\u0007!\u0011N\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\tyGa!\t\u000f\t\u0015e\u00061\u0001\u0003\b\u0006Q!\u000f]2BI\u0012\u0014Xm]:\u0011\t\t-$\u0011R\u0005\u0005\u0005\u0017\u0013iG\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f!b];qKJ$3\u000f^8q\u0013\r\tI\u000b\u0011")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    public final ScheduledExecutorService org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final AbstractPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final String appId;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteDriverService;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    private final AtomicInteger execId;

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    private String appId() {
        return this.appId;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteDriverService() {
        return this.shouldDeleteDriverService;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map resolvedExecutorProperties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())}));
        Map confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)resolvedExecutorProperties).$plus$plus((GenTraversableOnce)resolvedExecutorProperties);
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (Map<String, String>)confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull(Predef$.MODULE$.$conforms()), (Seq<HasMetadata>)((Seq)new .colon.colon((Object)configMap, (List)Nil$.MODULE$)));
        ((CreateOrReplaceable)((AnyNamespaceOperation)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).resource((Object)configMap)).create();
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").getOrElse((Function0 & Serializable & scala.Serializable)() -> this.appId());
    }

    public void start() {
        super.start();
        this.podAllocator.start(this.applicationId(), this);
        Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
        this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
        this.lifecycleEventHandler.start(this);
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
            this.setUpExecutorConfigMap(this.podAllocator.driverPod());
            return;
        }
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteDriverService()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.services().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC()))) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.persistentVolumeClaims().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (this.shouldDeleteExecutors()) {
            this.podAllocator.stop(this.applicationId());
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            }
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    private void labelDecommissioningExecs(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL())).foreach((Function1 & Serializable & scala.Serializable)label -> {
            KubernetesClusterSchedulerBackend.$anonfun$labelDecommissioningExecs$1(this, execIds, label);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> decommissionExecutors(Tuple2<String, ExecutorDecommissionInfo>[] executorsAndDecomInfo, boolean adjustTargetNumExecutors, boolean triggeredByExecutor) {
        block0: {
            if (triggeredByExecutor) break block0;
            this.labelDecommissioningExecs((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        }
        return super.decommissionExecutors(executorsAndDecomInfo, adjustTargetNumExecutors, triggeredByExecutor);
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        this.labelDecommissioningExecs(executorIds);
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                    if (!((PodList)running.list()).getItems().isEmpty()) {
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                        return;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 ), $anonfun$run$6(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public AtomicInteger execId() {
        return this.execId;
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public static final /* synthetic */ void $anonfun$labelDecommissioningExecs$1(KubernetesClusterSchedulerBackend $this, Seq execIds$1, String label) {
        Runnable labelTask = new Runnable($this, execIds$1, label){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq execIds$1;
            private final String label$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$1.toArray(ClassTag$.MODULE$.apply(String.class)))).resources().forEach(podResource -> podResource.edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editOrNewMetadata().addToLabels($this.label$1, (String)((Option)$this.$outer.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))).endMetadata()).build())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.execIds$1 = execIds$1;
                this.label$1 = label$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$4()}, serializedLambda);
            }
        };
        $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, AbstractPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.appId = KubernetesConf$.MODULE$.getKubernetesAppId();
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteDriverService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_DELETE_ON_TERMINATION()));
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace = (String)this.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.execId = new AtomicInteger(0);
    }

    private class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private PartialFunction<Object, BoxedUnit> generateExecID(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof GenerateExecID) {
                        GenerateExecID generateExecID2 = (GenerateExecID)A1;
                        String newId = Integer.toString(this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().execId().incrementAndGet());
                        this.context$1.reply((Object)newId);
                        Runnable labelTask = new Runnable(this, generateExecID2, newId){
                            private final /* synthetic */ KubernetesDriverEndpoint$$anonfun$generateExecID$1 $outer;
                            private final GenerateExecID x2$1;
                            private final String newId$1;

                            public void run() {
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((EditReplacePatchable)((Nameable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withName($this.x2$1.podName())).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), $this.newId$1)).endMetadata()).build()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x2$1 = x2$1;
                                this.newId$1 = newId$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$7(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$generateExecID$1$$anon$3 )}, serializedLambda);
                            }
                        };
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof GenerateExecID;
                }

                public /* synthetic */ KubernetesDriverEndpoint org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.generateExecID(context).orElse(this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context)));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            Option execId = this.addressToExecutorId().get((Object)rpcAddress);
            Option option = execId;
            if (option instanceof Some) {
                Some some = (Some)option;
                String id = (String)some.value();
                Option option2 = this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().executorsPendingDecommission().get((Object)id);
                if (option2 instanceof Some) {
                    this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().removeExecutor(id, (ExecutorLossReason)new ExecutorDecommission((Option)None$.MODULE$, ExecutorDecommission$.MODULE$.apply$default$2()));
                } else {
                    this.disableExecutor(id);
                }
                return;
            }
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("No executor found for ").append(rpcAddress).toString());
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

