/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t}d!\u0002\u001a4\u0001ez\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u001da\bA1A\u0005\nuDq!a\u0005\u0001A\u0003%a\u0010C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u0011q\u0005\u0001!\u0002\u0013\tI\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011\u0011\n\u0001!\u0002\u0013\ti\u0003C\u0005\u0002L\u0001\u0011\r\u0011\"\u0003\u0002N!A\u0011q\n\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u00111\f\u0001!\u0002\u0013\t)\u0006C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011q\f\u0001!\u0002\u0013\t)\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002T!A\u00111\r\u0001!\u0002\u0013\t)\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u0010\u0001!\u0002\u0013\tI\u0007C\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002\u0004\"A\u00111\u0012\u0001!\u0002\u0013\t)\tC\u0005\u0002\u000e\u0002\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011q\u0013\u0001!\u0002\u0013\t\t\nC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011q\u0016\u0001!\u0002\u0013\ti\nC\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u00024\"A\u0011\u0011\u0019\u0001!\u0002\u0013\t)\fC\u0005\u0002D\u0002\u0011\r\u0011\"\u0003\u0002F\"A\u0011\u0011\u001a\u0001!\u0002\u0013\t9\rC\u0005\u0002L\u0002\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011Q\u001a\u0001!\u0002\u0013\t\t\n\u0003\u0006\u0002P\u0002\u0011\r\u0011\"\u00014\u0003#D\u0001\"!7\u0001A\u0003%\u00111\u001b\u0005\n\u00037\u0004\u0001\u0019!C\u0005\u0003;D\u0011\"!:\u0001\u0001\u0004%I!a:\t\u0011\u0005M\b\u0001)Q\u0005\u0003?D\u0011\"!>\u0001\u0001\u0004%I!a>\t\u0013\t\u0015\u0001\u00011A\u0005\n\t\u001d\u0001\u0002\u0003B\u0006\u0001\u0001\u0006K!!?\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018!9!q\u0005\u0001\u0005\u0002\t%\u0002b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqA!\u001c\u0001\t\u0013\u0011yGA\u000bFq\u0016\u001cW\u000f^8s!>$7/\u00117m_\u000e\fGo\u001c:\u000b\u0005Q*\u0014aA69g*\u0011agN\u0001\bG2,8\u000f^3s\u0015\tA\u0014(A\u0005tG\",G-\u001e7fe*\u0011!hO\u0001\u0006gB\f'o\u001b\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xmE\u0002\u0001\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013a!\u00118z%\u00164\u0007CA$K\u001b\u0005A%BA%:\u0003!Ig\u000e^3s]\u0006d\u0017BA&I\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA(Q\u001b\u0005I\u0014BA):\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004tK\u000eluM\u001d\t\u0003\u001fRK!!V\u001d\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u00031fk\u0011aM\u0005\u00035N\u0012\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003;\u001al\u0011A\u0018\u0006\u0003?\u0002\faa\u00197jK:$(BA1c\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003G\u0012\fqAZ1ce&\u001c\u0007HC\u0001f\u0003\tIw.\u0003\u0002h=\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tA&.\u0003\u0002lg\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)1\r\\8dWB\u0011a.]\u0007\u0002_*\u0011\u0001/O\u0001\u0005kRLG.\u0003\u0002s_\n)1\t\\8dW\u00061A(\u001b8jiz\"r!\u001e<xqfT8\u0010\u0005\u0002Y\u0001!)Aj\u0002a\u0001\u001d\")!k\u0002a\u0001'\")ak\u0002a\u0001/\")1l\u0002a\u00019\")\u0001n\u0002a\u0001S\")An\u0002a\u0001[\u0006\u0019R\tW#D+R{%kX%E?\u000e{UK\u0014+F%V\ta\u0010E\u0002\u0000\u0003\u001fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007CR|W.[2\u000b\t\u0005\u001d\u0011\u0011B\u0001\u000bG>t7-\u001e:sK:$(b\u00019\u0002\f)\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u0005!AC!u_6L7\rT8oO\u0006!R\tW#D+R{%kX%E?\u000e{UK\u0014+F%\u0002\n!\u0006^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d)feJ+7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE-\u0006\u0002\u0002\u001aAA\u00111DA\u000f\u0003C\t\t#\u0004\u0002\u0002\u0006%!\u0011qDA\u0003\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004\u0003\u0006\r\u0012bAA\u0013\u0005\n\u0019\u0011J\u001c;\u0002WQ|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN\u0004VM\u001d*fg>,(oY3Qe>4\u0017\u000e\\3JI\u0002\nQC\u001d9JIR{'+Z:pkJ\u001cW\r\u0015:pM&dW-\u0006\u0002\u0002.AA\u0011qFA\u001d\u0003C\ti$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u001diW\u000f^1cY\u0016T1!a\u000eC\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t\tDA\u0004ICNDW*\u00199\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011:\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA$\u0003\u0003\u0012qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0017eBLE\rV8SKN|WO]2f!J|g-\u001b7fA\u0005\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0016\u0005\u0005\u0005\u0012A\u00059pI\u0006cGn\\2bi&|gnU5{K\u0002\n!\u0003]8e\u00032dwnY1uS>tG)\u001a7bsV\u0011\u0011Q\u000b\t\u0004\u0003\u0006]\u0013bAA-\u0005\n!Aj\u001c8h\u0003M\u0001x\u000eZ!mY>\u001c\u0017\r^5p]\u0012+G.Y=!\u0003I\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;\u0002'A|Gm\u0011:fCRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002'\u0015DXmY;u_JLE\r\\3US6,w.\u001e;\u0002)\u0015DXmY;u_JLE\r\\3US6,w.\u001e;!\u0003%q\u0017-\\3ta\u0006\u001cW-\u0006\u0002\u0002jA!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=$)\u0004\u0002\u0002r)\u0019\u00111O'\u0002\rq\u0012xn\u001c;?\u0013\r\t9HQ\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]$)\u0001\u0006oC6,7\u000f]1dK\u0002\nqc[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3\u0016\u0005\u0005\u0015\u0005#B!\u0002\b\u0006%\u0014bAAE\u0005\n1q\n\u001d;j_:\f\u0001d[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3!\u0003U\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN,\"!!%\u0011\u0007\u0005\u000b\u0019*C\u0002\u0002\u0016\n\u0013qAQ8pY\u0016\fg.\u0001\ftQ>,H\u000e\u001a#fY\u0016$X-\u0012=fGV$xN]:!\u0003%!'/\u001b<feB{G-\u0006\u0002\u0002\u001eB)\u0011)a\"\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!B7pI\u0016d'bAAUA\u0006\u0019\u0011\r]5\n\t\u00055\u00161\u0015\u0002\u0004!>$\u0017A\u00033sSZ,'\u000fU8eA\u0005)b.Z<ms\u000e\u0013X-\u0019;fI\u0016CXmY;u_J\u001cXCAA[!!\ty#a.\u0002V\u0005m\u0016\u0002BA]\u0003c\u0011Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bcB!\u0002>\u0006\u0005\u0012QK\u0005\u0004\u0003\u007f\u0013%A\u0002+va2,''\u0001\foK^d\u0017p\u0011:fCR,G-\u0012=fGV$xN]:!\u0003}\u00198\r[3ek2,'o\u00138po:tUm\u001e7z\u0007J,\u0017\r^3e\u000bb,7m]\u000b\u0003\u0003\u000f\u0004\u0002\"a\f\u00028\u0006U\u0013\u0011E\u0001!g\u000eDW\rZ;mKJ\\en\\<o\u001d\u0016<H._\"sK\u0006$X\rZ#yK\u000e\u001c\b%\u0001\res:\fW.[2BY2|7-\u0019;j_:,e.\u00192mK\u0012\f\u0011\u0004Z=oC6L7-\u00117m_\u000e\fG/[8o\u000b:\f'\r\\3eA\u0005\u0011b.^7PkR\u001cH/\u00198eS:<\u0007k\u001c3t+\t\t\u0019\u000eE\u0002\u0000\u0003+LA!a6\u0002\u0002\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\f1C\\;n\u001fV$8\u000f^1oI&tw\rU8eg\u0002\nA\u0002\\1tiNs\u0017\r]:i_R,\"!a8\u0011\u0007a\u000b\t/C\u0002\u0002dN\u0012A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\u0018\u0001\u00057bgR\u001cf.\u00199tQ>$x\fJ3r)\u0011\tI/a<\u0011\u0007\u0005\u000bY/C\u0002\u0002n\n\u0013A!\u00168ji\"I\u0011\u0011_\u0014\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0014!\u00047bgR\u001cf.\u00199tQ>$\b%\u0001\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cXCAA}!\u0019\tYP!\u0001\u0002V5\u0011\u0011Q \u0006\u0005\u0003\u007f\f)$A\u0005j[6,H/\u00192mK&!!1AA\u007f\u0005\r\u0019V\r^\u0001\u0017I\u0016dW\r^3e\u000bb,7-\u001e;pe&#7o\u0018\u0013fcR!\u0011\u0011\u001eB\u0005\u0011%\t\tPKA\u0001\u0002\u0004\tI0A\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b\u0005K\u0002,\u0005\u001f\u00012!\u0011B\t\u0013\r\u0011\u0019B\u0011\u0002\tm>d\u0017\r^5mK\u0006)1\u000f^1siR1\u0011\u0011\u001eB\r\u0005;AqAa\u0007-\u0001\u0004\tI'A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u0005\b\u0005?a\u0003\u0019\u0001B\u0011\u0003A\u00198\r[3ek2,'OQ1dW\u0016tG\rE\u0002Y\u0005GI1A!\n4\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0003e\u0019X\r\u001e+pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0015\t\u0005%(1\u0006\u0005\b\u0005[i\u0003\u0019\u0001B\u0018\u0003m\u0011Xm]8ve\u000e,\u0007K]8gS2,Gk\u001c+pi\u0006dW\t_3dgBA\u00111\u000eB\u0019\u0003{\t\t#\u0003\u0003\u00034\u0005u$aA'ba\u0006I\u0011n\u001d#fY\u0016$X\r\u001a\u000b\u0005\u0003#\u0013I\u0004C\u0004\u0003<9\u0002\r!!\u001b\u0002\u0015\u0015DXmY;u_JLE-\u0001\bp]:+wo\u00158baNDw\u000e^:\u0015\u0011\u0005%(\u0011\tB\"\u0005\u000bBqAa\u00070\u0001\u0004\tI\u0007C\u0004\u0003 =\u0002\rA!\t\t\u000f\t\u001ds\u00061\u0001\u0003J\u0005I1O\\1qg\"|Go\u001d\t\u0007\u0005\u0017\u0012)&a8\u000f\t\t5#\u0011\u000b\b\u0005\u0003_\u0012y%C\u0001D\u0013\r\u0011\u0019FQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119F!\u0017\u0003\u0007M+\u0017OC\u0002\u0003T\t\u000b1C]3rk\u0016\u001cHOT3x\u000bb,7-\u001e;peN$\"\"!;\u0003`\t\r$q\rB5\u0011\u001d\u0011\t\u0007\ra\u0001\u0003C\t\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\u0005K\u0002\u0004\u0019AA\u0011\u0003\u001d\u0011XO\u001c8j]\u001eDqAa\u00071\u0001\u0004\tI\u0007C\u0004\u0003lA\u0002\r!!\t\u0002#I,7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE-\u0001\fjg\u0016CXmY;u_JLE\r\\3US6,GmT;u)\u0019\t\tJ!\u001d\u0003|!9!1O\u0019A\u0002\tU\u0014!B:uCR,\u0007c\u0001-\u0003x%\u0019!\u0011P\u001a\u0003!\u0015CXmY;u_J\u0004v\u000eZ*uCR,\u0007b\u0002B?c\u0001\u0007\u0011QK\u0001\fGV\u0014(/\u001a8u)&lW\r")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private volatile Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        block0: {
            resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
            if (this.numOutstandingPods().get() != 0) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    private void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        Seq k8sKnownExecIds = (Seq)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom());
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        Set schedulerKnownExecs = ((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$2(x$3)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((TraversableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$4))).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long execId = tuple2._1$mcJ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long timeCreated = tuple22._2$mcJ$sp();
            if (currentTime - timeCreated > this.podCreationTimeout()) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                return iterable;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$9(BoxesRunTime.unboxToLong((Object)x$6)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (Set)((Set)_deletedExecutorIds.elem).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> existingExecs.contains((Object)BoxesRunTime.boxToLong((long)elem)));
        }
        Map notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> !((Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$7)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((TraversableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$12(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(this, rpIdToExecsAndPodState, schedulerKnownExecs, currentTime, _deletedExecutorIds, applicationId, totalPendingCount, snapshots, x0$3);
            return BoxedUnit.UNIT;
        });
        this.deletedExecutorIds_$eq((Set<Object>)((Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    private void requestNewExecutors(int expected, int running, String applicationId, int resourceProfileId) {
        int numExecutorsToAllocate = package$.MODULE$.min(expected - running, this.podAllocationSize());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(resourceProfileId).append(", target: ").append(expected).append(" running: ").append(running).append(".").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
            KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod(), resourceProfileId);
            KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
            SparkPod executorPod = resolvedExecutorSpec.pod();
            Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
            Pod createdExecutorPod = (Pod)$this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
            try {
                Seq<HasMetadata> resources = resolvedExecutorSpec.executorKubernetesResources();
                KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$10)))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                    PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
                    return (PersistentVolumeClaim)$this.kubernetesClient.persistentVolumeClaims().create((Object)pvc);
                });
                this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdExecutorPod});
                    throw e;
                }
                throw throwable;
            }
        });
    }

    private boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long startTime = Instant.parse(state.pod().getStatus().getStartTime()).toEpochMilli();
                if (currentTime - startTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Cannot get startTime of pod ").append(state.pod()).toString());
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResourceProfile rp = (ResourceProfile)tuple2._1();
        int numExecs = tuple2._2$mcI$sp();
        $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
        int n = BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        return n;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$9(long x$6) {
        return ((Object)BoxesRunTime.boxToLong((long)x$6)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$12(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long execId = tuple2._1$mcJ$sp();
        ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
        int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
        HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$16(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$17(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$18(Set schedulerKnownExecs$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long k = tuple2._1$mcJ$sp();
        boolean bl = schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$19(int rpId$1, Tuple2 x0$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int waitingRpId = tuple2._1$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$20(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int waitingRpId = tuple2._2$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$9;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long createTime = tuple2._2$mcJ$sp();
        boolean bl = currentTime$1 - createTime > $this.executorIdleTimeout();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$24(Tuple2 x0$10) {
        long id;
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$27(long x$9) {
        return ((Object)BoxesRunTime.boxToLong((long)x$9)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$14(ExecutorPodsAllocator $this, HashMap rpIdToExecsAndPodState$1, Set schedulerKnownExecs$1, long currentTime$1, ObjectRef _deletedExecutorIds$1, String applicationId$2, IntRef totalPendingCount$1, Seq snapshots$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int knownPodCount;
            int rpId = tuple2._1$mcI$sp();
            int targetNum = tuple2._2$mcI$sp();
            HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
            int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$16(x0$4)));
            Tuple2 tuple22 = ((TraversableLike)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(x0$5)))).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$18(schedulerKnownExecs$1, x0$6)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
            HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
            Tuple2 tuple24 = tuple23;
            HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple24._1();
            HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple24._2();
            IntRef knownPendingCount = IntRef.create((int)currentPendingExecutorsForRpId2.size());
            LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)$this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$19(rpId, x0$7)));
            LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)$this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$20(rpId, x0$8)));
            if (podsForRpId.nonEmpty()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("ResourceProfile Id: ").append(rpId).append(" ").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created.").toString());
            }
            if ((knownPodCount = currentRunningCount + currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()) > targetNum) {
                scala.collection.mutable.Iterable knownPendingToDelete;
                int excess = knownPodCount - targetNum;
                List newlyCreatedToDelete = ((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22($this, currentTime$1, x0$9)))).keys().take(excess)).toList();
                List toDelete = (List)newlyCreatedToDelete.$plus$plus((GenTraversableOnce)(knownPendingToDelete = (scala.collection.mutable.Iterable)((TraversableLike)((IterableLike)currentPendingExecutorsForRpId2.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)$this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime$1)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(x0$10)), Iterable$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom());
                if (toDelete.nonEmpty()) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                    _deletedExecutorIds$1.elem = (Set)((Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId$2)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$27(BoxesRunTime.unboxToLong((Object)x$9)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                        $this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)newlyCreatedToDelete);
                        knownPendingCount$1.elem -= knownPendingToDelete.size();
                    });
                }
            }
            if (newlyCreatedExecutorsForRpId.isEmpty() && knownPodCount < targetNum) {
                $this.requestNewExecutors(targetNum, knownPodCount, applicationId$2, rpId);
            }
            totalPendingCount$1.elem += knownPendingCount.elem;
            if ($this.log().isDebugEnabled() && snapshots$1.nonEmpty()) {
                int outstanding = knownPendingCount.elem + newlyCreatedExecutorsForRpId.size();
                if (currentRunningCount >= targetNum && !$this.dynamicAllocationEnabled()) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (outstanding > 0) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(outstanding).append(" executors for ResourceProfile ").append("Id ").append(rpId).append(" before requesting more.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$10) {
        String string = x$10.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

