/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db!B\u0007\u000f\u0001QQ\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u00115\u0002!\u0011!Q\u0001\n9BQA\u000f\u0001\u0005\u0002mB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002!\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0013I\u0005\"C(\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015y\u0006\u0001\"\u0001a\r\u0011\t\u0007\u0001\u00022\t\u000biJA\u0011\u0001;\t\u000b]LA\u0011\t=\t\u000f\u0005e\u0011\u0002\"\u0011\u0002\u001c\tyR\t_3dkR|'\u000fU8eg^\u000bGo\u00195T]\u0006\u00048\u000f[8u'>,(oY3\u000b\u0005=\u0001\u0012aA69g*\u0011\u0011CE\u0001\bG2,8\u000f^3s\u0015\t\u0019B#A\u0005tG\",G-\u001e7fe*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xmE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0015\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0014$\u0005\u001daunZ4j]\u001e\fab\u001d8baNDw\u000e^:Ti>\u0014Xm\u0001\u0001\u0011\u0005)ZS\"\u0001\b\n\u00051r!AG#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\ty\u0003(D\u00011\u0015\t\t$'\u0001\u0004dY&,g\u000e\u001e\u0006\u0003gQ\n!b[;cKJtW\r^3t\u0015\t)d'A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003]\n!![8\n\u0005e\u0002$\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u0019A(\u0010 \u0011\u0005)\u0002\u0001\"B\u0014\u0004\u0001\u0004I\u0003\"B\u0017\u0004\u0001\u0004q\u0013aD<bi\u000eD7i\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003\u0005\u0003\"A\u0011$\u000e\u0003\rS!a\u000e#\u000b\u0003\u0015\u000bAA[1wC&\u0011qi\u0011\u0002\n\u00072|7/Z1cY\u0016\f1c^1uG\"\u001cuN\u001c8fGRLwN\\0%KF$\"AS'\u0011\u0005qY\u0015B\u0001'\u001e\u0005\u0011)f.\u001b;\t\u000f9+\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002!]\fGo\u00195D_:tWm\u0019;j_:\u0004\u0013!B:uCJ$HC\u0001&S\u0011\u0015\u0019v\u00011\u0001U\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JIB\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u000f\u000e\u0003aS!!\u0017\u0015\u0002\rq\u0012xn\u001c;?\u0013\tYV$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.\u001e\u0003\u0011\u0019Ho\u001c9\u0015\u0003)\u00131#\u0012=fGV$xN\u001d)pIN<\u0016\r^2iKJ\u001c2!C2j!\t!w-D\u0001f\u0015\t1G)\u0001\u0003mC:<\u0017B\u00015f\u0005\u0019y%M[3diB\u0019qF\u001b7\n\u0005-\u0004$aB,bi\u000eDWM\u001d\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fQ!\\8eK2T!!\u001d\u001a\u0002\u0007\u0005\u0004\u0018.\u0003\u0002t]\n\u0019\u0001k\u001c3\u0015\u0003U\u0004\"A^\u0005\u000e\u0003\u0001\tQ\"\u001a<f]R\u0014VmY3jm\u0016$G\u0003\u0002&z\u0003+AQA_\u0006A\u0002m\fa!Y2uS>t\u0007c\u0001?\u0002\u00109\u0019Q0a\u0003\u000f\u0007y\fIAD\u0002\u0000\u0003\u000fqA!!\u0001\u0002\u00069\u0019q+a\u0001\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014BA\u00193\u0013\r\ti\u0001M\u0001\b/\u0006$8\r[3s\u0013\u0011\t\t\"a\u0005\u0003\r\u0005\u001bG/[8o\u0015\r\ti\u0001\r\u0005\u0007\u0003/Y\u0001\u0019\u00017\u0002\u0007A|G-A\u0004p]\u000ecwn]3\u0015\u0007)\u000bi\u0002C\u0004\u0002 1\u0001\r!!\t\u0002\u0003\u0015\u00042aLA\u0012\u0013\r\t)\u0003\r\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\u0005pY3qi&|g\u000e")
public class ExecutorPodsWatchSnapshotSource
implements Logging {
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore;
    private final KubernetesClient kubernetesClient;
    private Closeable watchConnection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Closeable watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Closeable x$1) {
        this.watchConnection = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.watchConnection() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start the watcher twice.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Starting watch for pods with labels ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append("=").append(applicationId).append(",").append(" ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append("=").append(Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).append(".").toString());
        this.watchConnection_$eq((Closeable)((Watchable)((Filterable)this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).watch((Object)new ExecutorPodsWatcher()));
    }

    public void stop() {
        block0: {
            if (this.watchConnection() == null) break block0;
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.watchConnection().close());
            this.watchConnection_$eq(null);
        }
    }

    public ExecutorPodsWatchSnapshotSource(ExecutorPodsSnapshotsStore snapshotsStore, KubernetesClient kubernetesClient) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore = snapshotsStore;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
    }

    public class ExecutorPodsWatcher
    implements Watcher<Pod> {
        public void eventReceived(Watcher.Action action, Pod pod) {
            String podName = pod.getMetadata().getName();
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received executor pod update for pod named ").append(podName).append(", action ").append(action).toString());
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore.updatePod(pod);
        }

        public void onClose(KubernetesClientException e) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed (this is expected if the application is shutting down.)", (Throwable)e);
        }

        public /* synthetic */ ExecutorPodsWatchSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer() {
            return ExecutorPodsWatchSnapshotSource.this;
        }

        public ExecutorPodsWatcher() {
            if (ExecutorPodsWatchSnapshotSource.this == null) {
                throw null;
            }
        }
    }
}

