/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.scheduler.cluster.k8s.PodUnknown;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ExecutorPodsSnapshot$
implements Logging,
scala.Serializable {
    public static ExecutorPodsSnapshot$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExecutorPodsSnapshot$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ExecutorPodsSnapshot apply(Seq<Pod> executorPods) {
        return new ExecutorPodsSnapshot(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(executorPods));
    }

    public ExecutorPodsSnapshot apply() {
        return new ExecutorPodsSnapshot((Map<Object, ExecutorPodState>)Predef$.MODULE$.Map().empty());
    }

    public Map<Object, ExecutorPodState> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(Seq<Pod> executorPods) {
        return ((TraversableOnce)executorPods.map((Function1 & Serializable & scala.Serializable)pod -> new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()))).toLong()), (Object)MODULE$.toState((Pod)pod)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private ExecutorPodState toState(Pod pod) {
        Product product;
        if (this.isDeleted(pod)) {
            product = new PodDeleted(pod);
        } else {
            Product product2;
            String phase = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
            String string = phase;
            if ("pending".equals(string)) {
                product2 = new PodPending(pod);
            } else if ("running".equals(string)) {
                product2 = new PodRunning(pod);
            } else if ("failed".equals(string)) {
                product2 = new PodFailed(pod);
            } else if ("succeeded".equals(string)) {
                product2 = new PodSucceeded(pod);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Received unknown phase ").append(phase).append(" for executor pod with name").append(" ").append(pod.getMetadata().getName()).append(" in namespace ").append(pod.getMetadata().getNamespace()).toString());
                product2 = new PodUnknown(pod);
            }
            product = product2;
        }
        return product;
    }

    private boolean isDeleted(Pod pod) {
        return pod.getMetadata().getDeletionTimestamp() != null;
    }

    public ExecutorPodsSnapshot apply(Map<Object, ExecutorPodState> executorPods) {
        return new ExecutorPodsSnapshot(executorPods);
    }

    public Option<Map<Object, ExecutorPodState>> unapply(ExecutorPodsSnapshot x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.executorPods());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExecutorPodsSnapshot$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

