/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!\u0002\u0014(\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001d\u0001\bA1A\u0005\nEDa! \u0001!\u0002\u0013\u0011\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003\u000f\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\t\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002F!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002^!I\u0011\u0011\u000f\u0001C\u0002\u0013%\u00111\u000f\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002v!I\u0011q\u0011\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002R!I\u00111\u0012\u0001C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002\u0010\"I\u0011q\u0013\u0001A\u0002\u0013%\u0011\u0011\u0014\u0005\n\u0003C\u0003\u0001\u0019!C\u0005\u0003GC\u0001\"a,\u0001A\u0003&\u00111\u0014\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!1\u0001\t\u0013\t\u0019MA\u000bFq\u0016\u001cW\u000f^8s!>$7/\u00117m_\u000e\fGo\u001c:\u000b\u0005!J\u0013aA69g*\u0011!fK\u0001\bG2,8\u000f^3s\u0015\taS&A\u0005tG\",G-\u001e7fe*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xmE\u0002\u0001ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e?\u001b\u0005a$BA\u001f.\u0003!Ig\u000e^3s]\u0006d\u0017BA =\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA\"E\u001b\u0005i\u0013BA#.\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004tK\u000eluM\u001d\t\u0003\u0007\"K!!S\u0017\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u0003\u00196k\u0011aJ\u0005\u0003\u001d\u001e\u0012\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000baa\u00197jK:$(BA+W\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003/b\u000bqAZ1ce&\u001c\u0007HC\u0001Z\u0003\tIw.\u0003\u0002\\%\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tae,\u0003\u0002`O\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)1\r\\8dWB\u0011!-Z\u0007\u0002G*\u0011A-L\u0001\u0005kRLG.\u0003\u0002gG\n)1\t\\8dW\u00061A(\u001b8jiz\"r!\u001b6lY6tw\u000e\u0005\u0002M\u0001!)\u0001i\u0002a\u0001\u0005\")ai\u0002a\u0001\u000f\")!j\u0002a\u0001\u0017\")qj\u0002a\u0001!\")Al\u0002a\u0001;\")\u0001m\u0002a\u0001C\u0006\u0019R\tW#D+R{%kX%E?\u000e{UK\u0014+F%V\t!\u000f\u0005\u0002tw6\tAO\u0003\u0002vm\u00061\u0011\r^8nS\u000eT!a\u001e=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002es*\t!0\u0001\u0003kCZ\f\u0017B\u0001?u\u0005)\tEo\\7jG2{gnZ\u0001\u0015\u000bb+5)\u0016+P%~KEiX\"P+:#VI\u0015\u0011\u0002-Q|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN,\"!!\u0001\u0011\u0007M\f\u0019!C\u0002\u0002\u0006Q\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018a\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:!\u0003E\u0001x\u000eZ!mY>\u001c\u0017\r^5p]NK'0Z\u000b\u0003\u0003\u001b\u00012!NA\b\u0013\r\t\tB\u000e\u0002\u0004\u0013:$\u0018A\u00059pI\u0006cGn\\2bi&|gnU5{K\u0002\n!\u0003]8e\u00032dwnY1uS>tG)\u001a7bsV\u0011\u0011\u0011\u0004\t\u0004k\u0005m\u0011bAA\u000fm\t!Aj\u001c8h\u0003M\u0001x\u000eZ!mY>\u001c\u0017\r^5p]\u0012+G.Y=!\u0003I\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;\u0002'A|Gm\u0011:fCRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002\u00139\fW.Z:qC\u000e,WCAA\u0015!\u0011\tY#!\u000f\u000f\t\u00055\u0012Q\u0007\t\u0004\u0003_1TBAA\u0019\u0015\r\t\u0019$Q\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]b'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\tiD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003o1\u0014A\u00038b[\u0016\u001c\b/Y2fA\u000592.\u001e2fe:,G/Z:Ee&4XM\u001d)pI:\u000bW.Z\u000b\u0003\u0003\u000b\u0002R!NA$\u0003SI1!!\u00137\u0005\u0019y\u0005\u000f^5p]\u0006A2.\u001e2fe:,G/Z:Ee&4XM\u001d)pI:\u000bW.\u001a\u0011\u0002+MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sgV\u0011\u0011\u0011\u000b\t\u0004k\u0005M\u0013bAA+m\t9!i\\8mK\u0006t\u0017AF:i_VdG\rR3mKR,W\t_3dkR|'o\u001d\u0011\u0002\u0013\u0011\u0014\u0018N^3s!>$WCAA/!\u0015)\u0014qIA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nQ!\\8eK2T1!!\u001bU\u0003\r\t\u0007/[\u0005\u0005\u0003[\n\u0019GA\u0002Q_\u0012\f!\u0002\u001a:jm\u0016\u0014\bk\u001c3!\u0003UqWm\u001e7z\u0007J,\u0017\r^3e\u000bb,7-\u001e;peN,\"!!\u001e\u0011\u0011\u0005]\u0014\u0011QA\r\u00033i!!!\u001f\u000b\t\u0005m\u0014QP\u0001\b[V$\u0018M\u00197f\u0015\r\tyHN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAB\u0003s\u00121!T1q\u0003YqWm\u001e7z\u0007J,\u0017\r^3e\u000bb,7-\u001e;peN\u0004\u0013\u0001\u00073z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0006IB-\u001f8b[&\u001c\u0017\t\u001c7pG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u00039A\u0017m\u001d)f]\u0012Lgn\u001a)pIN,\"!a$\u0011\u0007M\f\t*C\u0002\u0002\u0014R\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017a\u00045bgB+g\u000eZ5oOB{Gm\u001d\u0011\u0002\u00191\f7\u000f^*oCB\u001c\bn\u001c;\u0016\u0005\u0005m\u0005c\u0001'\u0002\u001e&\u0019\u0011qT\u0014\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003Aa\u0017m\u001d;T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0006-\u0006cA\u001b\u0002(&\u0019\u0011\u0011\u0016\u001c\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003[\u000b\u0013\u0011!a\u0001\u00037\u000b1\u0001\u001f\u00132\u00035a\u0017m\u001d;T]\u0006\u00048\u000f[8uA\u0005)1\u000f^1siR!\u0011QUA[\u0011\u001d\t9l\ta\u0001\u0003S\tQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0017!G:fiR{G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN$B!!*\u0002>\"9\u0011q\u0018\u0013A\u0002\u00055\u0011!\u0002;pi\u0006d\u0017AD8o\u001d\u0016<8K\\1qg\"|Go\u001d\u000b\u0007\u0003K\u000b)-a2\t\u000f\u0005]V\u00051\u0001\u0002*!9\u0011\u0011Z\u0013A\u0002\u0005-\u0017!C:oCB\u001c\bn\u001c;t!\u0019\ti-a6\u0002\u001c:!\u0011qZAj\u001d\u0011\ty#!5\n\u0003]J1!!67\u0003\u001d\u0001\u0018mY6bO\u0016LA!!7\u0002\\\n\u00191+Z9\u000b\u0007\u0005Ug\u0007")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final AtomicInteger totalExpectedExecutors;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final Map<Object, Object> newlyCreatedExecutors;
    private final boolean dynamicAllocationEnabled;
    private final AtomicBoolean hasPendingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private AtomicInteger totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private Option<Pod> driverPod() {
        return this.driverPod;
    }

    private Map<Object, Object> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    private AtomicBoolean hasPendingPods() {
        return this.hasPendingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    public void start(String applicationId) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(int total) {
        block0: {
            this.totalExpectedExecutors().set(total);
            if (this.hasPendingPods().get()) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    private synchronized void onNewSnapshots(String applicationId, Seq<ExecutorPodsSnapshot> snapshots) {
        block9: {
            IntRef knownPendingCount;
            block8: {
                this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom()));
                long currentTime = this.clock.getTimeMillis();
                scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        long execId = tuple2._1$mcJ$sp();
                        long timeCreated = tuple2._2$mcJ$sp();
                        if (currentTime - timeCreated > this.podCreationTimeout()) {
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                        } else {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Iterable iterable2 = iterable;
                    return iterable2;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
                if (timedOut.nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
                    this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
                    if (this.shouldDeleteExecutors()) {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$6(BoxesRunTime.unboxToLong((Object)x$3)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
                    }
                }
                if (snapshots.nonEmpty()) {
                    this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
                }
                int currentRunningCount = this.lastSnapshot().executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$7(x0$2)));
                scala.collection.immutable.Iterable currentPendingExecutors = (scala.collection.immutable.Iterable)((TraversableLike)this.lastSnapshot().executorPods().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$8(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$9(x0$4)), Iterable$.MODULE$.canBuildFrom());
                if (snapshots.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutors.size()).append(" pending, ").append(this.newlyCreatedExecutors().size()).append(" unacknowledged.").toString());
                }
                int currentTotalExpectedExecutors = this.totalExpectedExecutors().get();
                knownPendingCount = IntRef.create((int)currentPendingExecutors.size());
                int knownPodCount = currentRunningCount + currentPendingExecutors.size() + this.newlyCreatedExecutors().size();
                if (knownPodCount > currentTotalExpectedExecutors) {
                    int excess = knownPodCount - currentTotalExpectedExecutors;
                    scala.collection.immutable.Iterable knownPendingToDelete = (scala.collection.immutable.Iterable)currentPendingExecutors.take(excess - this.newlyCreatedExecutors().size());
                    List toDelete = (List)((TraversableOnce)this.newlyCreatedExecutors().keys().take(excess)).toList().$plus$plus((GenTraversableOnce)knownPendingToDelete, List$.MODULE$.canBuildFrom());
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$13(BoxesRunTime.unboxToLong((Object)x$4)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)toDelete);
                            knownPendingCount$1.elem -= knownPendingToDelete.size();
                        });
                    }
                }
                if (this.newlyCreatedExecutors().isEmpty() && currentPendingExecutors.isEmpty() && currentRunningCount < currentTotalExpectedExecutors) {
                    int numExecutorsToAllocate = package$.MODULE$.min(currentTotalExpectedExecutors - currentRunningCount, this.podAllocationSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes.").toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                        long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                        KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod());
                        SparkPod executorPod = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient);
                        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                        $this.kubernetesClient.pods().create((Object[])new Pod[]{podWithAttachedContainer});
                        this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)BoxesRunTime.boxToLong((long)$this.clock.getTimeMillis()));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                    });
                }
                this.hasPendingPods().set(knownPendingCount.elem + this.newlyCreatedExecutors().size() > 0);
                if (!this.log().isDebugEnabled() || snapshots.isEmpty()) {
                    return;
                }
                if (currentRunningCount < currentTotalExpectedExecutors || this.dynamicAllocationEnabled()) break block8;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current number of running executors is equal to the number of requested executors. Not scaling up further.");
                break block9;
            }
            int outstanding = knownPendingCount.elem + this.newlyCreatedExecutors().size();
            if (outstanding <= 0) break block9;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Still waiting for ").append(outstanding).append(" executors before requesting more.").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$6(long x$3) {
        return ((Object)BoxesRunTime.boxToLong((long)x$3)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$7(ExecutorPodState x0$2) {
        ExecutorPodState executorPodState = x0$2;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$8(Tuple2 x0$3) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$3;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$9(Tuple2 x0$4) {
        long id;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$13(long x$4) {
        return ((Object)BoxesRunTime.boxToLong((long)x$4)).toString();
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutors = new AtomicInteger(0);
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = Map$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.hasPendingPods = new AtomicBoolean();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply((Seq<Pod>)Nil$.MODULE$);
    }
}

