/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!\u0002\n\u0014\u0001Uy\u0002\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000ba\u0002A\u0011A\u001d\t\u000fq\u0002!\u0019!C\u0005{!11\n\u0001Q\u0001\nyBq\u0001\u0014\u0001A\u0002\u0013%Q\nC\u0004S\u0001\u0001\u0007I\u0011B*\t\re\u0003\u0001\u0015)\u0003O\u0011\u001dQ\u0006\u00011A\u0005\nmCq!\u001c\u0001A\u0002\u0013%a\u000e\u0003\u0004q\u0001\u0001\u0006K\u0001\u0018\u0005\u0006c\u0002!I!\u0010\u0005\u0006e\u0002!\te\u001d\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002*\u0001!I!a\t\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.\tYBj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]%na2T!\u0001F\u000b\u0002\rM,(-\\5u\u0015\t1r#A\u0002lqMT!\u0001G\r\u0002\r\u0011,\u0007\u000f\\8z\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0003\u0002\u0001!Q1\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004PE*,7\r\u001e\t\u0003S)j\u0011aE\u0005\u0003WM\u0011q\u0003T8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=J\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Er#a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005U2T\"A\u000b\n\u0005]*\"\u0001F&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003um\u0002\"!\u000b\u0001\t\u000bI\u0012\u0001\u0019\u0001\u001b\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0003y\u0002\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"4\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9E)\u0001\u0004baBLE\rI\u0001\ra>$7i\\7qY\u0016$X\rZ\u000b\u0002\u001dB\u0011q\nU\u0007\u0002\t&\u0011\u0011\u000b\u0012\u0002\b\u0005>|G.Z1o\u0003A\u0001x\u000eZ\"p[BdW\r^3e?\u0012*\u0017\u000f\u0006\u0002U/B\u0011q*V\u0005\u0003-\u0012\u0013A!\u00168ji\"9\u0001LBA\u0001\u0002\u0004q\u0015a\u0001=%c\u0005i\u0001o\u001c3D_6\u0004H.\u001a;fI\u0002\n1\u0001]8e+\u0005a\u0006cA(^?&\u0011a\f\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001\\W\"A1\u000b\u0005\t\u001c\u0017!B7pI\u0016d'B\u00013f\u0003\r\t\u0007/\u001b\u0006\u0003M\u001e\f!b[;cKJtW\r^3t\u0015\tA\u0017.A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003)\f!![8\n\u00051\f'a\u0001)pI\u00069\u0001o\u001c3`I\u0015\fHC\u0001+p\u0011\u001dA\u0016\"!AA\u0002q\u000bA\u0001]8eA\u0005)\u0001\u000f[1tK\u0006iQM^3oiJ+7-Z5wK\u0012$B\u0001\u0016;\u0002\u0010!)Q\u000f\u0004a\u0001m\u00061\u0011m\u0019;j_:\u00042a^A\u0005\u001d\rA\u00181\u0001\b\u0003s~t!A\u001f@\u000f\u0005mlhBA!}\u0013\u0005Q\u0017B\u00015j\u0013\t1w-C\u0002\u0002\u0002\u0015\faa\u00197jK:$\u0018\u0002BA\u0003\u0003\u000f\tqaV1uG\",'OC\u0002\u0002\u0002\u0015LA!a\u0003\u0002\u000e\t1\u0011i\u0019;j_:TA!!\u0002\u0002\b!)!\f\u0004a\u0001?\u00069qN\\\"m_N,Gc\u0001+\u0002\u0016!9\u0011qC\u0007A\u0002\u0005e\u0011!A3\u0011\t\u0005m\u0011QD\u0007\u0003\u0003\u000fIA!a\b\u0002\b\tI2*\u001e2fe:,G/Z:DY&,g\u000e^#yG\u0016\u0004H/[8o\u00035awn\u001a'p]\u001e\u001cF/\u0019;vgR\tA+\u0001\u0007iCN\u001cu.\u001c9mKR,G\rF\u0001O\u0003)\u0019Gn\\:f/\u0006$8\r[\u0001\fo\u0006$8\r[(s'R|\u0007\u000fF\u0002U\u0003_Aa!!\r\u0012\u0001\u0004q\u0014aA:JI\u0002")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final KubernetesDriverConf conf;
    private final String appId;
    private boolean podCompleted;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private boolean podCompleted() {
        return this.podCompleted;
    }

    private void podCompleted_$eq(boolean x$1) {
        this.podCompleted = x$1;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown");
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(KubernetesClientException e) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append(this.appId()).append(" with last-observed phase ").append(this.phase()).toString());
        this.closeWatch();
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & java.io.Serializable & Serializable)pod -> KubernetesUtils$.MODULE$.formatPodState((Pod)pod)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private synchronized void closeWatch() {
        this.podCompleted_$eq(true);
        this.notifyAll();
    }

    @Override
    public void watchOrStop(String sId) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()))) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Waiting for application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" to finish...").toString());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf.get(Config$.MODULE$.REPORT_INTERVAL()));
            LoggingPodStatusWatcherImpl loggingPodStatusWatcherImpl = this;
            synchronized (loggingPodStatusWatcherImpl) {
                while (!this.podCompleted()) {
                    this.wait(interval);
                    this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Application status for ").append(this.appId()).append(" (phase: ").append(this.phase()).append(")").toString());
                }
            }
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> (String)this.pod().map((Function1 & java.io.Serializable & Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(KubernetesUtils$.MODULE$.containersDescription((Pod)p, KubernetesUtils$.MODULE$.containersDescription$default$2())).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "No containers were found in the driver pod."));
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" finished").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(63).append("Deployed Spark application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" into Kubernetes").toString());
        }
    }

    public LoggingPodStatusWatcherImpl(KubernetesDriverConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.appId = conf.appId();
        this.podCompleted = false;
        this.pod = Option$.MODULE$.empty();
    }
}

