/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4Q!\u0003\u0006\u0001!YA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006W\u0001!\t\u0005\f\u0005\u0006e\u0001!\te\r\u0005\u0006\u0005\u0002!Ia\u0011\u0005\u0006\u000f\u0002!I\u0001\u0013\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006\u001f\u0002!I\u0001\u0015\u0002\u0019\tJLg/\u001a:D_6l\u0017M\u001c3GK\u0006$XO]3Ti\u0016\u0004(BA\u0006\r\u0003!1W-\u0019;ve\u0016\u001c(BA\u0007\u000f\u0003\rY\u0007h\u001d\u0006\u0003\u001fA\ta\u0001Z3qY>L(BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011AC\u0005\u0003A)\u00111dS;cKJtW\r^3t\r\u0016\fG/\u001e:f\u0007>tg-[4Ti\u0016\u0004\u0018\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002%K5\tA\"\u0003\u0002'\u0019\t!2*\u001e2fe:,G/Z:Ee&4XM]\"p]\u001a\fa\u0001P5oSRtDCA\u0015+!\tq\u0002\u0001C\u0003\"\u0005\u0001\u00071%\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002.aA\u0011AEL\u0005\u0003_1\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006c\r\u0001\r!L\u0001\u0004a>$\u0017\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012\u0001\u000e\t\u0005kqztH\u0004\u00027uA\u0011q'G\u0007\u0002q)\u0011\u0011HI\u0001\u0007yI|w\u000e\u001e \n\u0005mJ\u0012A\u0002)sK\u0012,g-\u0003\u0002>}\t\u0019Q*\u00199\u000b\u0005mJ\u0002CA\u001bA\u0013\t\teH\u0001\u0004TiJLgnZ\u0001\u0011G>tg-[4ve\u00164uN\u001d&bm\u0006$2!\f#F\u0011\u0015\tT\u00011\u0001.\u0011\u00151U\u00011\u0001@\u0003\r\u0011Xm]\u0001\u0013G>tg-[4ve\u00164uN\u001d)zi\"|g\u000eF\u0002.\u0013*CQ!\r\u0004A\u00025BQA\u0012\u0004A\u0002}\nQbY8oM&<WO]3G_J\u0014FcA\u0017N\u001d\")\u0011g\u0002a\u0001[!)ai\u0002a\u0001\u007f\u0005\u0019\"-Y:f\tJLg/\u001a:D_:$\u0018-\u001b8feR\u0019\u0011k\u00181\u0011\u0005IkV\"A*\u000b\u0005Q+\u0016!B7pI\u0016d'B\u0001,X\u0003\r\t\u0007/\u001b\u0006\u00031f\u000b!b[;cKJtW\r^3t\u0015\tQ6,A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003q\u000b!![8\n\u0005y\u001b&\u0001E\"p]R\f\u0017N\\3s\u0005VLG\u000eZ3s\u0011\u0015\t\u0004\u00021\u0001.\u0011\u0015\t\u0007\u00021\u0001@\u0003!\u0011Xm]8ve\u000e,\u0007")
public class DriverCommandFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesDriverConf conf;

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        SparkPod sparkPod;
        MainAppResource mainAppResource = this.conf.mainAppResource();
        if (mainAppResource instanceof JavaMainAppResource) {
            JavaMainAppResource javaMainAppResource = (JavaMainAppResource)mainAppResource;
            Option<String> res = javaMainAppResource.primaryResource();
            sparkPod = this.configureForJava(pod, (String)res.getOrElse((Function0 & Serializable & scala.Serializable)() -> "spark-internal"));
        } else if (mainAppResource instanceof PythonMainAppResource) {
            PythonMainAppResource pythonMainAppResource = (PythonMainAppResource)mainAppResource;
            String res = pythonMainAppResource.primaryResource();
            sparkPod = this.configureForPython(pod, res);
        } else if (mainAppResource instanceof RMainAppResource) {
            RMainAppResource rMainAppResource = (RMainAppResource)mainAppResource;
            String res = rMainAppResource.primaryResource();
            sparkPod = this.configureForR(pod, res);
        } else {
            throw new MatchError((Object)mainAppResource);
        }
        return sparkPod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String string;
        MainAppResource mainAppResource = this.conf.mainAppResource();
        if (mainAppResource instanceof JavaMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_JAVA();
        } else if (mainAppResource instanceof PythonMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON();
        } else if (mainAppResource instanceof RMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_R();
        } else {
            throw new MatchError((Object)mainAppResource);
        }
        String appType = string;
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.APP_RESOURCE_TYPE().key()), (Object)appType)}));
    }

    private SparkPod configureForJava(SparkPod pod, String res) {
        Container driverContainer = this.baseDriverContainer(pod, res).build();
        return new SparkPod(pod.pod(), driverContainer);
    }

    private SparkPod configureForPython(SparkPod pod, String res) {
        Seq pythonEnvs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_MAJOR_PYTHON_VERSION())).withValue(this.conf.get(Config$.MODULE$.PYSPARK_MAJOR_PYTHON_VERSION()))).build()}));
        Container pythonContainer = ((ContainerBuilder)this.baseDriverContainer(pod, res).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(pythonEnvs).asJava())).build();
        return new SparkPod(pod.pod(), pythonContainer);
    }

    private SparkPod configureForR(SparkPod pod, String res) {
        Container rContainer = this.baseDriverContainer(pod, res).build();
        return new SparkPod(pod.pod(), rContainer);
    }

    private ContainerBuilder baseDriverContainer(SparkPod pod, String resource) {
        String resolvedResource = this.conf.mainAppResource() instanceof JavaMainAppResource ? KubernetesUtils$.MODULE$.renameMainAppResource(resource, this.conf.sparkConf()) : resource;
        return (ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).addToArgs(new String[]{"driver"})).addToArgs(new String[]{"--properties-file", Constants$.MODULE$.SPARK_CONF_PATH()})).addToArgs(new String[]{"--class", this.conf.mainClass()})).addToArgs(new String[]{resolvedResource})).addToArgs(this.conf.appArgs());
    }

    public DriverCommandFeatureStep(KubernetesDriverConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
    }
}

