/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!B\u0011#\u0001!r\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0013a\u0002!\u0011!Q\u0001\nez\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011!I\u0007A!A!\u0002\u0013Q\u0007\"B7\u0001\t\u0003q\u0007bB=\u0001\u0005\u0004%YA\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003|\u0011%\t9\u0001\u0001b\u0001\n#\nI\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0006\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\r\u0011!\t\t\u0003\u0001C\u0001E\u0005\r\u0002bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\t9\u0006\u0001C!\u0003+Bq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0004\u0007\u0003O\u0003A!!+\t\u0015aR\"\u0011!Q\u0001\ne\nY\u000b\u0003\u0006\u0002.j\u0011\t\u0011)A\u0005\u0003?Ca!\u001c\u000e\u0005\u0002\u0005=\u0006bBA\\5\u0011\u0005\u0013\u0011\u0018\u0005\u000f\u0003\u000b\u0004\u0001\u0013aA\u0001\u0002\u0013%\u0011\u0011KAd\u00119\ti\r\u0001I\u0001\u0004\u0003\u0005I\u0011BA+\u0003\u001f\u0014\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!a\t\u0013\u0002\u0007-D4O\u0003\u0002&M\u000591\r\\;ti\u0016\u0014(BA\u0014)\u0003%\u00198\r[3ek2,'O\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h'\t\u0001q\u0006\u0005\u00021c5\tA%\u0003\u00023I\ti2i\\1sg\u0016<%/Y5oK\u0012\u001c6\r[3ek2,'OQ1dW\u0016tGm\u0001\u0001\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#!\u0005+bg.\u001c6\r[3ek2,'/S7qY\u00061!\u000f]2F]Z\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0015\u0002\u0007I\u00048-\u0003\u0002?w\t1!\u000b]2F]ZL!\u0001O\u0019\u0002!-,(-\u001a:oKR,7o\u00117jK:$\bC\u0001\"L\u001b\u0005\u0019%B\u0001#F\u0003\u0019\u0019G.[3oi*\u0011aiR\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001%J\u0003\u001d1\u0017M\u0019:jGbR\u0011AS\u0001\u0003S>L!\u0001T\"\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018a\u0006:fcV,7\u000f^#yK\u000e,Ho\u001c:t'\u0016\u0014h/[2f!\tye+D\u0001Q\u0015\t\t&+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0015+\u0002\tU$\u0018\u000e\u001c\u0006\u0002+\u0006!!.\u0019<b\u0013\t9\u0006KA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u0004\"AW.\u000e\u0003\tJ!\u0001\u0018\u0012\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\u0019A|G-\u00117m_\u000e\fGo\u001c:\u0011\u0005i{\u0016B\u00011#\u0005U)\u00050Z2vi>\u0014\bk\u001c3t\u00032dwnY1u_J\fQ\u0003\\5gK\u000eL8\r\\3Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002[G&\u0011AM\t\u0002\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0003-9\u0018\r^2i\u000bZ,g\u000e^:\u0011\u0005i;\u0017B\u00015#\u0005})\u00050Z2vi>\u0014\bk\u001c3t/\u0006$8\r[*oCB\u001c\bn\u001c;T_V\u00148-Z\u0001\u000ba>dG.\u0012<f]R\u001c\bC\u0001.l\u0013\ta'EA\u0011Fq\u0016\u001cW\u000f^8s!>$7\u000fU8mY&twm\u00158baNDw\u000e^*pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u000b_B\f(o\u001d;vm^D\bC\u0001.\u0001\u0011\u00159#\u00021\u00015\u0011\u0015A$\u00021\u0001:\u0011\u0015\u0001%\u00021\u0001B\u0011\u0015i%\u00021\u0001O\u0011\u0015A&\u00021\u0001Z\u0011\u0015i&\u00021\u0001_\u0011\u0015\t'\u00021\u0001c\u0011\u0015)'\u00021\u0001g\u0011\u0015I'\u00021\u0001k\u0003Y\u0011X-];fgR,\u00050Z2vi>\u00148i\u001c8uKb$X#A>\u0011\u0007q\f\t!D\u0001~\u0015\t\tfPC\u0001\u0000\u0003\u0015\u00198-\u00197b\u0013\r\t\u0019! \u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017a\u0006:fcV,7\u000f^#yK\u000e,Ho\u001c:D_:$X\r\u001f;!\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003\u001fi\u0011A`\u0005\u0004\u0003#q(A\u0002#pk\ndW-A\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|\u0007%\u0001\tj]&$\u0018.\u00197Fq\u0016\u001cW\u000f^8sgV\u0011\u0011\u0011\u0004\t\u0005\u0003\u001b\tY\"C\u0002\u0002\u001ey\u00141!\u00138u\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000fI\u0001\u0011I>\u0014V-\\8wK\u0016CXmY;u_J$b!!\n\u0002,\u0005\u0015\u0003\u0003BA\u0007\u0003OI1!!\u000b\u007f\u0005\u0011)f.\u001b;\t\u000f\u00055\u0012\u00031\u0001\u00020\u0005QQ\r_3dkR|'/\u00133\u0011\t\u0005E\u0012q\b\b\u0005\u0003g\tY\u0004E\u0002\u00026yl!!a\u000e\u000b\u0007\u0005e2'\u0001\u0004=e>|GOP\u0005\u0004\u0003{q\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005\r#AB*ue&twMC\u0002\u0002>yDq!a\u0012\u0012\u0001\u0004\tI%\u0001\u0004sK\u0006\u001cxN\u001c\t\u0004k\u0005-\u0013bAA'M\t\u0011R\t_3dkR|'\u000fT8tgJ+\u0017m]8o\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JIR\u0011\u0011qF\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003K\tAa\u001d;pa\u00069Bm\u001c*fcV,7\u000f\u001e+pi\u0006dW\t_3dkR|'o\u001d\u000b\u0005\u0003;\nI\u0007E\u0003}\u0003?\n\u0019'C\u0002\u0002bu\u0014aAR;ukJ,\u0007\u0003BA\u0007\u0003KJ1!a\u001a\u007f\u0005\u001d\u0011un\u001c7fC:Dq!a\u001b\u0016\u0001\u0004\tI\"\u0001\bsKF,Xm\u001d;fIR{G/\u00197\u0002;M,hMZ5dS\u0016tGOU3t_V\u00148-Z:SK\u001eL7\u000f^3sK\u0012$\"!a\u0019\u0002\u001d\u001d,G/\u0012=fGV$xN]%egR\u0011\u0011Q\u000f\t\u0007\u0003o\n\t)a\f\u000f\t\u0005e\u0014Q\u0010\b\u0005\u0003k\tY(C\u0001\u0000\u0013\r\tyH`\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019)!\"\u0003\u0007M+\u0017OC\u0002\u0002\u0000y\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0003;\nY\tC\u0004\u0002\u000eb\u0001\r!!\u001e\u0002\u0017\u0015DXmY;u_JLEm]\u0001\u0015GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;\u0015\t\u0005M\u00151\u0014\t\u0005\u0003+\u000b9*D\u0001\u0001\u0013\r\tI*\r\u0002\u000f\tJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0011\u001d\ti*\u0007a\u0001\u0003?\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\u0019\t9(!!\u0002\"BA\u0011QBAR\u0003_\ty#C\u0002\u0002&z\u0014a\u0001V;qY\u0016\u0014$\u0001G&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiN\u0019!$a%\n\u0007a\n9*A\bta\u0006\u00148\u000e\u0015:pa\u0016\u0014H/[3t)\u0019\t\t,a-\u00026B\u0019\u0011Q\u0013\u000e\t\u000baj\u0002\u0019A\u001d\t\u000f\u00055V\u00041\u0001\u0002 \u0006qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA\u0013\u0003wCq!!0\u001f\u0001\u0004\ty,\u0001\u0006sa\u000e\fE\r\u001a:fgN\u00042AOAa\u0013\r\t\u0019m\u000f\u0002\u000b%B\u001c\u0017\t\u001a3sKN\u001c\u0018aE:va\u0016\u0014H%\u00199qY&\u001c\u0017\r^5p]&#\u0017\u0002BA(\u0003\u0013L1!a3'\u0005A\u00196\r[3ek2,'OQ1dW\u0016tG-\u0001\u0006tkB,'\u000fJ:u_BL1!a\u00162\u0001")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final KubernetesClient kubernetesClient;
    private final ExecutorService requestExecutorsService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final ExecutionContextExecutorService requestExecutorContext;
    private final double minRegisteredRatio;
    private final int initialExecutors;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    private ExecutionContextExecutorService requestExecutorContext() {
        return this.requestExecutorContext;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        if (!Utils$.MODULE$.isDynamicAllocationEnabled(this.conf())) {
            this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        }
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown($this.requestExecutorsService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.podAllocator.setTotalExpectedExecutors(requestedTotal);
            return true;
        }, (ExecutionContext)this.requestExecutorContext());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Boolean2boolean((Boolean)((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])executorIds.toArray(ClassTag$.MODULE$.apply(String.class)))).delete()), (ExecutionContext)this.requestExecutorContext());
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new KubernetesDriverEndpoint(this, super.rpcEnv(), properties);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv, KubernetesClient kubernetesClient, ExecutorService requestExecutorsService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.kubernetesClient = kubernetesClient;
        this.requestExecutorsService = requestExecutorsService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, rpcEnv);
        this.requestExecutorContext = ExecutionContext$.MODULE$.fromExecutorService(requestExecutorsService);
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }
}

