/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u000e\u001d\u0001\tB\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\t\u0003!\u0011!Q\u0001\n\rCQ!\u0013\u0001\u0005\u0002)CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0015\u0005\b9\u0002\u0011\r\u0011\"\u0003P\u0011\u0019i\u0006\u0001)A\u0005!\"9a\f\u0001b\u0001\n\u0013y\u0006BB2\u0001A\u0003%\u0001\rC\u0004e\u0001\t\u0007I\u0011B0\t\r\u0015\u0004\u0001\u0015!\u0003a\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0011\b\u0001\"\u0011t\u000f!\t9\u0002\bE\u0001E\u0005eaaB\u000e\u001d\u0011\u0003\u0011\u00131\u0004\u0005\u0007\u0013B!\t!!\b\t\u0011\u0005}\u0001C1A\u0005\u0002=Cq!!\t\u0011A\u0003%\u0001\u000b\u0003\u0005\u0002$A\u0011\r\u0011\"\u0001P\u0011\u001d\t)\u0003\u0005Q\u0001\nAC\u0011\"a\n\u0011\u0005\u0004%\t!!\u000b\t\u0011\u0005e\u0002\u0003)A\u0005\u0003WA\u0001\"a\u000f\u0011\u0005\u0004%\ta\u0018\u0005\b\u0003{\u0001\u0002\u0015!\u0003a\u0011%\ty\u0004EI\u0001\n\u0003\t\tE\u0001\rEe&4XM]*feZL7-\u001a$fCR,(/Z*uKBT!!\b\u0010\u0002\u0011\u0019,\u0017\r^;sKNT!a\b\u0011\u0002\u0007-D4O\u0003\u0002\"E\u00051A-\u001a9m_fT!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\n\u0005\u0001%z3\u0007\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aEj\u0011\u0001H\u0005\u0003eq\u00111dS;cKJtW\r^3t\r\u0016\fG/\u001e:f\u0007>tg-[4Ti\u0016\u0004\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c#\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001d6\u0005\u001daunZ4j]\u001e\fab[;cKJtW\r^3t\u0007>tgm\u0001\u0001\u0011\u0007qjt(D\u0001\u001f\u0013\tqdD\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0011\u0005q\u0002\u0015BA!\u001f\u0005qYUOY3s]\u0016$Xm\u001d#sSZ,'o\u00159fG&4\u0017nY\"p]\u001a\fQa\u00197pG.\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003\u0011\u0016\u0013Qa\u00117pG.\fa\u0001P5oSRtDcA&M\u001bB\u0011\u0001\u0007\u0001\u0005\u0006s\r\u0001\ra\u000f\u0005\b\u0005\u000e\u0001\n\u00111\u0001D\u0003Q\u0001(/\u001a4feJ,GmU3sm&\u001cWMT1nKV\t\u0001\u000b\u0005\u0002R1:\u0011!K\u0016\t\u0003'.j\u0011\u0001\u0016\u0006\u0003+j\na\u0001\u0010:p_Rt\u0014BA,,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005][\u0013!\u00069sK\u001a,'O]3e'\u0016\u0014h/[2f\u001d\u0006lW\rI\u0001\u0014e\u0016\u001cx\u000e\u001c<fIN+'O^5dK:\u000bW.Z\u0001\u0015e\u0016\u001cx\u000e\u001c<fIN+'O^5dK:\u000bW.\u001a\u0011\u0002\u0015\u0011\u0014\u0018N^3s!>\u0014H/F\u0001a!\tQ\u0013-\u0003\u0002cW\t\u0019\u0011J\u001c;\u0002\u0017\u0011\u0014\u0018N^3s!>\u0014H\u000fI\u0001\u0017IJLg/\u001a:CY>\u001c7.T1oC\u001e,'\u000fU8si\u00069BM]5wKJ\u0014En\\2l\u001b\u0006t\u0017mZ3s!>\u0014H\u000fI\u0001\rG>tg-[4ve\u0016\u0004v\u000e\u001a\u000b\u0003Q.\u0004\"\u0001P5\n\u0005)t\"\u0001C*qCJ\\\u0007k\u001c3\t\u000b1d\u0001\u0019\u00015\u0002\u0007A|G-\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\u001c)pINK8\u000f^3n!J|\u0007/\u001a:uS\u0016\u001cH#A8\u0011\tE\u0003\b\u000bU\u0005\u0003cj\u00131!T1q\u0003\u0001:W\r^!eI&$\u0018n\u001c8bY.+(-\u001a:oKR,7OU3t_V\u00148-Z:\u0015\u0003Q\u00042!\u001e>~\u001d\t1\bP\u0004\u0002To&\tA&\u0003\u0002zW\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003s.\u00022A`A\n\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQ!\\8eK2TA!!\u0002\u0002\b\u0005\u0019\u0011\r]5\u000b\t\u0005%\u00111B\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA\u0007\u0003\u001f\tqAZ1ce&\u001c\u0007H\u0003\u0002\u0002\u0012\u0005\u0011\u0011n\\\u0005\u0004\u0003+y(a\u0003%bg6+G/\u00193bi\u0006\f\u0001\u0004\u0012:jm\u0016\u00148+\u001a:wS\u000e,g)Z1ukJ,7\u000b^3q!\t\u0001\u0004c\u0005\u0002\u0011SQ\u0011\u0011\u0011D\u0001\u0018\tJKe+\u0012*`\u0005&sEiX!E\tJ+5kU0L\u000bf\u000b\u0001\u0004\u0012*J-\u0016\u0013vLQ%O\t~\u000bE\t\u0012*F'N{6*R-!\u0003=!%+\u0013,F%~Cuj\u0015+`\u0017\u0016K\u0016\u0001\u0005#S\u0013Z+%k\u0018%P'R{6*R-!\u0003I!%+\u0013,F%~\u001bfkQ0Q\u001fN#f)\u0013-\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005Y\u0006twM\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\rI\u0016qF\u0001\u0014\tJKe+\u0012*`'Z\u001bu\fU(T)\u001aK\u0005\fI\u0001\u0018\u001b\u0006CvlU#S-&\u001bUi\u0018(B\u001b\u0016{F*\u0012(H)\"\u000b\u0001$T!Y?N+%KV%D\u000b~s\u0015)T#`\u0019\u0016su\t\u0016%!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\t\u0016\u0004\u0007\u0006\u00153FAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E3&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0016\u0002L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DriverServiceFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;
    private final String preferredServiceName;
    private final String resolvedServiceName;
    private final int driverPort;
    private final int driverBlockManagerPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2();
    }

    public static int MAX_SERVICE_NAME_LENGTH() {
        return DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH();
    }

    public static String DRIVER_SVC_POSTFIX() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
    }

    public static String DRIVER_HOST_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY();
    }

    public static String DRIVER_BIND_ADDRESS_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String preferredServiceName() {
        return this.preferredServiceName;
    }

    private String resolvedServiceName() {
        return this.resolvedServiceName;
    }

    private int driverPort() {
        return this.driverPort;
    }

    private int driverBlockManagerPort() {
        return this.driverBlockManagerPort;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        return pod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String driverHostname = new StringBuilder(5).append(this.resolvedServiceName()).append(".").append(this.kubernetesConf.namespace()).append(".svc").toString();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()), (Object)driverHostname), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.port"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverPort())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverBlockManagerPort())).toString())}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        Service driverService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceFluentImpl)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.resolvedServiceName())).endMetadata()).withNewSpec().withClusterIP("None").withSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleLabels()).asJava()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort()))).endPort()).endSpec()).build();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Service[]{driverService}));
    }

    public DriverServiceFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf, Clock clock) {
        String string;
        this.kubernetesConf = kubernetesConf;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is not supported in Kubernetes mode, as the driver's bind ").append("address is managed and set to the driver pod's IP address.").toString());
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is not supported in Kubernetes mode, as the driver's hostname will be ").append("managed via a Kubernetes service.").toString());
        this.preferredServiceName = new StringBuilder(0).append(kubernetesConf.appResourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
        if (this.preferredServiceName().length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
            string = this.preferredServiceName();
        } else {
            long randomServiceId = clock.getTimeMillis();
            String shorterServiceName = new StringBuilder(6).append("spark-").append(randomServiceId).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(137).append("Driver's hostname would preferably be ").append(this.preferredServiceName()).append(", but this is ").append("too long (must be <= ").append(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()).append(" characters). Falling back to use ").append(shorterServiceName).append(" as the driver service's name.").toString());
            string = shorterServiceName;
        }
        this.resolvedServiceName = string;
        this.driverPort = kubernetesConf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        this.driverBlockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
    }
}

