/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-g!\u0002\u0011\"\u0001\u001dj\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0013]\u0002!\u0011!Q\u0001\nar\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!A\u0007A!A!\u0002\u0013I\u0007\"\u00027\u0001\t\u0003i\u0007b\u0002=\u0001\u0005\u0004%Y!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003{\u0011%\t)\u0001\u0001b\u0001\n#\n9\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0005\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011!\ty\u0002\u0001C\u0001C\u0005\u0005\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t)\u0006\u0001C!\u0003'Bq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0004\u0007\u0003K\u0003A!a*\t\u0015]R\"\u0011!Q\u0001\na\nI\u000b\u0003\u0006\u0002,j\u0011\t\u0011)A\u0005\u0003;Ca\u0001\u001c\u000e\u0005\u0002\u00055\u0006bBA[5\u0011\u0005\u0013q\u0017\u0005\u000f\u0003\u0007\u0004\u0001\u0013aA\u0001\u0002\u0013%\u0011qJAc\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0015\t\u00113%A\u0002lqMT!\u0001J\u0013\u0002\u000f\rdWo\u001d;fe*\u0011aeJ\u0001\ng\u000eDW\rZ;mKJT!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\n\u0003\u00019\u0002\"a\f\u0019\u000e\u0003\rJ!!M\u0012\u0003;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u001c\u0001\u0001\u0005\u00025k5\tQ%\u0003\u00027K\t\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\u0002\rI\u00048-\u00128w!\tID(D\u0001;\u0015\tYt%A\u0002sa\u000eL!!\u0010\u001e\u0003\rI\u00038-\u00128w\u0013\t9\u0004'\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011\u0011IS\u0007\u0002\u0005*\u00111\tR\u0001\u0007G2LWM\u001c;\u000b\u0005\u00153\u0015AC6vE\u0016\u0014h.\u001a;fg*\u0011q\tS\u0001\bM\u0006\u0014'/[29\u0015\u0005I\u0015AA5p\u0013\tY%I\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u00069\"/Z9vKN$X\t_3dkR|'o]*feZL7-\u001a\t\u0003\u001dVk\u0011a\u0014\u0006\u0003!F\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u00116+\u0001\u0003vi&d'\"\u0001+\u0002\t)\fg/Y\u0005\u0003->\u0013q\"\u0012=fGV$xN]*feZL7-Z\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tI&,D\u0001\"\u0013\tY\u0016E\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-\u0001\u0007q_\u0012\fE\u000e\\8dCR|'\u000f\u0005\u0002Z=&\u0011q,\t\u0002\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s\u0003Ua\u0017NZ3ds\u000edW-\u0012<f]RD\u0015M\u001c3mKJ\u0004\"!\u00172\n\u0005\r\f#\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\fo\u0006$8\r[#wK:$8\u000f\u0005\u0002ZM&\u0011q-\t\u0002 \u000bb,7-\u001e;peB{Gm],bi\u000eD7K\\1qg\"|GoU8ve\u000e,\u0017A\u00039pY2,e/\u001a8ugB\u0011\u0011L[\u0005\u0003W\u0006\u0012\u0011%\u0012=fGV$xN\u001d)pIN\u0004v\u000e\u001c7j]\u001e\u001cf.\u00199tQ>$8k\\;sG\u0016\fa\u0001P5oSRtDC\u00038paF\u00148\u000f^;woB\u0011\u0011\f\u0001\u0005\u0006M)\u0001\ra\r\u0005\u0006o)\u0001\r\u0001\u000f\u0005\u0006\u007f)\u0001\r\u0001\u0011\u0005\u0006\u0019*\u0001\r!\u0014\u0005\u0006/*\u0001\r\u0001\u0017\u0005\u00069*\u0001\r!\u0018\u0005\u0006A*\u0001\r!\u0019\u0005\u0006I*\u0001\r!\u001a\u0005\u0006Q*\u0001\r![\u0001\u0017e\u0016\fX/Z:u\u000bb,7-\u001e;pe\u000e{g\u000e^3yiV\t!\u0010\u0005\u0002|\u007f6\tAP\u0003\u0002Q{*\ta0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0002q\u0014q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003]\u0011X-];fgR,\u00050Z2vi>\u00148i\u001c8uKb$\b%\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|WCAA\u0005!\u0011\tY!!\u0004\u000e\u0003uL1!a\u0004~\u0005\u0019!u.\u001e2mK\u0006\u0019R.\u001b8SK\u001eL7\u000f^3sK\u0012\u0014\u0016\r^5pA\u0005\u0001\u0012N\\5uS\u0006dW\t_3dkR|'o]\u000b\u0003\u0003/\u0001B!a\u0003\u0002\u001a%\u0019\u00111D?\u0003\u0007%sG/A\tj]&$\u0018.\u00197Fq\u0016\u001cW\u000f^8sg\u0002\n\u0001\u0003Z8SK6|g/Z#yK\u000e,Ho\u001c:\u0015\r\u0005\r\u0012\u0011FA\"!\u0011\tY!!\n\n\u0007\u0005\u001dRP\u0001\u0003V]&$\bbBA\u0016#\u0001\u0007\u0011QF\u0001\u000bKb,7-\u001e;pe&#\u0007\u0003BA\u0018\u0003{qA!!\r\u0002:A\u0019\u00111G?\u000e\u0005\u0005U\"bAA\u001ce\u00051AH]8pizJ1!a\u000f~\u0003\u0019\u0001&/\u001a3fM&!\u0011qHA!\u0005\u0019\u0019FO]5oO*\u0019\u00111H?\t\u000f\u0005\u0015\u0013\u00031\u0001\u0002H\u00051!/Z1t_:\u00042\u0001NA%\u0013\r\tY%\n\u0002\u0013\u000bb,7-\u001e;pe2{7o\u001d*fCN|g.A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u000b\u0003\u0003[\tQa\u001d;beR$\"!a\t\u0002\tM$x\u000e]\u0001\u0018I>\u0014V-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$B!a\u0017\u0002hA)10!\u0018\u0002b%\u0019\u0011q\f?\u0003\r\u0019+H/\u001e:f!\u0011\tY!a\u0019\n\u0007\u0005\u0015TPA\u0004C_>dW-\u00198\t\u000f\u0005%T\u00031\u0001\u0002\u0018\u0005q!/Z9vKN$X\r\u001a+pi\u0006d\u0017!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\u0005\u0005\u0014AD4fi\u0016CXmY;u_JLEm\u001d\u000b\u0003\u0003g\u0002b!!\u001e\u0002\u0000\u00055b\u0002BA<\u0003wrA!a\r\u0002z%\ta0C\u0002\u0002~u\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%aA*fc*\u0019\u0011QP?\u0002\u001f\u0011|7*\u001b7m\u000bb,7-\u001e;peN$B!a\u0017\u0002\n\"9\u00111\u0012\rA\u0002\u0005M\u0014aC3yK\u000e,Ho\u001c:JIN\fAc\u0019:fCR,GI]5wKJ,e\u000e\u001a9pS:$H\u0003BAI\u00033\u0003B!a%\u0002\u00166\t\u0001!C\u0002\u0002\u0018B\u0012a\u0002\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000fC\u0004\u0002\u001cf\u0001\r!!(\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0004\u0002v\u0005}\u0014q\u0014\t\t\u0003\u0017\t\t+!\f\u0002.%\u0019\u00111U?\u0003\rQ+\b\u000f\\33\u0005aYUOY3s]\u0016$Xm\u001d#sSZ,'/\u00128ea>Lg\u000e^\n\u00045\u0005E\u0015bA\u001c\u0002\u0016\u0006y1\u000f]1sWB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u00020\u0006E\u00161\u0017\t\u0004\u0003'S\u0002\"B\u001c\u001e\u0001\u0004A\u0004bBAV;\u0001\u0007\u0011QT\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\t\u0019#!/\t\u000f\u0005mf\u00041\u0001\u0002>\u0006Q!\u000f]2BI\u0012\u0014Xm]:\u0011\u0007e\ny,C\u0002\u0002Bj\u0012!B\u00159d\u0003\u0012$'/Z:t\u0003M\u0019X\u000f]3sI\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0013\u0011\ti%a2\n\u0007\u0005%WE\u0001\tTG\",G-\u001e7fe\n\u000b7m[3oI\u0002")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final KubernetesClient kubernetesClient;
    private final ExecutorService requestExecutorsService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final ExecutionContextExecutorService requestExecutorContext;
    private final double minRegisteredRatio;
    private final int initialExecutors;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    private ExecutionContextExecutorService requestExecutorContext() {
        return this.requestExecutorContext;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        if (!Utils$.MODULE$.isDynamicAllocationEnabled(this.conf())) {
            this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        }
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        super.stop();
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown($this.requestExecutorsService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.podAllocator.setTotalExpectedExecutors(requestedTotal);
            return true;
        }, (ExecutionContext)this.requestExecutorContext());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Boolean2boolean((Boolean)((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])executorIds.toArray(ClassTag$.MODULE$.apply(String.class)))).delete()), (ExecutionContext)this.requestExecutorContext());
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new KubernetesDriverEndpoint(this, super.rpcEnv(), properties);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv, KubernetesClient kubernetesClient, ExecutorService requestExecutorsService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.kubernetesClient = kubernetesClient;
        this.requestExecutorsService = requestExecutorsService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, rpcEnv);
        this.requestExecutorContext = ExecutionContext$.MODULE$.fromExecutorService(requestExecutorsService);
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }
}

