/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.ui.SparkUI$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!\u0002\u000b\u0016\u0001m\t\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bU\u0002A\u0011\u0001\u001c\t\u000fe\u0002!\u0019!C\u0005u!1a\t\u0001Q\u0001\nmBqa\u0012\u0001C\u0002\u0013%!\b\u0003\u0004I\u0001\u0001\u0006Ia\u000f\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003;\u0011\u0019Q\u0005\u0001)A\u0005w!91\n\u0001b\u0001\n\u0013a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\nICa\u0001\u0017\u0001!\u0002\u0013\u0019\u0006bB-\u0001\u0005\u0004%IA\u0015\u0005\u00075\u0002\u0001\u000b\u0011B*\t\u000bm\u0003A\u0011\t/\t\u000b\t\u0004A\u0011I2\t\u000b\u001d\u0004A\u0011\t5\u0003-\t\u000b7/[2Ee&4XM\u001d$fCR,(/Z*uKBT!AF\f\u0002\u0011\u0019,\u0017\r^;sKNT!\u0001G\r\u0002\u0007-D4O\u0003\u0002\u001b7\u00051A-\u001a9m_fT!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\n\u0004\u0001\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\tQ#\u0003\u0002,+\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fAaY8oM\u000e\u0001\u0001cA\u00181e5\tq#\u0003\u00022/\tq1*\u001e2fe:,G/Z:D_:4\u0007CA\u00184\u0013\t!tC\u0001\u000fLk\n,'O\\3uKN$%/\u001b<feN\u0003XmY5gS\u000e\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t9\u0004\b\u0005\u0002*\u0001!)AF\u0001a\u0001]\u0005iAM]5wKJ\u0004v\u000e\u001a(b[\u0016,\u0012a\u000f\t\u0003y\rs!!P!\u0011\u0005y\"S\"A \u000b\u0005\u0001k\u0013A\u0002\u001fs_>$h(\u0003\u0002CI\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011E%\u0001\bee&4XM\u001d)pI:\u000bW.\u001a\u0011\u0002)\u0011\u0014\u0018N^3s\u0007>tG/Y5oKJLU.Y4f\u0003U!'/\u001b<fe\u000e{g\u000e^1j]\u0016\u0014\u0018*\\1hK\u0002\na\u0002\u001a:jm\u0016\u00148\t];D_J,7/A\bee&4XM]\"qk\u000e{'/Z:!\u0003A!'/\u001b<fe2KW.\u001b;D_J,7/F\u0001N!\r\u0019cjO\u0005\u0003\u001f\u0012\u0012aa\u00149uS>t\u0017!\u00053sSZ,'\u000fT5nSR\u001cuN]3tA\u0005yAM]5wKJlU-\\8ss6K')F\u0001T!\t\u0019C+\u0003\u0002VI\t!Aj\u001c8h\u0003A!'/\u001b<fe6+Wn\u001c:z\u001b&\u0014\u0005%A\tnK6|'/_(wKJDW-\u00193NS\n\u000b!#\\3n_JLxJ^3sQ\u0016\fG-T5CA\u0005YBM]5wKJlU-\\8ss^KG\u000f[(wKJDW-\u00193NS\n\u000bA\u0004\u001a:jm\u0016\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1e\u001b&\u0014\u0005%\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002^AB\u0011qFX\u0005\u0003?^\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006CF\u0001\r!X\u0001\u0004a>$\u0017\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012\u0001\u001a\t\u0005y\u0015\\4(\u0003\u0002g\u000b\n\u0019Q*\u00199\u0002A\u001d,G/\u00113eSRLwN\\1m\u0017V\u0014WM\u001d8fi\u0016\u001c(+Z:pkJ\u001cWm\u001d\u000b\u0002SB\u0019!n\u001c:\u000f\u0005-lgB\u0001 m\u0013\u0005)\u0013B\u00018%\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002oIA\u00111O`\u0007\u0002i*\u0011QO^\u0001\u0006[>$W\r\u001c\u0006\u0003ob\f1!\u00199j\u0015\tI(0\u0001\u0006lk\n,'O\\3uKNT!a\u001f?\u0002\u000f\u0019\f'M]5dq)\tQ0\u0001\u0002j_&\u0011q\u0010\u001e\u0002\f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018\r")
public class BasicDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesDriverSpecificConf> conf;
    private final String driverPodName;
    private final String driverContainerImage;
    private final String driverCpuCores;
    private final Option<String> driverLimitCores;
    private final long driverMemoryMiB;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    private String driverPodName() {
        return this.driverPodName;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private String driverCpuCores() {
        return this.driverCpuCores;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    private long driverMemoryMiB() {
        return this.driverMemoryMiB;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Seq driverCustomEnvs = (Seq)this.conf.roleEnvs().toSeq().map((Function1 & Serializable & scala.Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build(), Seq$.MODULE$.canBuildFrom());
        Quantity driverCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.driverCpuCores())).build();
        Quantity driverMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringBuilder(2).append(this.driverMemoryWithOverheadMiB()).append("Mi").toString())).build();
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> new Tuple2((Object)"cpu", (Object)((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build()));
        int driverPort = this.conf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        int driverUIPort = SparkUI$.MODULE$.getUIPort(this.conf.sparkConf());
        Container driverContainer = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).withName(Constants$.MODULE$.DRIVER_CONTAINER_NAME())).withImage(this.driverContainerImage())).withImagePullPolicy(this.conf.imagePullPolicy())).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverUIPort)).withProtocol("TCP")).endPort()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverCustomEnvs).asJava())).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).withNewResources().addToRequests("cpu", driverCpuQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap(Predef$.MODULE$.$conforms())).asJava()).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryQuantity)).endResources()).build();
        Pod driverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.roleLabels()).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.roleAnnotations()).asJava())).endMetadata()).withNewSpec().withRestartPolicy("Never").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.conf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(driverPod, driverContainer);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        scala.collection.mutable.Map additionalProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)this.driverPodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)this.conf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX().key()), (Object)this.conf.appResourceNamePrefix()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK().key()), (Object)"true")}));
        Iterable<String> resolvedSparkJars = KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)this.conf.sparkJars());
        Iterable<String> resolvedSparkFiles = KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)this.conf.sparkFiles());
        Object object = resolvedSparkJars.nonEmpty() ? additionalProps.put((Object)"spark.jars", (Object)resolvedSparkJars.mkString(",")) : BoxedUnit.UNIT;
        Object object2 = resolvedSparkFiles.nonEmpty() ? additionalProps.put((Object)"spark.files", (Object)resolvedSparkFiles.mkString(",")) : BoxedUnit.UNIT;
        return additionalProps.toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public BasicDriverFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> conf) {
        this.conf = conf;
        this.driverPodName = (String)((Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append($this.conf.appResourceNamePrefix()).append("-driver").toString());
        this.driverContainerImage = (String)conf.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the driver container image");
        });
        this.driverCpuCores = conf.get("spark.driver.cores", "1");
        this.driverLimitCores = (Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.driverMemoryMiB = BoxesRunTime.unboxToLong((Object)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)$this.conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.driverMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.driverMemoryWithOverheadMiB = this.driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

